/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.components.pack;

import io.github.fishstiz.fidgetz.gui.components.FidgetzButton;
import io.github.fishstiz.fidgetz.gui.components.FidgetzText;
import io.github.fishstiz.fidgetz.gui.components.ToggleableDialog;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuContainer;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuItemBuilder;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.MenuItem;
import io.github.fishstiz.fidgetz.gui.renderables.RenderableRect;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.fidgetz.gui.shapes.GuiRectangle;
import io.github.fishstiz.fidgetz.util.DrawUtil;
import io.github.fishstiz.fidgetz.util.lang.ObjectsUtil;
import io.github.fishstiz.packed_packs.gui.components.contextmenu.PackMenuHeader;
import io.github.fishstiz.packed_packs.gui.components.events.FileDeleteEvent;
import io.github.fishstiz.packed_packs.gui.components.events.FileRenameOpenEvent;
import io.github.fishstiz.packed_packs.gui.components.events.FolderCloseEvent;
import io.github.fishstiz.packed_packs.gui.components.events.PackListEvent;
import io.github.fishstiz.packed_packs.gui.components.events.PackListEventListener;
import io.github.fishstiz.packed_packs.gui.components.pack.FolderPackList;
import io.github.fishstiz.packed_packs.gui.components.pack.PackList;
import io.github.fishstiz.packed_packs.pack.PackAssetManager;
import io.github.fishstiz.packed_packs.pack.PackFileOperations;
import io.github.fishstiz.packed_packs.pack.PackOptionsContext;
import io.github.fishstiz.packed_packs.pack.folder.FolderPack;
import io.github.fishstiz.packed_packs.transform.interfaces.FilePack;
import io.github.fishstiz.packed_packs.util.PackUtil;
import io.github.fishstiz.packed_packs.util.constants.GuiConstants;
import java.nio.file.Path;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.repository.Pack;
import org.jetbrains.annotations.Nullable;

public class FolderDialog
extends ToggleableDialog<FolderPackList>
implements ContextMenuContainer {
    private static final Component BACK_TEXT = CommonComponents.GUI_BACK.copy().append(CommonComponents.ELLIPSIS);
    private static final int HEADER_HEIGHT = 16;
    private final FidgetzButton<Void> closeButton;
    private final FidgetzText<Void> folderTitle;
    private final PackFileOperations fileOps;
    private final PackListEventListener listener;
    private Sprite folderSprite = PackAssetManager.DEFAULT_FOLDER_ICON;
    private PackList parent;
    private FolderPack folderPack;

    public <S extends Screen & PackListEventListener> FolderDialog(S screen, PackOptionsContext options, PackAssetManager assets, PackFileOperations fileOps) {
        super(FolderDialog.builder(screen, (LayoutElement)new FolderPackList(options, assets, fileOps, screen)).setBackground((RenderableRect)DrawUtil.DEMO_BACKGROUND));
        this.listener = screen;
        this.fileOps = fileOps;
        this.closeButton = (FidgetzButton)this.addRenderableWidget((GuiEventListener)((FidgetzButton.Builder)FidgetzButton.builder().setOnPress(() -> this.sendEvent(new FolderCloseEvent((FolderPackList)this.root(), this.folderPack))).makeSquare(GuiConstants.CROSS_SPRITE.width)).spriteOnly().build());
        this.folderTitle = (FidgetzText)this.addRenderableWidget((GuiEventListener)((FidgetzText.Builder)FidgetzText.builder().setHeight(GuiConstants.CROSS_SPRITE.height)).setOffsetY(1).setShadow(true).build());
        ((FolderPackList)this.root()).visible = false;
        this.addListener(open -> {
            ((FolderPackList)this.root()).visible = open;
            if (!open.booleanValue()) {
                this.sendEvent(new FolderCloseEvent((FolderPackList)this.root(), this.folderPack));
            }
        });
        ((FolderPackList)this.root()).visitWidgets(arg_0 -> ((FolderDialog)this).addRenderableWidget(arg_0));
    }

    private void updateBounds() {
        GuiRectangle bounds = this.getBoundingBox();
        int parentX = bounds.getX();
        int parentY = bounds.getY();
        int parentWidth = bounds.getWidth();
        int parentHeight = bounds.getHeight();
        int left = parentX + 8;
        int top = parentY + 8;
        int right = parentX + parentWidth - 8;
        int bottom = parentY + parentHeight - 8;
        ((FolderPackList)this.root()).setPosition(left, top + 16 + 8);
        ((FolderPackList)this.root()).setWidth(right - left);
        ((FolderPackList)this.root()).setHeight(bottom - ((FolderPackList)this.root()).getY());
        this.closeButton.setPosition(left, top);
        this.folderTitle.setPosition(left + this.closeButton.getWidth() + 8, top);
        this.folderTitle.setWidth(bounds.getRight() - this.folderTitle.getX() - 16);
    }

    public void updateFolder(PackList parent, FolderPack folderPack, PackAssetManager assets) {
        this.parent = parent;
        this.folderPack = folderPack;
        this.folderTitle.setMessage(folderPack.getTitle());
        assets.getOrLoadIcon(folderPack, icon -> {
            this.folderSprite = icon;
        });
        this.setBoundingBox((LayoutElement)parent);
        this.updateBounds();
    }

    protected void renderBackground(GuiGraphics guiGraphics, int x, int y, int width, int height, int mouseX, int mouseY, float partialTick) {
        this.updateBounds();
        super.renderBackground(guiGraphics, x, y, width, height, mouseX, mouseY, partialTick);
    }

    protected void renderForeground(GuiGraphics guiGraphics, int x, int y, int width, int height, int mouseX, int mouseY, float partialTick) {
        int left = this.closeButton.getX();
        int top = this.closeButton.getY();
        this.folderSprite.renderClamped(guiGraphics, left, top, GuiConstants.CROSS_SPRITE.width, GuiConstants.CROSS_SPRITE.height, partialTick);
        if (this.closeButton.isHovered()) {
            GuiConstants.WHITE_OVERLAY.render(guiGraphics, left, top, GuiConstants.CROSS_SPRITE.width, GuiConstants.CROSS_SPRITE.height);
            GuiConstants.CROSS_SPRITE.render(guiGraphics, left, top);
        }
    }

    @Nullable
    public PackList getParent() {
        return this.parent;
    }

    @Nullable
    public FolderPack getFolderPack() {
        return this.folderPack;
    }

    public void buildItems(ContextMenuItemBuilder builder, int mouseX, int mouseY) {
        super.buildItems((ContextMenuItemBuilder)builder.when(this.folderPack != null && this.isOpen()).ifTrue(folderMenuBuilder -> folderMenuBuilder.add((MenuItem)new PackMenuHeader(this.folderPack, this.folderSprite)).simpleItem(BACK_TEXT, () -> this.setOpen(false)).when(((FolderPackList)this.root()).getChildAt(mouseX, mouseY).isEmpty()).ifTrue(b -> b.whenNonNull((Object)((Path)ObjectsUtil.mapOrNull((Object)this.folderPack, FilePack::packed_packs$getPath))).ifTrue((path, operationsMenuBuilder) -> operationsMenuBuilder.separator().simpleItem(GuiConstants.RENAME_FILE_TEXT, this::canOperateFolder, this::renameDirectory).simpleItem(GuiConstants.DELETE_FILE_TEXT, this::canOperateFolder, this::deleteDirectory).simpleItem(GuiConstants.OPEN_FILE_TEXT, () -> PackUtil.openPack(this.folderPack)).simpleItem(GuiConstants.OPEN_PARENT_TEXT, () -> PackUtil.openParent(this.folderPack))))), mouseX, mouseY);
    }

    private boolean canOperateFolder() {
        return ObjectsUtil.testNullable((Object)this.folderPack, this.fileOps::isOperable) && PackUtil.validatePackPath(this.folderPack) != null;
    }

    private void renameDirectory() {
        if (this.folderPack != null) {
            this.sendEvent(new FileRenameOpenEvent((PackList)this.root(), this.folderPack));
        }
    }

    private void deleteDirectory() {
        if (this.fileOps.deletePack(this.folderPack)) {
            this.setOpen(false);
            ((FolderPackList)this.root()).remove(this.folderPack);
            this.sendEvent(new FileDeleteEvent((PackList)this.root()));
        }
    }

    public void onRename(Pack pack, Component newName) {
        if (this.parent != null && pack == this.folderPack) {
            PackList.Entry entry = this.parent.getEntry(this.folderPack);
            if (entry != null) {
                entry.onRename(newName);
            }
            this.setOpen(false);
        }
    }

    private void sendEvent(PackListEvent event) {
        this.listener.onEvent(event);
    }
}

