/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.components.pack;

import io.github.fishstiz.fidgetz.gui.components.AbstractFixedListWidget;
import io.github.fishstiz.fidgetz.gui.components.ContainerEventHandlerPatch;
import io.github.fishstiz.fidgetz.gui.components.FidgetzButton;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuContainer;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuItemBuilder;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.MenuItem;
import io.github.fishstiz.fidgetz.gui.renderables.ColoredRect;
import io.github.fishstiz.fidgetz.util.DrawUtil;
import io.github.fishstiz.fidgetz.util.GuiUtil;
import io.github.fishstiz.fidgetz.util.lang.ObjectsUtil;
import io.github.fishstiz.packed_packs.compat.ModAdditions;
import io.github.fishstiz.packed_packs.config.Config;
import io.github.fishstiz.packed_packs.config.Preferences;
import io.github.fishstiz.packed_packs.gui.components.MouseSelectionHandler;
import io.github.fishstiz.packed_packs.gui.components.SelectionContext;
import io.github.fishstiz.packed_packs.gui.components.ToggleableHelper;
import io.github.fishstiz.packed_packs.gui.components.contextmenu.PackMenuHeader;
import io.github.fishstiz.packed_packs.gui.components.events.DragEvent;
import io.github.fishstiz.packed_packs.gui.components.events.DropEvent;
import io.github.fishstiz.packed_packs.gui.components.events.FileDeleteEvent;
import io.github.fishstiz.packed_packs.gui.components.events.FileRenameOpenEvent;
import io.github.fishstiz.packed_packs.gui.components.events.FolderOpenEvent;
import io.github.fishstiz.packed_packs.gui.components.events.MoveEvent;
import io.github.fishstiz.packed_packs.gui.components.events.PackAliasOpenEvent;
import io.github.fishstiz.packed_packs.gui.components.events.PackListEvent;
import io.github.fishstiz.packed_packs.gui.components.events.PackListEventListener;
import io.github.fishstiz.packed_packs.gui.components.events.RequestTransferEvent;
import io.github.fishstiz.packed_packs.gui.components.events.SelectionEvent;
import io.github.fishstiz.packed_packs.gui.components.pack.PackListDevMenu;
import io.github.fishstiz.packed_packs.gui.components.pack.PackListModel;
import io.github.fishstiz.packed_packs.gui.components.pack.PackWidget;
import io.github.fishstiz.packed_packs.gui.components.pack.Query;
import io.github.fishstiz.packed_packs.gui.history.Restorable;
import io.github.fishstiz.packed_packs.pack.PackAssetManager;
import io.github.fishstiz.packed_packs.pack.PackFileOperations;
import io.github.fishstiz.packed_packs.pack.PackOptionsContext;
import io.github.fishstiz.packed_packs.pack.folder.FolderPack;
import io.github.fishstiz.packed_packs.transform.interfaces.FilePack;
import io.github.fishstiz.packed_packs.util.InputUtil;
import io.github.fishstiz.packed_packs.util.PackUtil;
import io.github.fishstiz.packed_packs.util.ToastUtil;
import io.github.fishstiz.packed_packs.util.constants.GuiConstants;
import io.github.fishstiz.packed_packs.util.constants.Theme;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.repository.Pack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PackList
extends AbstractFixedListWidget<Entry>
implements Restorable<Snapshot>,
ContainerEventHandlerPatch,
ContextMenuContainer {
    protected static final int Y_OFFSET = 1;
    protected static final int ITEM_HEIGHT = 35;
    protected static final int ROW_GAP = 3;
    protected final PackOptionsContext options;
    protected final PackAssetManager assets;
    protected final PackListModel list;
    private final PackFileOperations fileOps;
    private final PackListEventListener listener;

    protected PackList(PackOptionsContext options, PackAssetManager assets, PackFileOperations fileOps, PackListEventListener listener) {
        super(35);
        this.assets = assets;
        this.options = options;
        this.fileOps = fileOps;
        this.listener = listener;
        this.list = new PackListModel(this.options);
    }

    @NotNull
    protected abstract Entry createEntry(SelectionContext<Pack> var1, int var2);

    @Nullable
    public Entry getEntry(@Nullable Pack pack) {
        if (pack == null) {
            return null;
        }
        for (Entry entry : this.children()) {
            if (!Objects.equals(entry.pack(), pack)) continue;
            return entry;
        }
        return null;
    }

    private void refreshEntries() {
        Entry focused = (Entry)this.getFocused();
        List selection = this.list.getSelection();
        List visiblePacks = this.list.getVisibleItems();
        this.clearEntries();
        for (int i = 0; i < visiblePacks.size(); ++i) {
            this.addEntry((AbstractSelectionList.Entry)this.createEntry(new SelectionContext<Pack>(selection, (Pack)visiblePacks.get(i)), i));
        }
        this.clampScrollAmount();
        this.setFocused((GuiEventListener)ObjectsUtil.mapOrNull((Object)((Object)focused), f -> this.getEntry(f.pack())));
    }

    protected void refreshList() {
        this.list.refresh();
        this.refreshEntries();
    }

    public void scrollToTop() {
        this.setScrollAmount(0.0);
    }

    public void reload(Collection<Pack> packs) {
        this.list.replaceAll(packs);
        this.setFocused(null);
        this.refresh();
    }

    @NotNull
    public List<Pack> copyPacks() {
        return List.copyOf(this.list.getItems());
    }

    public List<Pack> getOrderedSelection() {
        return this.list.getOrderedSelection();
    }

    public void clearSelection() {
        this.list.clearSelection();
    }

    private void refresh() {
        this.clearSelection();
        this.refreshList();
        this.scrollToTop();
    }

    public void sort(Query.SortOption sort) {
        if (this.list.sort(sort)) {
            this.refresh();
        }
    }

    public void hideIncompatible(boolean hideIncompatible) {
        if (this.list.hideIncompatible(hideIncompatible)) {
            this.clearSelection();
            this.refreshList();
        }
    }

    public void search(@NotNull String search) {
        if (this.list.search(search)) {
            this.refresh();
        }
    }

    public boolean isQueried() {
        return this.list.isQueried();
    }

    public void addAll(List<Pack> packs) {
        for (Pack pack : packs) {
            this.list.add(pack);
        }
        this.refreshList();
    }

    public void addOrMove(Pack pack, int to) {
        this.list.insertOrMove(to, pack);
        this.list.select(pack);
    }

    public boolean moveAll(List<Pack> selection, int to) {
        if (this.list.moveAll(to, selection)) {
            this.refreshList();
            return true;
        }
        return true;
    }

    private boolean removePack(Pack pack) {
        Entry focused = (Entry)this.getFocused();
        if (this.list.remove(pack)) {
            if (focused != null && focused.pack().getId().equals(pack.getId())) {
                this.setFocused(null);
            }
            return true;
        }
        return false;
    }

    public void remove(Pack pack) {
        this.removePack(pack);
        this.refreshList();
    }

    public void removeAll(List<Pack> packs) {
        boolean removed = false;
        for (Pack pack : packs) {
            removed |= this.removePack(pack);
        }
        if (removed) {
            this.refreshList();
        }
    }

    @Nullable
    public Pack getLastSelected() {
        return (Pack)this.list.getLastSelected();
    }

    @Nullable
    public Entry getSelected() {
        return this.getLastSelected() != null ? this.getEntry(this.getLastSelected()) : (Entry)super.getSelected();
    }

    public void setSelected(@Nullable Entry selected) {
        this.selected = selected;
    }

    public boolean isSelected(Pack pack) {
        return this.list.isSelected(pack);
    }

    public void scrollToLastSelected() {
        ObjectsUtil.ifPresent((Object)((Object)this.getEntry(this.getLastSelected())), x$0 -> this.scrollToEntry((AbstractSelectionList.Entry)x$0));
    }

    public void unselect(Pack pack) {
        this.list.unselect(pack);
        Entry entry = this.getEntry(pack);
        if (entry == this.getFocused()) {
            this.setFocused(null);
        }
        if (entry == this.getSelected()) {
            this.setSelected((Entry)null);
        }
    }

    public void select(Pack pack) {
        if (this.list.select(pack)) {
            Entry entry = this.getEntry(pack);
            this.setFocused((GuiEventListener)entry);
            this.setSelected(entry);
        }
    }

    public void selectAll() {
        this.list.getVisibleItems().forEach(this::select);
    }

    public void selectAll(List<Pack> packs) {
        packs.forEach(this::select);
    }

    public void selectExclusive(Pack pack) {
        this.clearSelection();
        this.select(pack);
    }

    public void selectToggle(Pack pack) {
        if (this.isSelected(pack)) {
            this.unselect(pack);
        } else {
            this.select(pack);
        }
    }

    public void selectRange(Pack pack) {
        this.list.selectRange(pack);
        this.select(pack);
    }

    public boolean isTransferable(Pack pack) {
        return ObjectsUtil.testNullable((Object)((Object)this.getEntry(pack)), Entry::isTransferable);
    }

    public void transferAll() {
        ArrayList<Pack> payload = new ArrayList<Pack>();
        List visiblePacks = this.list.getVisibleItems();
        for (int i = visiblePacks.size() - 1; i >= 0; --i) {
            Pack pack = (Pack)visiblePacks.get(i);
            if (!this.isTransferable(pack)) continue;
            payload.add(pack);
        }
        if (!payload.isEmpty()) {
            this.sendEvent(new RequestTransferEvent(this, this.getLastSelected(), payload));
        }
    }

    protected void sendEvent(PackListEvent event) {
        this.listener.onEvent(event);
    }

    public abstract boolean canInteract(PackList var1);

    protected abstract boolean canDrop(DragEvent var1, double var2, double var4);

    protected abstract List<Pack> handleDrop(DragEvent var1, double var2, double var4);

    public abstract void renderDroppableZone(GuiGraphics var1, DragEvent var2, int var3, int var4, float var5);

    public final void drop(DragEvent dragEvent, double mouseX, double mouseY) {
        if (this.options.isLocked()) {
            return;
        }
        List<Pack> dropped = this.handleDrop(dragEvent, mouseX, mouseY);
        if (!dropped.isEmpty()) {
            if (dragEvent.target() != this) {
                this.sendEvent(new DropEvent(dragEvent.target(), this, dropped));
            } else {
                this.sendEvent(new MoveEvent(this, dragEvent.trigger(), dropped));
            }
        }
    }

    protected void openFolder(FolderPack folderPack) {
        this.sendEvent(new FolderOpenEvent(this, folderPack));
    }

    @Nullable
    private ComponentPath handleArrowNavigation(FocusNavigationEvent.ArrowNavigation arrowNavigation) {
        Entry entry;
        switch (arrowNavigation.direction()) {
            case UP: {
                Entry entry2 = (Entry)this.getPreviousEntry();
                break;
            }
            case DOWN: {
                Entry entry2 = (Entry)this.getNextEntry();
                break;
            }
            default: {
                Entry entry2 = entry = null;
            }
        }
        if (entry != null) {
            if (InputUtil.isRangeModifierActive()) {
                this.selectRange(entry.pack());
            } else {
                this.selectExclusive(entry.pack());
            }
            this.sendEvent(new SelectionEvent(this));
            this.scrollToEntry((AbstractSelectionList.Entry)entry);
            return ComponentPath.path((GuiEventListener)entry, (ContainerEventHandler[])new ContainerEventHandler[]{this});
        }
        this.setFocused(null);
        return null;
    }

    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent event) {
        if (!this.isFocused()) {
            Pack lastSelected = this.getLastSelected();
            Entry entry = null;
            if (lastSelected != null) {
                entry = this.getEntry(lastSelected);
            } else if (!this.children().isEmpty()) {
                entry = (Entry)((Object)this.children().getFirst());
            }
            if (entry != null) {
                this.select(entry.pack());
                this.scrollToEntry((AbstractSelectionList.Entry)entry);
                return ComponentPath.path((GuiEventListener)entry, (ContainerEventHandler[])new ContainerEventHandler[]{this});
            }
        } else {
            if (event instanceof FocusNavigationEvent.ArrowNavigation) {
                FocusNavigationEvent.ArrowNavigation arrowNavigation = (FocusNavigationEvent.ArrowNavigation)event;
                return this.handleArrowNavigation(arrowNavigation);
            }
            this.setFocused(null);
        }
        return null;
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        Entry entry = this.getEntry(this.getLastSelected());
        if (InputUtil.isExpandFolder(keyEvent) && entry != null && entry.folderWidget != null && this.list.getSelection().size() == 1) {
            this.openFolder((FolderPack)entry.folderWidget.getMetadata());
            return true;
        }
        if (InputUtil.isTransfer(keyEvent)) {
            if (entry != null && entry.transfer()) {
                GuiUtil.playClickSound();
            }
            return entry != null;
        }
        return super.keyPressed(keyEvent);
    }

    public boolean mouseClicked(MouseButtonEvent mouseButtonEvent, boolean doubleClicked) {
        boolean scrolling = this.updateScrolling(mouseButtonEvent);
        return this.isMouseOver(mouseButtonEvent.x(), mouseButtonEvent.y()) && super.mouseClickedAt(mouseButtonEvent, doubleClicked) || scrolling;
    }

    protected void renderListItems(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderListItems(guiGraphics, mouseX, mouseY, partialTick);
        Entry focused = (Entry)this.getFocused();
        if (focused != null && focused.isFocused() && this.children().contains((Object)focused)) {
            int outlineTop = focused.getY();
            int outlineHeight = focused.getHeight() + 1;
            DrawUtil.renderOutline((GuiGraphics)guiGraphics, (int)focused.getX(), (int)outlineTop, (int)focused.getWidth(), (int)outlineHeight, (int)Theme.WHITE.getARGB());
        }
    }

    public int maxScrollAmount() {
        int maxScrollAmount = super.maxScrollAmount();
        return maxScrollAmount > 0 ? maxScrollAmount + 1 : maxScrollAmount;
    }

    @Override
    @NotNull
    public Snapshot captureState(String eventName) {
        return new Snapshot(this);
    }

    @Override
    public void replaceState(@NotNull Snapshot snapshot) {
        snapshot.model.restore();
        this.refreshEntries();
        this.setFocused((GuiEventListener)this.getEntry(snapshot.focused));
        this.setSelected(this.getEntry(snapshot.selected));
    }

    @Nullable
    private static Pack extractPack(@Nullable Entry entry) {
        return (Pack)ObjectsUtil.mapOrNull((Object)((Object)entry), Entry::pack);
    }

    public abstract class Entry
    extends AbstractFixedListWidget.Entry
    implements ContainerEventHandlerPatch,
    ContextMenuContainer {
        private static final int V_MARGIN = 2;
        private static final int BACKGROUND_MARGIN = 1;
        private static final Tooltip FOLDER_OPEN_INFO = Tooltip.create((Component)FolderPack.FOLDER_OPEN_TEXT);
        protected static final int H_SPACING = 2;
        protected static final ColoredRect SELECTED_OVERLAY = new ColoredRect(Theme.BLUE_500.withAlpha(0.25f));
        protected final SelectionContext<Pack> context;
        private final List<GuiEventListener> children;
        private final List<Renderable> renderables;
        private final List<Renderable> topRenderables;
        private final List<NarratableEntry> narratables;
        private final MouseSelectionHandler<Pack> selectionHandler;
        private final PackWidget packWidget;
        @Nullable
        private final PackListDevMenu devMenu;
        private FidgetzButton<FolderPack> folderWidget;
        private boolean stale;

        protected Entry(SelectionContext<Pack> context, int index) {
            super((AbstractFixedListWidget)PackList.this, index);
            this.children = new ObjectArrayList();
            this.renderables = new ObjectArrayList();
            this.topRenderables = new ObjectArrayList();
            this.narratables = new ObjectArrayList();
            this.stale = false;
            this.context = context;
            this.selectionHandler = new MouseSelectionHandler<Pack>((GuiEventListener)this, context);
            this.packWidget = this.addRenderableWidget(new PackWidget(this.pack(), PackList.this.assets, this.getX(), PackList.this.getRowTop(this.index), this.getWidth(), 32, 2));
            boolean devMode = Config.get().isDevMode();
            Pack pack = this.pack();
            if (pack instanceof FolderPack) {
                FolderPack folderPack = (FolderPack)pack;
                if (devMode || Preferences.INSTANCE.folderPackWidget.get().booleanValue()) {
                    this.folderWidget = this.addTopRenderableOnly(this.prependWidget(((FidgetzButton.Builder)((FidgetzButton.Builder)ToggleableHelper.applyPref(Preferences.INSTANCE.folderPackWidget, FidgetzButton.builder()).setTooltip(FOLDER_OPEN_INFO).setHeight(this.packWidget.getHeight() / 3)).makeSquare()).setSprite(GuiConstants.HAMBURGER_SPRITE).setFocusOnInteract(false).setMetadata((Object)folderPack).setOnPress(this::openFolder).build()));
                }
            }
            this.devMenu = devMode ? new PackListDevMenu(PackList.this.minecraft, PackList.this.options, this.context, this::handleDevMenuEvent) : null;
            ModAdditions.onCreateEntry(PackList.this.options.getConfig().packType(), this);
        }

        public Pack pack() {
            return this.context.item();
        }

        public <U extends GuiEventListener & Renderable> U addRenderableWidget(U widget) {
            this.children.add(widget);
            this.renderables.add(widget);
            if (widget instanceof NarratableEntry) {
                NarratableEntry narratable = (NarratableEntry)widget;
                this.narratables.add(narratable);
            }
            return widget;
        }

        public <U extends GuiEventListener> U prependWidget(U widget) {
            this.children.addFirst(widget);
            if (widget instanceof NarratableEntry) {
                NarratableEntry narratable = (NarratableEntry)widget;
                this.narratables.add(narratable);
            }
            return widget;
        }

        public <U extends Renderable> U addTopRenderableOnly(U renderable) {
            this.topRenderables.add(renderable);
            return renderable;
        }

        public boolean isTransferable() {
            return !PackList.this.options.isLocked() && !this.isStale();
        }

        public boolean isSelected() {
            return this.context.isSelected();
        }

        public boolean isSelectedLast() {
            return this.context.isSelectedLast();
        }

        protected void sendPacks(Pack trigger, List<Pack> payload) {
            PackList.this.sendEvent(new RequestTransferEvent(PackList.this, trigger, payload));
        }

        private boolean sendSelection() {
            ObjectArrayList payload = new ObjectArrayList();
            for (Pack selected : PackList.this.getOrderedSelection().reversed()) {
                if (!PackList.this.isTransferable(selected)) continue;
                payload.add(selected);
            }
            if (!payload.isEmpty()) {
                Pack trigger = this.isTransferable() ? this.pack() : null;
                this.sendPacks(trigger, (List<Pack>)payload);
                return true;
            }
            return false;
        }

        public boolean transfer() {
            if (!this.isSelected() && this.isTransferable()) {
                PackList.this.sendEvent(new RequestTransferEvent(PackList.this, this.pack()));
                return true;
            }
            return this.sendSelection();
        }

        protected boolean handleMouseAction(MouseSelectionHandler.Action action) {
            if (!action.shouldDispatch() || this.isStale()) {
                return false;
            }
            switch (action) {
                case SELECT: {
                    PackList.this.select(this.pack());
                    break;
                }
                case SELECT_TOGGLE: {
                    PackList.this.selectToggle(this.pack());
                    break;
                }
                case SELECT_EXCLUSIVE: {
                    PackList.this.selectExclusive(this.pack());
                    break;
                }
                case SELECT_RANGE: {
                    PackList.this.selectRange(this.pack());
                    break;
                }
                case TRANSFER: {
                    if (!this.isTransferable()) break;
                    PackList.this.sendEvent(new RequestTransferEvent(PackList.this, this.pack()));
                    return false;
                }
                case DRAG: {
                    PackList.this.sendEvent(new DragEvent(PackList.this, (List<Pack>)PackList.this.getOrderedSelection().reversed(), this.pack()));
                }
            }
            if (action.shouldSelect()) {
                PackList.this.sendEvent(new SelectionEvent(PackList.this));
            }
            return true;
        }

        public boolean isMouseOver(double mouseX, double mouseY) {
            return PackList.this.beforeScrollbarX(mouseX) && super.isMouseOver(mouseX, mouseY);
        }

        public boolean mouseClicked(MouseButtonEvent mouseButtonEvent, boolean doubleClicked) {
            if (super.mouseClicked(mouseButtonEvent, doubleClicked)) {
                return false;
            }
            return this.handleMouseAction(this.selectionHandler.mouseClicked(mouseButtonEvent));
        }

        public boolean mouseReleased(MouseButtonEvent mouseButtonEvent) {
            return this.handleMouseAction(this.selectionHandler.mouseReleased(mouseButtonEvent));
        }

        public boolean mouseDragged(MouseButtonEvent mouseButtonEvent, double dragX, double dragY) {
            return this.handleMouseAction(this.selectionHandler.mouseDragged(mouseButtonEvent, dragX, dragY));
        }

        public boolean keyPressed(KeyEvent keyEvent) {
            if (super.keyPressed(keyEvent)) {
                return true;
            }
            if (InputUtil.isOpenFile(keyEvent)) {
                PackUtil.openPack(this.pack());
                return true;
            }
            if (InputUtil.isOpenFolder(keyEvent)) {
                PackUtil.openParent(this.pack());
                return true;
            }
            if (InputUtil.isDelete(keyEvent) && this.canOperateFile()) {
                this.deletePack();
                return true;
            }
            if (InputUtil.isRename(keyEvent) && this.canOperateFile()) {
                this.renamePack();
                return true;
            }
            return false;
        }

        public void renderBack(GuiGraphics guiGraphics, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            if (!this.pack().getCompatibility().isCompatible() && !PackList.this.options.getUserConfig().isIncompatibleWarningsHidden()) {
                int backgroundLeft = left + 1;
                int backgroundTop = top + 1;
                int backgroundRight = backgroundLeft + width - 2;
                int backgroundBottom = backgroundTop + height - 1;
                guiGraphics.fill(backgroundLeft, backgroundTop, backgroundRight, backgroundBottom, Theme.RED_900.getARGB());
            }
        }

        protected abstract void renderForeground(GuiGraphics var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, float var9);

        private void renderSelection(GuiGraphics guiGraphics, int top, int left, int width, int height) {
            if (this.isSelected()) {
                ((ColoredRect)ObjectsUtil.pick((boolean)this.isSelectedLast(), (Object)GuiConstants.WHITE_OVERLAY, (Object)SELECTED_OVERLAY)).render(guiGraphics, left, top, width, height);
                DrawUtil.renderOutline((GuiGraphics)guiGraphics, (int)left, (int)top, (int)width, (int)height, (int)Theme.BLUE_500.getARGB());
            }
        }

        protected void renderTop(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            if (this.folderWidget != null) {
                int folderWidgetY = this.getBottom() - this.folderWidget.getHeight() - 1;
                this.folderWidget.setPosition(this.packWidget.getContentLeft(), folderWidgetY);
            }
            for (Renderable renderable : this.topRenderables) {
                renderable.render(guiGraphics, mouseX, mouseY, partialTick);
            }
        }

        public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovering, float partialTick) {
            hovering = hovering && PackList.this.beforeScrollbarX(mouseX) && GuiUtil.isHovered((GuiEventListener)this, (double)mouseX, (double)mouseY);
            int left = this.getX();
            int top = this.getY();
            int width = this.getWidth();
            int height = this.getHeight();
            int innerTop = top + 2;
            int innerHeight = height - 3;
            this.packWidget.setPosition(left, innerTop);
            this.packWidget.setWidth(width);
            this.renderBack(guiGraphics, top, left, width, height, mouseX, mouseY, hovering, partialTick);
            for (Renderable renderable : this.renderables) {
                renderable.render(guiGraphics, mouseX, mouseY, partialTick);
            }
            this.renderSelection(guiGraphics, top, left, width, height + 1);
            this.renderForeground(guiGraphics, innerTop, left, width, innerHeight, mouseX, mouseY, hovering, partialTick);
            this.renderTop(guiGraphics, mouseX, mouseY, partialTick);
            if (this.devMenu != null) {
                this.devMenu.renderDevSprites(guiGraphics, innerTop, left, width);
            }
        }

        protected void handleDevMenuEvent(PackListDevMenu.Event<?> event) {
            if (event instanceof PackListDevMenu.Event.EditAliases) {
                PackListDevMenu.Event.EditAliases editAliases = (PackListDevMenu.Event.EditAliases)event;
                PackList.this.sendEvent(new PackAliasOpenEvent(PackList.this, editAliases.trigger()));
            }
        }

        public void buildItems(ContextMenuItemBuilder builder, int mouseX, int mouseY) {
            PackList.this.setFocused((GuiEventListener)this);
            super.buildItems((ContextMenuItemBuilder)builder.add((MenuItem)new PackMenuHeader(this.pack(), this.packWidget.getSprite())).whenNonNull((Object)this.devMenu).ifTrue(PackListDevMenu::onBuildHeader).whenNonNull(this.folderWidget).ifTrue(b -> b.simpleItem(FolderPack.FOLDER_OPEN_TEXT, this::openFolder).separator()).whenNonNull((Object)((FilePack)this.pack()).packed_packs$getPath()).ifTrue(b -> b.simpleItem(GuiConstants.RENAME_FILE_TEXT, this::canOperateFile, this::renamePack).simpleItem(GuiConstants.DELETE_FILE_TEXT, this::canOperateFile, this::deletePack).simpleItem(GuiConstants.OPEN_FILE_TEXT, () -> PackUtil.openPack(this.pack())).simpleItem(GuiConstants.OPEN_PARENT_TEXT, () -> PackUtil.openParent(this.pack()))), mouseX, mouseY);
        }

        private void openFolder() {
            PackList.this.openFolder((FolderPack)Objects.requireNonNull(this.folderWidget, "Cannot open folder without folder widget").getMetadata());
        }

        public boolean canOperateFile() {
            return PackList.this.fileOps.isOperable(this.pack());
        }

        public void deletePack() {
            if (PackList.this.fileOps.deletePack(this.pack())) {
                this.stale = true;
                PackList.this.remove(this.pack());
                PackList.this.sendEvent(new FileDeleteEvent(PackList.this));
            } else {
                ToastUtil.onFileFailToast(ToastUtil.getDeleteFailText(this.pack().getTitle().getString()));
            }
        }

        public void renamePack() {
            PackList.this.sendEvent(new FileRenameOpenEvent(PackList.this, this.pack()));
        }

        public void onRename(Component newName) {
            this.stale = true;
            this.packWidget.onRename(newName);
            if (this.folderWidget != null) {
                this.folderWidget.active = false;
            }
        }

        public boolean isStale() {
            return this.stale;
        }

        @NotNull
        public List<GuiEventListener> children() {
            return this.children;
        }

        @NotNull
        public List<NarratableEntry> narratables() {
            return this.narratables;
        }
    }

    public static final class Snapshot
    extends Record
    implements Restorable.Snapshot<Snapshot> {
        private final PackList target;
        @Nullable
        private final Pack focused;
        @Nullable
        private final Pack selected;
        private final PackListModel.Snapshot model;

        public Snapshot(PackList target, PackListModel.Snapshot model) {
            this(target, PackList.extractPack((Entry)target.getFocused()), PackList.extractPack(target.getSelected()), model);
        }

        public Snapshot(PackList target) {
            this(target, (PackListModel.Snapshot)target.list.captureState());
        }

        public Snapshot(PackList target, @Nullable Pack focused, @Nullable Pack selected, PackListModel.Snapshot model) {
            this.target = target;
            this.focused = focused;
            this.selected = selected;
            this.model = model;
        }

        public Snapshot replaceAll(List<Pack> packs) {
            return new Snapshot(this.target, this.focused, this.selected, this.model.replaceAll(packs));
        }

        public Snapshot retainAll(Set<Pack> packs) {
            return new Snapshot(this.target, this.focused, this.selected, this.model.retainAll(packs));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Snapshot.class, "target;focused;selected;model", "target", "focused", "selected", "model"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Snapshot.class, "target;focused;selected;model", "target", "focused", "selected", "model"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Snapshot.class, "target;focused;selected;model", "target", "focused", "selected", "model"}, this, o);
        }

        public PackList target() {
            return this.target;
        }

        @Nullable
        public Pack focused() {
            return this.focused;
        }

        @Nullable
        public Pack selected() {
            return this.selected;
        }

        public PackListModel.Snapshot model() {
            return this.model;
        }
    }
}

