/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.components.profile;

import io.github.fishstiz.fidgetz.gui.components.AbstractFixedListWidget;
import io.github.fishstiz.fidgetz.gui.components.FidgetzButton;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuContainer;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuItemBuilder;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuProvider;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.ButtonSprites;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.fidgetz.util.ARGBColor;
import io.github.fishstiz.fidgetz.util.DrawUtil;
import io.github.fishstiz.fidgetz.util.GuiUtil;
import io.github.fishstiz.fidgetz.util.debounce.PollingDebouncer;
import io.github.fishstiz.fidgetz.util.debounce.SimplePollingDebouncer;
import io.github.fishstiz.packed_packs.config.Config;
import io.github.fishstiz.packed_packs.config.DevConfig;
import io.github.fishstiz.packed_packs.config.Profile;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import io.github.fishstiz.packed_packs.util.constants.GuiConstants;
import io.github.fishstiz.packed_packs.util.constants.Theme;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProfileList
extends AbstractFixedListWidget<Entry>
implements ContextMenuContainer {
    private static final int ITEM_HEIGHT = 20;
    private static final Component EMPTY_TEXT = ResourceUtil.getText("profile.empty", new Object[0]);
    private static final Component DELETE_TEXT = ResourceUtil.getText("profile.delete", new Object[0]);
    private static final Tooltip DELETE_INFO = Tooltip.create((Component)ResourceUtil.getText("profile.delete.info", new Object[0]));
    private static final Sprite TRASH_SPRITE = Sprite.of16((ResourceLocation)ResourceUtil.getIcon("trash"));
    private static final Sprite STAR_OUTLINE_SPRITE = Sprite.of16((ResourceLocation)ResourceUtil.getIcon("star_outline"));
    private final PollingDebouncer<Void> debouncedRefresh = new SimplePollingDebouncer(this::refresh, 200L);
    private final BiConsumer<Profile, Profile> selectListener;
    private final Consumer<Profile> updateListener;
    private final Config.Packs userConfig;
    private final DevConfig.Packs config;
    @Nullable
    private Profile selectedProfile;

    public ProfileList(Config.Packs userConfig, DevConfig.Packs Config2, BiConsumer<Profile, Profile> selectListener, Consumer<Profile> updateListener) {
        super(20);
        this.userConfig = userConfig;
        this.config = Config2;
        this.selectListener = selectListener;
        this.updateListener = updateListener;
    }

    public void scheduleRefresh() {
        this.debouncedRefresh.run();
    }

    public void refresh() {
        this.clearEntries();
        int i = 0;
        Profile defaultProfile = this.config.getDefaultProfile();
        if (defaultProfile != null) {
            this.addEntry((AbstractSelectionList.Entry)new Entry(defaultProfile, i++));
        }
        List<Profile> profiles = this.userConfig.getProfiles();
        for (Profile profile : profiles) {
            if (defaultProfile != null && Objects.equals(profile.getId(), defaultProfile.getId())) continue;
            this.addEntry((AbstractSelectionList.Entry)new Entry(profile, i++));
        }
    }

    @Nullable
    public Profile getSelectedProfile() {
        return this.selectedProfile;
    }

    public void selectProfile(@Nullable Profile profile) {
        Profile previous = this.selectedProfile;
        this.selectedProfile = profile;
        this.selectListener.accept(previous, profile);
        this.updateListener.accept(profile);
    }

    public void removeProfile(Profile profile) {
        if (profile != null && this.selectedProfile == profile) {
            List<Profile> profiles = this.userConfig.getProfiles();
            if (!profiles.isEmpty()) {
                int index = profiles.indexOf(profile);
                Profile previous = index > 0 ? profiles.get(index - 1) : null;
                this.selectProfile(previous);
            } else {
                this.selectProfile(null);
            }
        }
        if (profile != null) {
            this.userConfig.removeProfile(profile);
        }
        this.refresh();
    }

    private void resync() {
        this.selectListener.accept(this.selectedProfile, this.selectedProfile);
        this.updateListener.accept(this.selectedProfile);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.debouncedRefresh.poll();
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        if (this.children().isEmpty()) {
            ProfileList.renderScrollingString((GuiGraphics)guiGraphics, (Font)this.minecraft.font, (Component)EMPTY_TEXT, (int)(this.getX() + 8), (int)(this.getY() + 8), (int)(this.getRight() - 8), (int)(this.getBottom() - 8), (int)Theme.WHITE.getARGB());
        }
    }

    public class Entry
    extends AbstractFixedListWidget.Entry
    implements ContextMenuProvider {
        private final Profile profile;
        private final List<FidgetzButton<Void>> children;
        private final FidgetzButton<Void> selectButton;
        private final FidgetzButton<Void> deleteButton;

        protected Entry(Profile profile, int index) {
            super((AbstractFixedListWidget)ProfileList.this, index);
            this.children = new ArrayList<FidgetzButton<Void>>();
            this.profile = profile;
            this.deleteButton = ((FidgetzButton.Builder)FidgetzButton.builder().makeSquare(this.getHeight())).setMessage(DELETE_TEXT).setSprite(this.isDefault() ? ButtonSprites.of((Sprite)GuiConstants.STAR_SPRITE) : (profile.isLocked() ? ButtonSprites.unclamp((Sprite)GuiConstants.LOCK_SPRITE) : ButtonSprites.of((Sprite)TRASH_SPRITE))).setOnPress(this::remove).build();
            boolean bl = this.deleteButton.active = !profile.isLocked() && !this.isDefault();
            if (this.deleteButton.active) {
                this.deleteButton.setTooltip(DELETE_INFO);
            }
            this.selectButton = FidgetzButton.builder().setMessage((Component)Component.literal((String)this.profile.getName())).setOnPress(this::select).build();
            this.children.add(this.deleteButton);
            this.children.add(this.selectButton);
        }

        public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovering, float partialTick) {
            this.selectButton.active = ProfileList.this.selectedProfile != this.profile;
            int left = this.getX();
            int top = this.getY();
            this.deleteButton.setPosition(left, top);
            this.selectButton.setPosition(left + this.deleteButton.getWidth(), top);
            this.selectButton.setWidth(ProfileList.this.width - this.deleteButton.getWidth());
            this.deleteButton.render(guiGraphics, mouseX, mouseY, partialTick);
            this.selectButton.render(guiGraphics, mouseX, mouseY, partialTick);
            if (Config.get().isDevMode()) {
                boolean hovered;
                int borderColor;
                boolean hasProperty = true;
                int width = this.getWidth();
                int height = this.getHeight();
                if (this.isDefault() && this.profile.isLocked()) {
                    borderColor = Theme.PURPLE_500.getARGB();
                } else if (this.isDefault()) {
                    borderColor = Theme.BLUE_500.getARGB();
                } else if (this.profile.isLocked()) {
                    borderColor = Theme.RED_700.getARGB();
                } else {
                    borderColor = Theme.WHITE.getARGB();
                    hasProperty = false;
                }
                boolean bl = hovered = guiGraphics.containsPointInScissor(mouseX, mouseY) && GuiUtil.isHovered((GuiEventListener)this, (double)mouseX, (double)mouseY);
                if (hasProperty || hovered) {
                    DrawUtil.renderOutline((GuiGraphics)guiGraphics, (int)left, (int)top, (int)width, (int)height, (int)borderColor);
                }
                if (hovered) {
                    int foregroundColor = ARGBColor.withAlpha((int)borderColor, (float)0.25f);
                    guiGraphics.fill(left, top, left + width, top + height, foregroundColor);
                }
            }
        }

        private void toggleLock() {
            boolean selected = this.isSelected();
            if (selected) {
                ProfileList.this.resync();
            }
            this.profile.setLocked(!this.profile.isLocked());
            ProfileList.this.refresh();
            if (selected) {
                ProfileList.this.updateListener.accept(this.profile);
            }
        }

        private void toggleDefault() {
            ProfileList.this.config.setDefaultProfile(this.isDefault() ? null : this.profile);
            ProfileList.this.refresh();
            if (!this.isSelected() && this.isDefault()) {
                this.select();
            } else {
                ProfileList.this.resync();
            }
        }

        private void remove() {
            ProfileList.this.removeProfile(this.profile);
        }

        private void select() {
            ProfileList.this.selectProfile(this.profile);
        }

        private boolean isDefault() {
            return Objects.equals(this.profile, ProfileList.this.config.getDefaultProfile());
        }

        private boolean isSelected() {
            return Objects.equals(this.profile, ProfileList.this.selectedProfile);
        }

        @NotNull
        public List<? extends GuiEventListener> children() {
            return this.children;
        }

        @NotNull
        public List<? extends NarratableEntry> narratables() {
            return this.children;
        }

        public void visitWidgets(Consumer<AbstractWidget> consumer) {
            this.children.forEach(consumer);
        }

        public void buildItems(ContextMenuItemBuilder builder, int mouseX, int mouseY) {
            if (!Config.get().isDevMode()) {
                return;
            }
            builder.separatorIfNonEmpty();
            builder.add(GuiConstants.devItem((Component)ResourceUtil.getText("profile.default." + (this.isDefault() ? "unset" : "set"), new Object[0])).icon(() -> this.isDefault() ? GuiConstants.STAR_SPRITE : STAR_OUTLINE_SPRITE).action(this::toggleDefault).build());
            builder.add(GuiConstants.devItem((Component)ResourceUtil.getText("profile." + (this.profile.isLocked() ? "unlock" : "lock"), new Object[0])).icon(this.profile.isLocked() ? GuiConstants.LOCK_SPRITE_SMALL : GuiConstants.UNLOCK_SPRITE_SMALL).action(this::toggleLock).build());
        }
    }
}

