/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.pack;

import io.github.fishstiz.packed_packs.PackedPacks;
import io.github.fishstiz.packed_packs.config.Config;
import io.github.fishstiz.packed_packs.config.DevConfig;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.packs.repository.Pack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackAliasMap
implements Map<String, Pack> {
    private final DevConfig.Packs config;
    private final Map<String, Pack> map;
    private Set<String> unresolvedIds;

    public PackAliasMap(DevConfig.Packs config, Map<String, Pack> map) {
        this.config = config;
        this.map = map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key) || this.resolvePackId(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Pack get(Object key) {
        Pack pack = this.map.get(key);
        if (pack != null) {
            return pack;
        }
        return this.resolvePackId(key);
    }

    @Override
    @Nullable
    public Pack put(String key, Pack value) {
        return this.map.put(key, value);
    }

    @Override
    public Pack remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(@NotNull Map<? extends String, ? extends Pack> m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    @NotNull
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    @NotNull
    public Collection<Pack> values() {
        return this.map.values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<String, Pack>> entrySet() {
        return this.map.entrySet();
    }

    @Nullable
    private Pack resolvePackId(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        String packId = (String)key;
        if (this.unresolvedIds != null && this.unresolvedIds.contains(key)) {
            return null;
        }
        String resolvedPackId = this.config.getAndSaveCanonicalId(Config.get().get(this.config.packType()).getProfiles(), packId);
        if (resolvedPackId != null) {
            Pack resolvedPack = this.map.get(resolvedPackId);
            if (resolvedPack != null) {
                PackedPacks.LOGGER.info("[packed_packs] Resolved unknown pack '{}' to '{}'.", (Object)packId, (Object)resolvedPackId);
                this.put(resolvedPackId, resolvedPack);
            } else {
                PackedPacks.LOGGER.warn("[packed_packs] Unknown pack '{}' resolved to '{}', but no such pack is available.", (Object)packId, (Object)resolvedPackId);
                this.setUnresolved(packId);
            }
            return resolvedPack;
        }
        this.setUnresolved(packId);
        return null;
    }

    private void setUnresolved(String packId) {
        if (this.unresolvedIds == null) {
            this.unresolvedIds = new ObjectOpenHashSet();
        }
        this.unresolvedIds.add(packId);
    }
}

