/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.pack;

import com.google.common.collect.ImmutableList;
import io.github.fishstiz.fidgetz.util.lang.CollectionsUtil;
import io.github.fishstiz.fidgetz.util.lang.FunctionsUtil;
import io.github.fishstiz.fidgetz.util.lang.ObjectsUtil;
import io.github.fishstiz.packed_packs.PackedPacks;
import io.github.fishstiz.packed_packs.config.Folder;
import io.github.fishstiz.packed_packs.pack.PackAssetManager;
import io.github.fishstiz.packed_packs.pack.PackGroup;
import io.github.fishstiz.packed_packs.pack.PackOptionsContext;
import io.github.fishstiz.packed_packs.pack.folder.FolderPack;
import io.github.fishstiz.packed_packs.transform.interfaces.FilePack;
import io.github.fishstiz.packed_packs.transform.mixin.PackSelectionModelAccessor;
import io.github.fishstiz.packed_packs.transform.mixin.folders.additional.FolderRepositorySourceAccessor;
import io.github.fishstiz.packed_packs.transform.mixin.folders.additional.PackRepositoryAccessor;
import io.github.fishstiz.packed_packs.util.PackUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.screens.packs.PackSelectionModel;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import org.jetbrains.annotations.Nullable;

public class PackRepositoryManager {
    private final Map<String, Pack> availablePacks = new Object2ObjectLinkedOpenHashMap();
    private final Map<String, List<Pack>> folderPacks = new Object2ObjectOpenHashMap();
    private final Map<String, CompletableFuture<Folder>> folderConfigs = new Object2ObjectOpenHashMap();
    private final Set<String> selectedPacksCache = new ObjectOpenHashSet();
    private final PackRepository repository;
    private final PackOptionsContext options;
    private final Path packDir;
    private PackSelectionModel model;

    public PackRepositoryManager(PackRepository repository, PackOptionsContext options, Path packDir) {
        this.repository = repository;
        this.options = options;
        this.packDir = packDir;
        this.refreshModel();
        this.regenerateAvailablePacks();
    }

    public PackRepository getRepository() {
        return this.repository;
    }

    private List<Pack> getSelectedPacks() {
        return ((PackSelectionModelAccessor)this.model).getSelectedPacks();
    }

    private List<Pack> getUnselectedPacks() {
        return ((PackSelectionModelAccessor)this.model).getUnselectedPacks();
    }

    private void refreshModel() {
        this.model = new PackSelectionModel(FunctionsUtil.nopConsumer(), PackAssetManager::getDefaultLocation, this.repository, FunctionsUtil.nopConsumer());
        ((PackSelectionModelAccessor)this.model).packed_packs$filterHidden(false);
    }

    public List<Pack> getPacks() {
        return List.copyOf(this.availablePacks.values());
    }

    public PackGroup getPacksBySelected() {
        return this.validateAndGroupPacks(this.getUnselectedPacks(), this.getSelectedPacks());
    }

    public void removePack(Pack pack) {
        if (pack instanceof FolderPack) {
            ObjectsUtil.ifPresent(this.folderPacks.get(pack.getId()), packs -> packs.forEach(this::removePack));
            this.folderPacks.remove(pack.getId());
            this.folderConfigs.remove(pack.getId());
        }
        this.repository.removePack(pack.getId());
        this.availablePacks.remove(pack.getId());
        try {
            this.getSelectedPacks().remove(pack);
            this.getUnselectedPacks().remove(pack);
        }
        catch (UnsupportedOperationException e) {
            PackedPacks.LOGGER.warn("[packed_packs] Failed to mutate PackSelectionModel lists. Report this issue to mod author.");
        }
    }

    public PackGroup validateAndGroupPacks(List<Pack> unselected, List<Pack> selected) {
        return this.validatePacks(this.groupByFolders(unselected), this.groupByFolders(selected));
    }

    private void addValidPacks(List<Pack> source, Set<Pack> seen, ObjectOpenHashSet<Pack> validPacks, List<Pack> target) {
        for (Pack pack : source) {
            this.options.validate(pack);
            Pack validPack = (Pack)validPacks.get((Object)pack);
            if (validPack == null || !seen.add(pack)) continue;
            target.add(validPack);
        }
    }

    private void addValidPacks(List<Pack> source, Set<Pack> seen, ObjectOpenHashSet<Pack> validPacks, List<Pack> targetUnselected, List<Pack> targetSelected) {
        for (Pack pack : source) {
            this.options.validate(pack);
            Pack validPack = (Pack)validPacks.get((Object)pack);
            if (validPack == null || !seen.add(pack)) continue;
            if (this.options.isRequired(validPack)) {
                this.options.getPosition(validPack).insert(targetSelected, (Object)validPack, this.options::getSelectionConfig, true);
                continue;
            }
            targetUnselected.add(validPack);
        }
    }

    public PackGroup validatePacks(List<Pack> unselected, List<Pack> selected) {
        ObjectOpenHashSet seen = new ObjectOpenHashSet();
        ObjectOpenHashSet validPacks = new ObjectOpenHashSet(this.availablePacks.values());
        ObjectArrayList validSelected = new ObjectArrayList(selected.size());
        ObjectArrayList validUnselected = new ObjectArrayList(unselected.size());
        this.addValidPacks(selected, (Set<Pack>)seen, (ObjectOpenHashSet<Pack>)validPacks, (List<Pack>)validSelected);
        this.addValidPacks(unselected, (Set<Pack>)seen, (ObjectOpenHashSet<Pack>)validPacks, (List<Pack>)validUnselected, (List<Pack>)validSelected);
        for (Pack validPack : validPacks) {
            if (!seen.add(validPack)) continue;
            this.options.validate(validPack);
            if (this.options.isRequired(validPack)) {
                this.options.getPosition(validPack).insert((List)validSelected, (Object)validPack, this.options::getSelectionConfig, true);
                continue;
            }
            validUnselected.add(validPack);
        }
        return PackGroup.of((List<Pack>)validSelected, (List<Pack>)validUnselected);
    }

    public List<Pack> validateAndOrderNestedPacks(FolderPack folderPack, List<Pack> orderedPacks) {
        List<Pack> orderedValidPacks = this.folderPacks.get(folderPack.getId());
        ObjectOpenHashSet validPacks = new ObjectOpenHashSet(orderedValidPacks);
        ObjectOpenHashSet seen = new ObjectOpenHashSet();
        ObjectArrayList finalOrderedPacks = new ObjectArrayList();
        this.addValidPacks(orderedPacks, (Set<Pack>)seen, (ObjectOpenHashSet<Pack>)validPacks, (List<Pack>)finalOrderedPacks);
        for (Pack validPack : orderedValidPacks) {
            if (!seen.add(validPack)) continue;
            finalOrderedPacks.add(validPack);
        }
        this.folderPacks.put(folderPack.getId(), (List<Pack>)finalOrderedPacks);
        return finalOrderedPacks;
    }

    public List<Pack> validateAndOrderNestedPackIds(FolderPack folderPack, List<String> orderedPacks) {
        return this.validateAndOrderNestedPacks(folderPack, this.getPacksById(orderedPacks, (Collection<Pack>)this.folderPacks.get(folderPack.getId())));
    }

    public List<Pack> getPacksById(Collection<String> packIds, Map<String, Pack> source) {
        return CollectionsUtil.lookup(packIds, source);
    }

    public List<Pack> getPacksById(Collection<String> packIds, Collection<Pack> source) {
        return CollectionsUtil.lookup(packIds, (Map)CollectionsUtil.toMap(source, Pack::getId));
    }

    public List<Pack> getPacksById(Collection<String> packIds) {
        return this.getPacksById(packIds, this.availablePacks);
    }

    public List<Pack> getPacksByFlattenedIds(Collection<String> packIds) {
        List folderPacks = (List)CollectionsUtil.filter(this.availablePacks.values(), FolderPack.class::isInstance, ObjectArrayList::new);
        List available = CollectionsUtil.addAll((Collection[])new Collection[]{folderPacks, this.repository.getAvailablePacks()});
        return this.groupByFolders(this.getPacksById(packIds, available));
    }

    private void populateAvailablePacks(Collection<Pack> packs) {
        for (Pack pack : packs) {
            FilePack filePack = (FilePack)pack;
            if (filePack.packed_packs$nestedPack()) {
                Path folderPath = Objects.requireNonNull(filePack.packed_packs$getPath()).getParent();
                String folderName = PackUtil.generatePackName(folderPath);
                String folderId = PackUtil.generatePackId(folderName);
                if (!this.availablePacks.containsKey(folderId)) {
                    FolderPack folderPack = new FolderPack(folderId, folderName, this.folderPacks::get, folderPath);
                    this.folderConfigs.put(folderId, folderPack.loadConfig());
                    this.availablePacks.put(folderId, folderPack);
                }
                this.folderPacks.computeIfAbsent(folderId, id -> new ObjectArrayList()).add(pack);
                continue;
            }
            this.availablePacks.put(pack.getId(), pack);
        }
    }

    private void regenerateAvailablePacks() {
        this.selectedPacksCache.clear();
        this.availablePacks.clear();
        this.folderPacks.clear();
        this.folderConfigs.clear();
        this.selectedPacksCache.addAll(this.repository.getSelectedIds());
        this.populateAvailablePacks(this.getSelectedPacks());
        this.populateAvailablePacks(this.getUnselectedPacks());
    }

    public void refresh() {
        this.refreshModel();
        this.model.findNewPacks();
        this.regenerateAvailablePacks();
    }

    public void selectPacks(List<Pack> selected) {
        boolean hasHighContrast = false;
        ObjectArrayList packIds = new ObjectArrayList();
        for (Pack pack : PackUtil.flattenPacks(selected).reversed()) {
            String packId = pack.getId();
            packIds.add(packId);
            if (hasHighContrast || !packId.equals("high_contrast")) continue;
            hasHighContrast = true;
        }
        this.repository.setSelected((Collection)ImmutableList.copyOf((Collection)packIds));
        OptionInstance highContrastOption = Minecraft.getInstance().options.highContrast();
        if ((Boolean)highContrastOption.get() != hasHighContrast) {
            highContrastOption.set((Object)hasHighContrast);
        }
        this.refreshModel();
        this.selectedPacksCache.clear();
        this.selectedPacksCache.addAll(this.repository.getSelectedIds());
    }

    public List<Pack> groupByFolders(List<Pack> flatPacks) {
        if (this.folderPacks.isEmpty()) {
            return flatPacks;
        }
        Object2ObjectOpenHashMap packToFolder = new Object2ObjectOpenHashMap();
        for (Map.Entry<String, List<Pack>> entry : this.folderPacks.entrySet()) {
            for (Pack pack : entry.getValue()) {
                packToFolder.put(pack.getId(), entry.getKey());
            }
        }
        ObjectOpenHashSet seenFolders = new ObjectOpenHashSet();
        ObjectArrayList grouped = new ObjectArrayList(flatPacks.size());
        for (Pack pack : flatPacks) {
            String folderId = (String)packToFolder.get(pack.getId());
            if (folderId != null) {
                if (!seenFolders.add(folderId)) continue;
                grouped.add(this.availablePacks.get(folderId));
                continue;
            }
            grouped.add(pack);
        }
        return grouped;
    }

    public void openDir() {
        Util.getPlatform().openPath(this.packDir);
    }

    public boolean isEnabled(Pack pack) {
        if (pack instanceof FolderPack) {
            FolderPack folderPack = (FolderPack)pack;
            for (Pack nestedPack : this.folderPacks.get(folderPack.getId())) {
                if (!this.selectedPacksCache.contains(nestedPack.getId())) continue;
                return true;
            }
            return false;
        }
        return this.selectedPacksCache.contains(pack.getId());
    }

    public Path getBaseDir() {
        return this.packDir;
    }

    public List<Path> getAdditionalDirs() {
        Path normalizedBaseDir = this.getBaseDir().toAbsolutePath().normalize();
        return ((PackRepositoryAccessor)this.repository).packed_packs$getSources().stream().filter(FolderRepositorySourceAccessor.class::isInstance).map(source -> ((FolderRepositorySourceAccessor)source).packed_packs$getFolder().toAbsolutePath().normalize()).filter(path -> !path.equals(normalizedBaseDir)).distinct().toList();
    }

    @Nullable
    public Folder getFolderConfig(@Nullable FolderPack folderPack) {
        if (folderPack == null) {
            return null;
        }
        CompletableFuture<Folder> future = this.folderConfigs.get(folderPack.getId());
        return future != null ? future.join() : null;
    }

    public List<Pack> getNestedPacks(FolderPack folderPack) {
        Folder config = this.getFolderConfig(folderPack);
        if (config == null) {
            return Collections.emptyList();
        }
        return this.validateAndOrderNestedPackIds(folderPack, config.getPackIds());
    }
}

