/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;

public class InputUtil {
    public static final String DEV_MODE_SHORTCUT = "CTRL + SHIFT + I";
    public static final long DOUBLE_CLICK_THRESHOLD_MS = 250L;
    public static final int MOUSE_BUTTON_BACK = 3;
    public static final int MOUSE_BUTTON_FORWARD = 4;

    private InputUtil() {
    }

    public static boolean isLeftClick(MouseButtonEvent mouseEvent) {
        return mouseEvent.button() == 0;
    }

    public static boolean isRightClick(MouseButtonEvent mouseEvent) {
        return mouseEvent.button() == 1;
    }

    public static boolean isClickBack(MouseButtonEvent mouseEvent) {
        return mouseEvent.button() == 3;
    }

    public static boolean isClickForward(MouseButtonEvent mouseEvent) {
        return mouseEvent.button() == 4;
    }

    public static boolean isUndo(KeyEvent keyEvent) {
        return keyEvent.key() == 90 && keyEvent.hasControlDown() && keyEvent.modifiers() == 2;
    }

    public static boolean isRedo(KeyEvent keyEvent) {
        if (keyEvent.key() == 90) {
            return keyEvent.hasControlDown() && keyEvent.hasShiftDown() && keyEvent.modifiers() == 3;
        }
        if (keyEvent.key() == 89) {
            return keyEvent.hasControlDown() && keyEvent.modifiers() == 2;
        }
        return false;
    }

    public static boolean isTransfer(KeyEvent keyEvent) {
        return InputUtil.noModifiers(keyEvent.modifiers()) && (keyEvent.key() == 32 || keyEvent.key() == 257);
    }

    public static boolean isMoveDown(KeyEvent keyEvent) {
        return keyEvent.key() == 264 && InputUtil.moveModifiers(keyEvent.modifiers());
    }

    public static boolean isMoveUp(KeyEvent keyEvent) {
        return keyEvent.key() == 265 && InputUtil.moveModifiers(keyEvent.modifiers());
    }

    public static boolean isExpandFolder(KeyEvent keyEvent) {
        return InputUtil.noModifiers(keyEvent.modifiers()) && keyEvent.key() == 257;
    }

    public static boolean isDelete(KeyEvent keyEvent) {
        return InputUtil.noModifiers(keyEvent.modifiers()) && keyEvent.key() == 261;
    }

    public static boolean isRename(KeyEvent keyEvent) {
        return InputUtil.noModifiers(keyEvent.modifiers()) && keyEvent.key() == 291 || keyEvent.modifiers() == 2 && keyEvent.key() == 82;
    }

    public static boolean isRefresh(KeyEvent keyEvent) {
        return InputUtil.noModifiers(keyEvent.modifiers()) && keyEvent.key() == 294;
    }

    public static boolean isOpenFile(KeyEvent keyEvent) {
        return keyEvent.modifiers() == 2 && keyEvent.key() == 257;
    }

    public static boolean isOpenFolder(KeyEvent keyEvent) {
        return keyEvent.modifiers() == 5 && keyEvent.key() == 82;
    }

    public static boolean isDeveloperMode(KeyEvent keyEvent) {
        return InputUtil.noModifiers(keyEvent.modifiers()) && keyEvent.key() == 301 || keyEvent.modifiers() == 3 && keyEvent.key() == 73;
    }

    public static boolean isSelectAll(KeyEvent keyEvent) {
        return keyEvent.modifiers() == 2 && keyEvent.key() == 65;
    }

    public static boolean isSwitchDefaultProfile(KeyEvent keyEvent) {
        return InputUtil.noModifiers(keyEvent.modifiers()) && keyEvent.key() == 290;
    }

    public static boolean isOpenProfiles(KeyEvent keyEvent) {
        return keyEvent.modifiers() == 2 && keyEvent.key() == 96;
    }

    public static boolean noModifiers(int modifiers) {
        return modifiers == 0;
    }

    public static boolean moveModifiers(int modifiers) {
        return modifiers == 2 || modifiers == 4;
    }

    public static boolean isRangeModifierActive() {
        return Minecraft.getInstance().hasShiftDown();
    }

    public static boolean isSelectModifierActive() {
        return Minecraft.getInstance().hasControlDown();
    }
}

