package io.github.fishstiz.packed_packs.compat.api;

import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuItemBuilder;
import io.github.fishstiz.fidgetz.gui.layouts.FlexLayout;
import io.github.fishstiz.packed_packs.gui.components.pack.PackList;
import io.github.fishstiz.packed_packs.gui.screens.PackedPacksScreen;
import net.minecraft.client.gui.screens.packs.PackSelectionScreen;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.PackType;
import org.jspecify.annotations.Nullable;

import java.nio.file.Path;

/**
 * Register entrypoint under the {@code packed_packs} key
 */
public interface ModExtension {
    /**
     * The identifier
     */
    Identifier id();

    /**
     * @return A {@link Identifier} that this extension should load after.
     */
    default @Nullable Identifier[] loadAfter() {
        return null;
    }

    /**
     * Invoked when building the header layout for the PackedPacksScreen.
     *
     * @param type     Resource or data packs.
     * @param header   The header to add widgets to.
     * @param screen   The current {@link PackedPacksScreen}.
     * @param original The original vanilla {@link PackSelectionScreen}.
     */
    default void onCreateHeader(PackType type, FlexLayout header, PackedPacksScreen screen, PackSelectionScreen original) {
    }

    /**
     * Invoked when creating a pack entry.
     *
     * @param type  Resource or data packs.
     * @param entry The entry to modify or add widgets to.
     */
    default void onCreateEntry(PackType type, PackList.Entry entry) {
    }

    /**
     * Invoked when creating the context menu for preferences.
     *
     * @param builder The context menu item builder to add items to.
     */
    default void onCreatePreferencesMenu(PackType type, ContextMenuItemBuilder builder) {
    }

    /**
     * @param type Resource or datapacks.
     * @return {@code true} if a commit should occur when closing the screen.
     */
    default boolean forceCommitOnClose(PackType type) {
        return false;
    }

    /**
     * @param type Resource or datapacks.
     * @param path The changed file path.
     * @return {@code true} to ignore this change.
     */
    default boolean shouldIgnoreChange(PackType type, Path path) {
        return false;
    }
}
