package io.github.fishstiz.packed_packs.util;

import static net.minecraft.class_3675.*;
import static net.minecraft.class_437.method_25441;
import static net.minecraft.class_437.method_25442;

public class InputUtil {
    public static final String DEV_MODE_SHORTCUT = "CTRL + SHIFT + I";
    public static final long DOUBLE_CLICK_THRESHOLD_MS = 250;
    public static final int MOUSE_BUTTON_BACK = 3;
    public static final int MOUSE_BUTTON_FORWARD = 4;
    public static final int MOD_SHIFT = 1;
    public static final int MOD_ALT = 4;

    private InputUtil() {
    }

    public static boolean isLeftClick(int button) {
        return button == field_32000;
    }

    public static boolean isRightClick(int button) {
        return button == field_32002;
    }

    public static boolean isClickBack(int button) {
        return button == MOUSE_BUTTON_BACK;
    }

    public static boolean isClickForward(int button) {
        return button == MOUSE_BUTTON_FORWARD;
    }

    public static boolean isUndo(int keyCode, int modifiers) {
        return keyCode == field_31915 && method_25441() && modifiers == field_32003;
    }

    public static boolean isRedo(int keyCode, int modifiers) {
        if (keyCode == field_31915) {
            return method_25441() && method_25442() && modifiers == field_32003 + MOD_SHIFT;
        } else if (keyCode == field_31914) {
            return method_25441() && modifiers == field_32003;
        }

        return false;
    }

    public static boolean isTransfer(int keyCode, int modifiers) {
        return noModifiers(modifiers) && (keyCode == field_31947 || keyCode == field_31957);
    }

    public static boolean isMoveDown(int keyCode, int modifiers) {
        return keyCode == field_31982 && moveModifiers(modifiers);
    }

    public static boolean isMoveUp(int keyCode, int modifiers) {
        return keyCode == field_31932 && moveModifiers(modifiers);
    }

    public static boolean isExpandFolder(int keyCode, int modifiers) {
        return noModifiers(modifiers) && keyCode == field_31957;
    }

    public static boolean isDelete(int keyCode, int modifiers) {
        return noModifiers(modifiers) && keyCode == field_31987;
    }

    public static boolean isRename(int keyCode, int modifiers) {
        return (noModifiers(modifiers) && keyCode == field_31917) || (modifiers == field_32003 && keyCode == field_31907);
    }

    public static boolean isRefresh(int keyCode, int modifiers) {
        return noModifiers(modifiers) && keyCode == field_31920;
    }

    public static boolean isOpenFile(int keyCode, int modifiers) {
        return modifiers == field_32003 && keyCode == field_31957;
    }

    public static boolean isOpenFolder(int keyCode, int modifiers) {
        return modifiers == MOD_ALT + MOD_SHIFT && keyCode == field_31907;
    }

    public static boolean isDeveloperMode(int keyCode, int modifiers) {
        return  noModifiers(modifiers) && keyCode == field_31927 ||
                modifiers == field_32003 + MOD_SHIFT && keyCode == field_32023;
    }

    public static boolean isSelectAll(int keyCode, int modifiers) {
        return modifiers == field_32003 && keyCode == field_32015;
    }

    public static boolean isSwitchDefaultProfile(int keyCode, int modifiers) {
        return noModifiers(modifiers) && keyCode == field_31916;
    }

    public static boolean isOpenProfiles(int keyCode, int modifiers) {
        return modifiers == field_32003 && keyCode == field_31938;
    }

    public static boolean noModifiers(int modifiers) {
        return modifiers == 0;
    }

    public static boolean moveModifiers(int modifiers) {
        return modifiers == field_32003 || modifiers == MOD_ALT;
    }

    public static boolean isRangeModifierActive() {
        return method_25442();
    }

    public static boolean isSelectModifierActive() {
        return method_25441();
    }
}
