/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.fidgetz.gui.components;

import io.github.fishstiz.fidgetz.gui.components.ContainerEventHandlerPatch;
import io.github.fishstiz.fidgetz.gui.components.ToggleableDialog;
import io.github.fishstiz.fidgetz.util.GuiUtil;
import io.github.fishstiz.fidgetz.util.lang.CollectionsUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_364;

public interface ToggleableDialogContainer
extends ContainerEventHandlerPatch {
    public List<ToggleableDialog<?>> getDialogs();

    default public List<ToggleableDialog<?>> getOpenDialogs() {
        return (List)CollectionsUtil.filter(this.getDialogs(), ToggleableDialog::isOpen, ObjectArrayList::new);
    }

    default public boolean isChildCovered(class_364 child) {
        boolean isDialogChild = false;
        boolean isEnclosed = false;
        for (ToggleableDialog<?> dialog : this.getOpenDialogsFromTop()) {
            if (dialog != child && (dialog.isCaptureClick() || dialog.isCaptureFocus()) && !GuiUtil.isDescendant(dialog, child)) {
                return true;
            }
            if (!isEnclosed && GuiUtil.isDescendant(dialog, child)) {
                isDialogChild = true;
                break;
            }
            if (isEnclosed || dialog == child || !dialog.encloses(child)) continue;
            isEnclosed = true;
        }
        return !isDialogChild && isEnclosed;
    }

    private List<ToggleableDialog<?>> getOpenDialogsFromTop() {
        List<ToggleableDialog<?>> dialogs = this.getOpenDialogs();
        dialogs.sort(Comparator.comparing(ToggleableDialog::getZ).reversed());
        return dialogs;
    }
}

