package io.github.fishstiz.fidgetz.gui.components;

import io.github.fishstiz.fidgetz.gui.Metadata;
import io.github.fishstiz.fidgetz.gui.WidgetBuilder;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.ButtonSprites;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.fidgetz.util.GuiUtil;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_7919;

public class FidgetzButton<E> extends class_4185 implements Metadata<E> {
    private final List<Runnable> listeners = new ArrayList<>();
    private final ButtonSprites sprites;
    private final Integer focusedBorder;
    private final boolean spriteOnly;
    private E metadata;

    protected FidgetzButton(Builder<E, ?> builder) {
        super(builder.x, builder.y, builder.width, builder.height, builder.message, builder.onPress, field_40754);

        this.metadata = builder.metadata;
        this.sprites = builder.sprites;
        this.spriteOnly = builder.spriteOnly;
        this.focusedBorder = builder.focusedBorder;

        if (builder.tooltip != null) {
            this.method_47400(builder.tooltip);
        }
    }

    @Override
    public void method_25306() {
        super.method_25306();

        for (var listener : this.listeners) {
            listener.run();
        }
    }

    public void addListener(Runnable listener) {
        this.listeners.add(listener);
    }

    @Override
    public E getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(E metadata) {
        this.metadata = metadata;
    }

    protected boolean hasSprite() {
        return this.sprites != null;
    }

    protected void renderSprite(class_332 guiGraphics, int x, int y, int width, int height, float partialTick) {
        this.sprites.get(this.field_22763).renderClamped(guiGraphics, x, y, width, height, partialTick);
    }

    protected void renderBorder(class_332 guiGraphics, int x, int y, int width, int height, float partialTick) {
        guiGraphics.method_49601(x, y, width, height, this.focusedBorder);
    }

    @Override
    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.field_22762 = this.containsPoint(mouseX, mouseY);

        if (!this.spriteOnly) {
            super.method_48579(guiGraphics, mouseX, mouseY, partialTick);
        }

        if (this.hasSprite()) {
            int spriteWidth = this.method_25368();
            int spriteHeight = this.method_25364();
            int spriteX = this.method_46426() + (this.method_25368() - spriteWidth) / 2;
            int spriteY = this.method_46427() + (this.method_25364() - spriteHeight) / 2;

            this.renderSprite(guiGraphics, spriteX, spriteY, spriteWidth, spriteHeight, partialTick);
        }

        if (this.method_25367() && this.focusedBorder != null) {
            this.renderBorder(guiGraphics, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), partialTick);
        }
    }

    @Override
    public void method_48589(class_332 guiGraphics, class_327 font, int color) {
        if (!this.hasSprite()) {
            super.method_48589(guiGraphics, font, color);
        }
    }

    private boolean isUncovered(double mouseX, double mouseY) {
        if (class_310.method_1551().field_1755 instanceof ToggleableDialogContainer dialogContainer) {
            return !dialogContainer.isChildCoveredAtPoint(this, mouseX, mouseY);
        }
        return true;
    }

    public boolean containsPoint(double mouseX, double mouseY) {
        return GuiUtil.containsPoint(this, mouseX, mouseY) && this.isUncovered(mouseX, mouseY);
    }

    @Override
    public boolean method_25405(double mouseX, double mouseY) {
        return super.method_25405(mouseX, mouseY) && this.isUncovered(mouseX, mouseY);
    }

    public static <E> Builder<E, ?> builder() {
        return new Builder<>();
    }

    public static class Builder<E, B extends Builder<E, B>> implements WidgetBuilder<Builder<E, B>> {
        private int x = 0;
        private int y = 0;
        private int width = DEFAULT_WIDTH;
        private int height = DEFAULT_HEIGHT;
        private class_2561 message = class_2561.method_43473();
        private class_7919 tooltip;
        private ButtonSprites sprites;
        private boolean spriteOnly = false;
        private Integer focusedBorder;
        private class_4241 onPress = btn -> {
        };
        private E metadata;

        protected Builder() {
        }

        @SuppressWarnings("unchecked")
        protected B self() {
            return (B) this;
        }

        @Override
        public @NotNull B setX(int x) {
            this.x = x;
            return self();
        }

        @Override
        public @NotNull B setY(int y) {
            this.y = y;
            return self();
        }

        @Override
        public @NotNull B setPosition(int x, int y) {
            this.x = x;
            this.y = y;
            return self();
        }

        @Override
        public @NotNull B setWidth(int width) {
            this.width = width;
            return self();
        }

        @Override
        public @NotNull B setHeight(int height) {
            this.height = height;
            return self();
        }

        @Override
        public @NotNull B setDimensions(int width, int height) {
            this.width = width;
            this.height = height;
            return self();
        }

        public B makeSquare(int size) {
            this.height = size;
            this.width = size;
            return self();
        }

        public B makeSquare() {
            return makeSquare(this.height);
        }

        public B setMessage(class_2561 message) {
            this.message = message;
            return self();
        }

        public B setMessage(String message) {
            return this.setMessage(class_2561.method_43471(message));
        }

        public B setTooltip(class_7919 tooltip) {
            this.tooltip = tooltip;
            return self();
        }

        public B setSprite(ButtonSprites sprites) {
            this.sprites = sprites;
            return self();
        }

        public B setSprite(Sprite sprite) {
            this.sprites = ButtonSprites.of(sprite);
            return self();
        }

        public B spriteOnly() {
            this.spriteOnly = true;
            return self();
        }

        public B setFocusedBorder(Integer hoverBorder) {
            this.focusedBorder = hoverBorder;
            return self();
        }

        public B setOnPress(class_4241 onPress) {
            this.onPress = onPress;
            return self();
        }

        public B setOnPress(Runnable onPress) {
            this.onPress = btn -> onPress.run();
            return self();
        }

        public B setMetadata(E metadata) {
            this.metadata = metadata;
            return self();
        }

        public FidgetzButton<E> build() {
            return new FidgetzButton<>(this);
        }
    }
}
