package io.github.fishstiz.fidgetz.gui.components;

import io.github.fishstiz.fidgetz.gui.renderables.ColoredRect;
import io.github.fishstiz.fidgetz.gui.renderables.RenderableRect;
import io.github.fishstiz.fidgetz.gui.shapes.GuiRectangle;
import io.github.fishstiz.fidgetz.util.GuiUtil;
import io.github.fishstiz.fidgetz.util.debounce.PollingDebouncer;
import io.github.fishstiz.fidgetz.util.debounce.SimplePollingDebouncer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8016;
import net.minecraft.class_8021;
import net.minecraft.class_8023;
import net.minecraft.class_8030;
import net.minecraft.class_8083;

import static net.minecraft.class_437.method_37061;

public class ToggleableDialog<T extends class_8021> extends class_362 implements class_4068, class_6379 {
    protected final class_437 screen;
    private final PollingDebouncer<Void> focusOnOpenTask = new SimplePollingDebouncer<>(this::focus, 0);
    private final List<class_364> children = new ArrayList<>();
    private final List<class_4068> renderables = new ArrayList<>();
    private final List<class_6379> narratables = new ArrayList<>();
    private final List<Consumer<Boolean>> listeners = new ArrayList<>();
    private final T root;
    private final RenderableRect backdrop;
    private final RenderableRect background;
    private final boolean autoClose;
    private final GuiRectangle ignoreAutoCloseArea;
    private final boolean autoLoseFocus;
    private final boolean closeOnEscape;
    private final boolean captureClick;
    private final boolean captureFocus;
    private final boolean focusOnOpen;
    private @Nullable class_6379 lastNarratable;
    private GuiRectangle boundingBox;
    private boolean open = false;
    private boolean hovered;
    private float z;

    protected ToggleableDialog(Builder<T, ?> builder) {
        this.screen = builder.screen;
        this.root = builder.root;
        this.z = builder.z;
        this.boundingBox = builder.boundingBox;
        this.backdrop = builder.backdrop;
        this.background = builder.background;
        this.autoClose = builder.autoClose;
        this.ignoreAutoCloseArea = builder.ignoreAutoCloseArea;
        this.focusOnOpen = builder.focusOnOpen;
        this.autoLoseFocus = builder.autoLoseFocus;
        this.closeOnEscape = builder.closeOnEscape;
        this.captureClick = builder.captureClick;
        this.captureFocus = builder.captureFocus;

        this.setOpen(builder.open);
        this.listeners.addAll(builder.listeners);
    }

    public T root() {
        return this.root;
    }

    @Deprecated(since = "mc1.21.6")
    public void setZ(float z) {
        this.z = z;
    }

    @Deprecated(since = "mc1.21.6")
    public float getZ() {
        return this.z;
    }

    public void toggle() {
        this.setOpen(!this.isOpen());
    }

    public void setOpen(boolean open) {
        boolean previous = this.open;
        this.open = open;

        if (previous != this.open) {
            for (var listener : this.listeners) {
                listener.accept(open);
            }
            if (this.focusOnOpen || this.captureFocus) {
                if (open) {
                    this.focusOnOpenTask.run();
                } else {
                    this.focusOnOpenTask.abort();
                }
            }
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    public <U extends class_364> U prependWidget(U widget) {
        this.children.addFirst(Objects.requireNonNull(widget));
        if (widget instanceof class_6379 narratable) this.narratables.addFirst(narratable);
        return widget;
    }

    public <U extends class_364> U addWidget(U widget) {
        this.children.add(Objects.requireNonNull(widget));
        if (widget instanceof class_6379 narratable) this.narratables.add(narratable);
        return widget;
    }

    public <U extends class_4068> U addRenderableOnly(U renderable) {
        this.renderables.add(Objects.requireNonNull(renderable));
        return renderable;
    }

    public <U extends class_364 & class_4068> U addRenderableWidget(U child) {
        this.children.add(Objects.requireNonNull(child));
        this.renderables.add(child);
        if (child instanceof class_6379 narratable) this.narratables.add(narratable);
        return child;
    }

    protected void clearWidgets() {
        this.children.clear();
        this.renderables.clear();
        this.narratables.clear();
    }

    @Override
    public @NotNull List<? extends class_364> method_25396() {
        return this.isOpen() ? List.copyOf(this.children) : GuiUtil.EMPTY_CHILDREN;
    }

    @Override
    public @NotNull Optional<class_364> method_19355(double mouseX, double mouseY) {
        for (var child : this.children) {
            if (child.method_25405(mouseX, mouseY)) {
                return Optional.of(child);
            }
        }
        return Optional.empty();
    }

    public Consumer<Boolean> addListener(Consumer<Boolean> listener) {
        this.listeners.add(listener);
        return listener;
    }

    public void setBoundingBox(GuiRectangle boundingBox) {
        this.boundingBox = Objects.requireNonNull(boundingBox);
    }

    public void setBoundingBox(class_8021 boundingBox) {
        this.setBoundingBox(GuiRectangle.viewOf(boundingBox));
    }

    public GuiRectangle getBoundingBox() {
        return this.boundingBox;
    }

    public boolean shouldCloseOnEscape() {
        return this.closeOnEscape;
    }

    protected void renderBackdrop(class_332 guiGraphics, int x, int y, int width, int height, int mouseX, int mouseY, float partialTick) {
        if (this.backdrop != null) {
            this.backdrop.render(guiGraphics, x, y, width, height, partialTick);
        }
    }

    protected void renderBackground(class_332 guiGraphics, int x, int y, int width, int height, int mouseX, int mouseY, float partialTick) {
        if (this.background != null) {
            this.background.render(guiGraphics, x, y, width, height, partialTick);
        }
    }

    protected void renderForeground(class_332 guiGraphics, int x, int y, int width, int height, int mouseX, int mouseY, float partialTick) {
    }

    @Override
    public final void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.hovered = this.isMouseOverBounds(mouseX, mouseY);

        this.focusOnOpenTask.poll();

        if (this.isOpen()) {
            int x = this.boundingBox.getX();
            int y = this.boundingBox.getY();
            int width = this.boundingBox.getWidth();
            int height = this.boundingBox.getHeight();

            class_4587 poseStack = guiGraphics.method_51448();
            poseStack.method_22903();
            poseStack.method_46416(0, 0, this.z);

            this.renderBackdrop(guiGraphics, 0, 0, this.screen.field_22789, this.screen.field_22790, mouseX, mouseY, partialTick);
            this.renderBackground(guiGraphics, x, y, width, height, mouseX, mouseY, partialTick);
            for (class_4068 renderable : this.renderables) {
                renderable.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            }
            this.renderForeground(guiGraphics, x, y, width, height, mouseX, mouseY, partialTick);

            poseStack.method_22909();
        }
    }

    private boolean isValidClickButton(int button) {
        return button == class_3675.field_32000;
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.isOpen()) {
            return false;
        }
        if (this.shouldCloseOnEscape() && keyCode == class_3675.field_31958) {
            this.setOpen(false);
            return true;
        }
        class_364 focused = this.method_25399();
        if (focused != null) {
            return focused.method_25404(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean isMouseOverBounds(double mouseX, double mouseY) {
        if (!this.isOpen()) {
            return false;
        }
        if (this.boundingBox.containsPoint(mouseX, mouseY)) {
            return true;
        }
        return GuiUtil.deepChildHovered(this, mouseX, mouseY);
    }

    @Override
    public boolean method_25405(double mouseX, double mouseY) {
        if (!this.isOpen()) {
            return false;
        }
        if (this.isCaptureClick() || this.isCaptureFocus()) {
            return true;
        }
        return this.isMouseOverBounds(mouseX, mouseY);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.isOpen()) {
            return false;
        }
        Optional<class_364> hoveredChild = this.method_19355(mouseX, mouseY);
        if (hoveredChild.isPresent() && hoveredChild.get().method_25402(mouseX, mouseY, button)) {
            this.method_25395(hoveredChild.get());
            if (this.isValidClickButton(button)) {
                this.method_25398(true);
            }
            return true;
        }
        if (this.autoLoseFocus && hoveredChild.isEmpty() && !this.children.isEmpty()) {
            this.method_25395(this.children.getFirst());
            for (var child : this.children) {
                child.method_25365(false);
            }
        }
        if (hoveredChild.isPresent() || this.isMouseOverBounds(mouseX, mouseY)) {
            return true;
        }
        if (this.autoClose && this.isValidClickButton(button) &&
            (this.ignoreAutoCloseArea == null || !this.ignoreAutoCloseArea.containsPoint(mouseX, mouseY))) {
            this.setOpen(false);
        }
        return this.captureClick || this.captureFocus;
    }

    public boolean encloses(class_8030 rectangle) {
        return rectangle != null && (this.boundingBox.contains(rectangle) || this.childEncloses(rectangle));
    }

    public boolean encloses(class_8021 element) {
        return element != null && (this.boundingBox.contains(element) || this.childEncloses(element.method_48202()));
    }

    public boolean encloses(class_364 guiEventListener) {
        if (guiEventListener == null) return false;

        if (guiEventListener instanceof class_8021 element) {
            return this.encloses(element);
        }

        class_8030 rectangle = guiEventListener.method_48202();
        return this.boundingBox.contains(rectangle) || this.childEncloses(rectangle);
    }

    private boolean childEncloses(class_8030 rectangle) {
        for (GuiEventListener child : this.children) {
            switch (child) {
                case ToggleableDialog<?> dialog when dialog.encloses(rectangle) -> {
                    return true;
                }
                case LayoutElement childElement when GuiUtil.contains(childElement, rectangle) -> {
                    return true;
                }
                default -> {
                    if (GuiUtil.contains(child.getRectangle(), rectangle)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean intersects(class_8030 rectangle) {
        return rectangle != null && (this.boundingBox.intersects(rectangle) || this.childIntersects(rectangle));
    }

    public boolean intersects(class_8021 element) {
        return element != null && (this.boundingBox.intersects(element) || this.childIntersects(element.method_48202()));
    }

    public boolean intersects(class_364 guiEventListener) {
        if (guiEventListener == null) return false;

        if (guiEventListener instanceof class_8021 element) {
            return this.intersects(element);
        }

        class_8030 rectangle = guiEventListener.method_48202();
        return this.boundingBox.intersects(rectangle) || this.childIntersects(rectangle);
    }

    private boolean childIntersects(class_8030 rectangle) {
        for (GuiEventListener child : this.children) {
            switch (child) {
                case ToggleableDialog<?> dialog when dialog.intersects(rectangle) -> {
                    return true;
                }
                case LayoutElement childElement when GuiUtil.intersects(childElement, rectangle) -> {
                    return true;
                }
                default -> {
                    if (GuiUtil.intersects(child.getRectangle(), rectangle)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public @NotNull class_8030 method_48202() {
        return this.boundingBox.getScreenRectangle();
    }

    public void focus() {
        if (this.isOpen()) {
            this.screen.method_48267();

            class_8016 path;

            if (this.children.isEmpty()) {
                path = class_8016.method_48194(this, this.screen);
            } else {
                class_364 firstFocusable = this.getFirstFocusable();
                path = firstFocusable != null
                        ? class_8016.method_48194(firstFocusable, this, this.screen)
                        : class_8016.method_48194(this, this.screen);
            }

            path.method_48195(true);
        }
    }

    @Override
    public @Nullable class_8016 method_48205(class_8023 event) {
        if (!this.isOpen()) {
            return null;
        }

        class_8016 next = super.method_48205(event);
        if (this.captureFocus && next == null) {
            if (this.children.isEmpty()) {
                return class_8016.method_48194(this);
            }

            class_364 lastFocusable = this.getLastFocusable();
            class_364 activeChild = this.method_25399() == lastFocusable
                    ? this.getFirstFocusable()
                    : lastFocusable;

            return activeChild == null
                    ? class_8016.method_48194(this)
                    : class_8016.method_48194(activeChild, this);
        }
        return next;
    }

    private @Nullable class_364 getLastFocusable() {
        for (int i = this.children.size() - 1; i >= 0; i--) {
            if (!(this.children.get(i) instanceof class_339 widget) || widget.field_22763) {
                return this.children.get(i);
            }
        }
        return null;
    }

    private @Nullable class_364 getFirstFocusable() {
        for (class_364 child : this.children) {
            if (!(child instanceof class_339 widget) || widget.field_22763) {
                return child;
            }
        }
        return null;
    }

    @Override
    public boolean method_25370() {
        return this.isOpen() && super.method_25370();
    }

    public boolean isCaptureClick() {
        return this.captureClick;
    }

    public boolean isCaptureFocus() {
        return this.captureFocus;
    }

    @Override
    public int method_48590() {
        return -1;
    }

    @Override
    public boolean method_37303() {
        return this.isOpen();
    }

    public boolean isHovered() {
        return this.isOpen() && this.hovered;
    }

    @Override
    public @NotNull class_6380 method_37018() {
        return this.isHovered() ? class_6380.field_33785 : class_6380.field_33784;
    }

    protected class_2561 getUsageNarration() {
        return class_2561.method_43471("narration.component_list.usage");
    }

    @Override
    public void method_37020(class_6382 narrationElementOutput) {
        List<class_6379> sortedNarratables = this.narratables
                .stream()
                .filter(class_6379::method_37303)
                .sorted(Comparator.comparingInt(class_8083::method_48590))
                .toList();
        class_437.class_6390 narratableSearchResult = method_37061(sortedNarratables, this.lastNarratable);
        if (narratableSearchResult != null) {
            if (narratableSearchResult.field_33827.method_37028()) {
                this.lastNarratable = narratableSearchResult.field_33825;
            }
            if (sortedNarratables.size() > 1) {
                narrationElementOutput.method_37034(class_6381.field_33789, class_2561.method_43469("narrator.position.screen", narratableSearchResult.field_33826 + 1, sortedNarratables.size()));
                if (narratableSearchResult.field_33827 == class_6380.field_33786) {
                    narrationElementOutput.method_37034(class_6381.field_33791, this.getUsageNarration());
                }
            }
            narratableSearchResult.field_33825.method_37020(narrationElementOutput.method_37031());
        }
    }

    public static <S extends class_437 & ToggleableDialogContainer, T extends class_8021> Builder<T, ?> builder(S screen, T root) {
        return new Builder<>(screen, root);
    }

    public static class Builder<T extends class_8021, B extends Builder<T, B>> {
        protected final List<Consumer<Boolean>> listeners = new ArrayList<>();
        protected final class_437 screen;
        protected final T root;
        protected GuiRectangle boundingBox;
        protected RenderableRect backdrop;
        protected RenderableRect background;
        protected boolean open = false;
        protected boolean autoClose = true;
        protected GuiRectangle ignoreAutoCloseArea;
        protected boolean focusOnOpen = true;
        protected boolean autoLoseFocus = true;
        protected boolean closeOnEscape = true;
        protected boolean captureClick = false;
        protected boolean captureFocus = false;
        protected float z = 1;

        protected <S extends class_437 & ToggleableDialogContainer> Builder(S screen, T root) {
            this.screen = screen;
            this.root = root;
            this.boundingBox = GuiRectangle.viewOf(this.root);
        }

        @SuppressWarnings("unchecked")
        protected B self() {
            return (B) this;
        }

        public B setBoundingBox(GuiRectangle boundingBox) {
            this.boundingBox = boundingBox;
            return self();
        }

        public B setBoundingBox(class_8021 elementView) {
            this.boundingBox = GuiRectangle.viewOf(elementView);
            return self();
        }

        public B setBackdrop(RenderableRect backdrop) {
            this.backdrop = backdrop;
            return self();
        }

        public B setBackdrop(int color) {
            this.backdrop = new ColoredRect(color);
            return self();
        }

        public B setBackground(RenderableRect background) {
            this.background = background;
            return self();
        }

        public B setBackground(int color) {
            this.background = new ColoredRect(color);
            return self();
        }

        public B setOpen(boolean open) {
            this.open = open;
            return self();
        }

        public B addListener(Consumer<Boolean> listener) {
            this.listeners.add(listener);
            return self();
        }

        public B setAutoClose(boolean autoClose) {
            this.autoClose = autoClose;
            return self();
        }

        public B setAutoClose(GuiRectangle ignoredArea) {
            this.ignoreAutoCloseArea = ignoredArea;
            this.autoClose = true;
            return self();
        }

        public B setAutoClose(class_8021 ignoredArea) {
            this.ignoreAutoCloseArea = GuiRectangle.viewOf(ignoredArea);
            this.autoClose = true;
            return self();
        }

        public B setCloseOnEscape(boolean closeOnEscape) {
            this.closeOnEscape = closeOnEscape;
            return self();
        }

        public B setFocusOnOpen(boolean focusOnOpen) {
            this.focusOnOpen = focusOnOpen;
            return self();
        }

        public B setAutoLoseFocus(boolean autoLoseFocus) {
            this.autoLoseFocus = autoLoseFocus;
            return self();
        }

        public B setCaptureClick(boolean captureClick) {
            this.captureClick = captureClick;
            return self();
        }

        public B setCaptureFocus(boolean captureFocus) {
            this.captureFocus = captureFocus;
            return self();
        }

        public B setZ(float z) {
            this.z = z;
            return self();
        }

        public ToggleableDialog<T> build() {
            return new ToggleableDialog<>(this);
        }
    }
}
