package io.github.fishstiz.fidgetz.util;

import java.util.List;
import net.minecraft.class_1109;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_437;
import net.minecraft.class_8021;
import net.minecraft.class_8030;

public class GuiUtil {
    public static final List<class_364> EMPTY_CHILDREN = List.of();

    private GuiUtil() {
    }

    public static boolean isDescendant(class_4069 container, class_364 listener) {
        for (class_364 child : container.method_25396()) {
            if (child == listener) {
                return true;
            }
            if (child instanceof class_4069 parent && isDescendant(parent, listener)) {
                return true;
            }
        }
        return false;
    }

    public static boolean deepChildHovered(class_4069 container, double mouseX, double mouseY) {
        for (class_364 child : container.method_25396()) {
            if (child instanceof class_4069 nestedContainer) {
                return deepChildHovered(nestedContainer, mouseX, mouseY);
            }
            if (child.method_25405(mouseX, mouseY)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isHovered(class_4069 container, class_364 listener, double mouseX, double mouseY) {
        for (class_364 child : container.method_25396()) {
            if (child instanceof class_4069 nestedContainer && isHovered(nestedContainer, listener, mouseX, mouseY)) {
                return true;
            }
            if (child.method_25405(mouseX, mouseY)) {
                return child == listener;
            }
        }
        return false;
    }

    public static boolean isHovered(class_364 listener, double mouseX, double mouseY) {
        class_437 screen = class_310.method_1551().field_1755;
        return screen != null && isHovered(screen, listener, mouseX, mouseY);
    }

    public static void playClickSound() {
        class_310.method_1551().method_1483().method_4873(class_1109.method_47978(class_3417.field_15015, 1.0F));
    }

    public static boolean containsPoint(int x, int y, int width, int height, double px, double py) {
        return px >= x && px < (x + width) && py >= y && py < (y + height);
    }

    public static boolean containsPoint(int x, int y, int width, int height, int px, int py) {
        return containsPoint(x, y, width, height, (double) px, py);
    }

    public static boolean containsPoint(class_8021 element, int px, int py) {
        return containsPoint(element.method_46426(), element.method_46427(), element.method_25368(), element.method_25364(), px, py);
    }

    public static boolean containsPoint(class_8021 element, double px, double py) {
        return containsPoint(element, (int) px, (int) py);
    }

    public static boolean contains(class_8030 container, class_8030 rectangle) {
        return rectangle.method_49620() >= container.method_49620() &&
               rectangle.method_49618() >= container.method_49618() &&
               rectangle.method_49621() <= container.method_49621() &&
               rectangle.method_49619() <= container.method_49619();
    }

    public static boolean contains(class_8021 container, class_8030 rectangle) {
        return rectangle.method_49620() >= container.method_46426() &&
               rectangle.method_49618() >= container.method_46427() &&
               rectangle.method_49621() <= getRight(container) &&
               rectangle.method_49619() <= getBottom(container);
    }

    public static boolean contains(class_8030 container, class_8021 element) {
        return element.method_46426() >= container.method_49620() &&
               element.method_46427() >= container.method_49618() &&
               getRight(element) <= container.method_49621() &&
               getBottom(element) <= container.method_49619();
    }

    public static boolean contains(class_8021 container, class_8021 element) {
        return element.method_46426() >= container.method_46426() &&
               element.method_46427() >= container.method_46427() &&
               getRight(element) <= getRight(container) &&
               getBottom(element) <= getBottom(container);
    }

    public static boolean intersects(class_8030 first, class_8030 second) {
        return first.method_49620() < second.method_49621() &&
               first.method_49621() > second.method_49620() &&
               first.method_49618() < second.method_49619() &&
               first.method_49619() > second.method_49618();
    }

    public static boolean intersects(class_8021 first, class_8030 second) {
        return first.method_46426() < second.method_49621() &&
               getRight(first) > second.method_49620() &&
               first.method_46427() < second.method_49619() &&
               getBottom(first) > second.method_49618();
    }

    public static boolean intersects(class_8030 first, class_8021 second) {
        return first.method_49620() < getRight(second) &&
               first.method_49621() > second.method_46426() &&
               first.method_49618() < getBottom(second) &&
               first.method_49619() > second.method_46427();
    }

    public static boolean intersects(class_8021 first, class_8021 second) {
        return first.method_46426() < getRight(second) &&
               getRight(first) > second.method_46426() &&
               first.method_46427() < getBottom(second) &&
               getBottom(first) > second.method_46427();
    }

    public static int getRight(class_8021 element) {
        return element.method_46426() + element.method_25368();
    }

    public static int getBottom(class_8021 element) {
        return element.method_46427() + element.method_25364();
    }
}
