package io.github.fishstiz.packed_packs.gui.components.contextmenu;

import com.google.common.util.concurrent.Runnables;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.MenuItemRenderer;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.RenderableMenuItem;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.fidgetz.util.DrawUtil;
import io.github.fishstiz.packed_packs.util.constants.Theme;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3288;
import net.minecraft.class_332;

public record PackMenuHeader(class_3288 pack, class_327 font, Sprite sprite) implements MenuItemRenderer {
    public PackMenuHeader(class_3288 pack, Sprite sprite) {
        this(pack, class_310.method_1551().field_1772, sprite);
    }

    public static RenderableMenuItem withItem(class_3288 pack, Sprite sprite) {
        return new RenderableMenuItem(new PackMenuHeader(pack, sprite), false, false, Runnables.doNothing());
    }

    @Override
    public void render(class_332 guiGraphics, int x, int y, int width, int height, int spacing, boolean hovered, double mouseX, double mouseY, float partialTick) {
        guiGraphics.method_25294(x, y, x + width, y + height, Theme.GRAY_500.getARGB());

        int size = this.font.field_2000;

        int innerX = x + spacing;
        int innerY = y + spacing;
        int innerWidth = width - 2 * spacing;
        int innerHeight = height - 2 * spacing;

        int iconY = innerY + (innerHeight - size) / 2;
        this.sprite.render(guiGraphics, innerX, iconY, size, size, partialTick);

        int textX = innerX + size + spacing;
        DrawUtil.renderScrollingStringLeftAlign(
                guiGraphics,
                this.font,
                pack.method_14457(),
                textX, y + 1,
                innerX + innerWidth, y + height,
                Theme.WHITE.getARGB()
        );
    }
}
