package io.github.fishstiz.packed_packs.gui.components.events;

import com.google.common.collect.ImmutableList;
import io.github.fishstiz.fidgetz.gui.renderables.ColoredRect;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.packed_packs.gui.components.pack.PackList;
import io.github.fishstiz.packed_packs.util.constants.Theme;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3288;
import net.minecraft.class_332;
import net.minecraft.class_4068;

public final class DragEvent extends PackListEvent implements class_4068 {
    private static final ColoredRect BACKGROUND = new ColoredRect(Theme.GRAY_800.getARGB());
    private static final ColoredRect OVERLAY = new ColoredRect(Theme.BLACK.withAlpha(0.5f));
    private static final ColoredRect NUM_BACKGROUND = new ColoredRect(Theme.BLUE_500.getARGB());
    private static final int OFFSET_Y = 4;
    private static final int ICON_SIZE = 48;
    private static final int NUM_SIZE = 16;
    private static final int ICON_OFFSET_X = ICON_SIZE / 2;
    private static final int ICON_OFFSET_Y = ICON_SIZE - OFFSET_Y;
    private static final int NUM_OFFSET_Y = NUM_SIZE - OFFSET_Y + (ICON_SIZE - NUM_SIZE) / 2;
    private final ImmutableList<class_3288> payload;
    private final class_3288 trigger;
    private final Sprite sprite;

    public DragEvent(PackList target, List<class_3288> selection, class_3288 trigger, Sprite sprite) {
        super(target);

        if (selection.isEmpty()) {
            throw new IllegalStateException("Cannot create drag event with empty selection.");
        }

        this.payload = ImmutableList.copyOf(selection);
        this.trigger = trigger;
        this.sprite = sprite;
    }

    @Override
    public boolean pushToHistory() {
        return false;
    }

    public ImmutableList<class_3288> payload() {
        return this.payload;
    }

    public class_3288 trigger() {
        return this.trigger;
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        String sizeString = String.valueOf(this.payload().size());
        class_327 font = class_310.method_1551().field_1772;
        int sizeStringWidth = font.method_1727(sizeString);
        int iconX = mouseX - ICON_OFFSET_X;
        int iconY = mouseY - ICON_OFFSET_Y;
        int numWidth = NUM_SIZE > sizeStringWidth ? NUM_SIZE : (sizeStringWidth + NUM_SIZE - font.field_2000);
        int numX = mouseX - numWidth / 2;
        int numY = mouseY - NUM_OFFSET_Y;

        BACKGROUND.render(guiGraphics, iconX, iconY, ICON_SIZE, ICON_SIZE);
        this.sprite.render(guiGraphics, iconX, iconY, ICON_SIZE, ICON_SIZE, partialTick);
        OVERLAY.render(guiGraphics, iconX, iconY, ICON_SIZE, ICON_SIZE);
        NUM_BACKGROUND.render(guiGraphics, numX, numY, numWidth, NUM_SIZE);
        guiGraphics.method_25303(font, sizeString, numX + numWidth / 2 - sizeStringWidth / 2, numY + NUM_SIZE / 2 - font.field_2000 / 2, Theme.WHITE.getARGB());
        guiGraphics.method_49601(iconX, iconY, ICON_SIZE, ICON_SIZE, Theme.WHITE.getARGB());
        guiGraphics.method_49601(numX, numY, numWidth, NUM_SIZE, Theme.WHITE.getARGB());
    }
}
