package io.github.fishstiz.packed_packs.gui.components.pack;

import com.google.common.collect.ImmutableList;
import io.github.fishstiz.fidgetz.gui.renderables.ColoredRect;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.fidgetz.util.GuiUtil;
import io.github.fishstiz.packed_packs.gui.components.events.PackListEventListener;
import io.github.fishstiz.packed_packs.util.constants.GuiConstants;
import io.github.fishstiz.packed_packs.util.constants.Theme;
import io.github.fishstiz.packed_packs.pack.PackAssets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_3288;
import net.minecraft.class_332;

import static io.github.fishstiz.fidgetz.util.GuiUtil.playClickSound;
import static io.github.fishstiz.packed_packs.util.InputUtil.isLeftClick;
import static io.github.fishstiz.packed_packs.util.ResourceUtil.getVanillaSprite;
import static io.github.fishstiz.packed_packs.util.lang.ObjectsUtil.pick;
import static java.util.Optional.ofNullable;

public class AvailablePackList extends PackListBase<AvailablePackList.Entry> {
    private static final Sprite SELECT_HIGHLIGHTED_SPRITE = Sprite.of32(getVanillaSprite("transferable_list/select_highlighted"));
    private static final Sprite SELECT_SPRITE = Sprite.of32(getVanillaSprite("transferable_list/select"));
    private static final Theme DROP_ZONE_THEME = Theme.RED_700;
    private static final ColoredRect DROP_ZONE = new ColoredRect(DROP_ZONE_THEME.withAlpha(0.25f));

    public AvailablePackList(PackAssets packAssets, PackListEventListener listener) {
        super(packAssets, listener);
    }

    @Override
    protected @NotNull io.github.fishstiz.packed_packs.gui.components.pack.AvailablePackList.Entry createEntry(class_3288 pack, int index) {
        return new io.github.fishstiz.packed_packs.gui.components.pack.AvailablePackList.Entry(pack, index);
    }

    private boolean isInvalidDrop(PackList source, ImmutableList<class_3288> payload, class_3288 trigger) {
        return source == this || source instanceof FolderPackList || payload.isEmpty() || !source.isTransferable(trigger);
    }

    @Override
    public boolean canDrop(PackList source, ImmutableList<class_3288> payload, class_3288 trigger, double mouseX, double mouseY) {
        return this.method_25405(mouseX, mouseY) && !this.isInvalidDrop(source, payload, trigger);
    }

    @Override
    protected @Nullable List<class_3288> handleDrop(PackList source, ImmutableList<class_3288> payload, class_3288 trigger, double mouseX, double mouseY) {
        if (this.isInvalidDrop(source, payload, trigger)) return null;

        List<class_3288> dropped = new ArrayList<>();
        for (class_3288 pack : payload) {
            if (source.isTransferable(pack)) {
                dropped.add(pack);
            }
        }

        this.clearSelection();
        source.removeAll(dropped);
        this.addAll(dropped);
        this.selectAll(dropped);
        this.select(trigger);
        ofNullable(this.getEntry(trigger)).ifPresent(this::method_25328);

        return dropped;
    }

    @Override
    public void renderDroppableZone(class_332 guiGraphics, PackList source, ImmutableList<class_3288> payload, class_3288 trigger, int mouseX, int mouseY, float partialTick) {
        if (this.isInvalidDrop(source, payload, trigger)) return;

        int width = this.method_57717() ? this.method_25368() - this.scrollbarOffset : this.method_25368();

        if (this.method_25405(mouseX, mouseY)) {
            DROP_ZONE.render(guiGraphics, this.method_46426(), this.method_46427(), width, this.method_25364(), partialTick);
        }

        guiGraphics.method_49601(this.method_46426(), this.method_46427(), width, this.method_25364(), DROP_ZONE_THEME.getARGB());
    }

    public class Entry extends PackListBase<io.github.fishstiz.packed_packs.gui.components.pack.AvailablePackList.Entry>.Entry {
        private Entry(class_3288 pack, int index) {
            super(pack, index);
        }

        @Override
        public boolean isTransferable() {
            return !this.isStale();
        }

        public boolean isMouseOverSelect(double mouseX, double mouseY) {
            return AvailablePackList.this.method_49606() && GuiUtil.containsPoint(this.method_46426() + SPACING, this.method_46427(), SELECT_SPRITE.width, SELECT_SPRITE.height, mouseX, mouseY);
        }

        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (isLeftClick(button) && this.isMouseOverSelect(mouseX, mouseY)) {
                playClickSound();
                this.transfer();
                return false;
            }

            return super.method_25402(mouseX, mouseY, button);
        }

        @Override
        protected void renderForeground(class_332 guiGraphics, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            if (!this.method_25405(mouseX, mouseY) && !this.isSelectedLast()) return;

            int x = left + SPACING;
            GuiConstants.WHITE_OVERLAY.render(guiGraphics, x, top, SELECT_SPRITE.width, SELECT_SPRITE.height);
            if (this.isTransferable()) {
                pick(!this.isMouseOverSelect(mouseX, mouseY), SELECT_SPRITE, SELECT_HIGHLIGHTED_SPRITE).render(guiGraphics, x, top);
            }
        }
    }
}
