package io.github.fishstiz.packed_packs.gui.layouts;

import io.github.fishstiz.fidgetz.gui.components.FidgetzButton;
import io.github.fishstiz.fidgetz.gui.components.ToggleableEditBox;
import io.github.fishstiz.fidgetz.gui.layouts.FlexLayout;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.ButtonSprites;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.fidgetz.gui.shapes.Size;
import io.github.fishstiz.packed_packs.config.Config;
import io.github.fishstiz.packed_packs.config.Profile;
import io.github.fishstiz.packed_packs.gui.components.profile.ProfileList;
import io.github.fishstiz.packed_packs.gui.components.profile.Sidebar;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import io.github.fishstiz.packed_packs.util.constants.GuiConstants;
import io.github.fishstiz.packed_packs.util.constants.Theme;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_3288;
import net.minecraft.class_7847;
import net.minecraft.class_7919;

public class ProfilesLayout {
    public static final class_2561 TITLE_TEXT = ResourceUtil.getText("profile");
    private static final class_2561 EDIT_NAME_TEXT = ResourceUtil.getText("profile.edit");
    private static final class_2561 NO_PROFILE_TEXT = ResourceUtil.getText("profile.none");
    private static final class_2561 UNNAMED_TEXT = ResourceUtil.getText("profile.unnamed");
    private static final class_2561 NEW_TEXT = ResourceUtil.getText("profile.new");
    private static final class_2561 NEW_INFO = ResourceUtil.getText("profile.new.info");
    private static final class_2561 COPY_TEXT = ResourceUtil.getText("profile.copy");
    private static final int MAX_WIDTH = 150;
    private final Config.Packs config;
    private final Sidebar sidebar;
    private final Supplier<List<class_3288>> selectedPacks;
    private final Consumer<Profile> listener;
    private final ToggleableEditBox<Void> nameField = ToggleableEditBox.<Void>builder()
            .setHint(UNNAMED_TEXT)
            .setMaxLength(Profile.NAME_MAX_LENGTH)
            .setFilter(value -> value != null && (value.isEmpty() || !value.isBlank()))
            .addListener(this::onNameChange)
            .build();
    private final FidgetzButton<Void> toggleNameButton = FidgetzButton.<Void>builder()
            .makeSquare()
            .setTooltip(class_7919.method_47407(EDIT_NAME_TEXT))
            .setSprite(new ButtonSprites(
                    new Sprite(ResourceUtil.getIcon("edit"), Size.of16()),
                    new Sprite(ResourceUtil.getIcon("edit_inactive"), Size.of16()))
            )
            .setOnPress(nameField::toggle)
            .build();
    private final FidgetzButton<Void> noProfileButton = FidgetzButton.<Void>builder()
            .setMessage(NO_PROFILE_TEXT)
            .setOnPress(() -> this.setProfile(null))
            .build();
    private final ProfileList profileList;
    private @Nullable Profile profile;

    public ProfilesLayout(Sidebar.Builder sidebar, Config.Packs config, Supplier<List<class_3288>> selectedPacks, Consumer<Profile> listener) {
        this.config = config;
        this.sidebar = sidebar.setMaxWidth(MAX_WIDTH).setTitle(TITLE_TEXT.method_27661().method_54663(Theme.GRAY_800.getARGB()), false).build();
        this.selectedPacks = selectedPacks;
        this.listener = listener;
        this.profileList = new ProfileList(this.config, this::getProfile, this::removeProfile, this::setProfile);

        this.noProfileButton.addListener(() -> this.sidebar.setOpen(false));
    }

    public void initContents() {
        class_7847 layoutSettings = class_7847.method_46481().method_46477(GuiConstants.SPACING);
        FlexLayout actions = FlexLayout.horizontal(this::getMaxWidth).spacing(GuiConstants.SPACING);
        FlexLayout list = FlexLayout.horizontal(this::getMaxWidth);

        actions.addFlexChild(this.noProfileButton);
        actions.addFlexChild(
                FidgetzButton.<Void>builder()
                        .setMessage(NEW_TEXT)
                        .setTooltip(class_7919.method_47407(NEW_INFO))
                        .setOnPress(this::copyProfile)
                        .build()
        );
        list.addFlexChild(this.profileList, true);

        this.sidebar.root().layout().addChild(actions, layoutSettings);
        this.sidebar.root().layout().addFlexChild(list, true, layoutSettings.method_46478().method_46475(GuiConstants.SPACING + 1));
        this.sidebar.root().layout().method_48222();
        this.sidebar.root().layout().method_48206(this.sidebar::addRenderableWidget);

        this.setProfile(this.config.getLastViewed());
    }

    public int getMaxWidth() {
        return MAX_WIDTH;
    }

    public Sidebar getSidebar() {
        return this.sidebar;
    }

    public ToggleableEditBox<Void> getNameField() {
        return this.nameField;
    }

    public FidgetzButton<Void> getToggleNameButton() {
        return this.toggleNameButton;
    }

    private void onNameChange(String value) {
        if (this.profile != null) {
            String name = value;

            if (value.isEmpty()) {
                name = UNNAMED_TEXT.getString();
            }

            this.profile.setName(name);
        }
        this.profileList.scheduleRefresh();
    }

    private void setProfile(@Nullable Profile profile) {
        if (this.profile != null) {
            this.profile.setPacks(this.selectedPacks.get());
        }

        this.profile = profile;

        this.nameField.method_1888(false);

        boolean hasProfile = profile != null;
        this.nameField.method_47404(hasProfile ? UNNAMED_TEXT : NO_PROFILE_TEXT);
        this.nameField.method_1852(hasProfile ? profile.getName() : "");
        this.toggleNameButton.field_22763 = hasProfile;
        this.noProfileButton.field_22763 = hasProfile;

        this.listener.accept(this.profile);
    }

    public @Nullable Profile getProfile() {
        return this.profile;
    }

    private void copyProfile() {
        Profile copiedProfile = this.profile != null
                ? this.profile.copy()
                : new Profile(NO_PROFILE_TEXT.getString() + " - " + COPY_TEXT.getString());

        copiedProfile.setPacks(this.selectedPacks.get());
        this.config.addProfile(copiedProfile);
        this.setProfile(copiedProfile);
        this.sidebar.setOpen(false);
        this.profileList.refresh();
    }

    private void removeProfile(Profile profile) {
        if (profile != null && this.profile == profile) {
            List<Profile> profiles = this.config.getProfiles();
            if (!profiles.isEmpty()) {
                int index = profiles.indexOf(profile);
                Profile previous = (index > 0) ? profiles.get(index - 1) : null;
                this.setProfile(previous);
            } else {
                this.setProfile(null);
            }
        }
        this.config.removeProfile(profile);
        this.profileList.refresh();
    }
}
