package io.github.fishstiz.packed_packs.gui.layouts.pack;

import io.github.fishstiz.fidgetz.gui.components.CyclicButton;
import io.github.fishstiz.fidgetz.gui.components.ToggleButton;
import io.github.fishstiz.fidgetz.gui.layouts.FlexLayout;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.fidgetz.gui.shapes.Size;
import io.github.fishstiz.packed_packs.PackedPacks;
import io.github.fishstiz.packed_packs.gui.components.pack.AvailablePackList;
import io.github.fishstiz.packed_packs.gui.components.pack.Query;
import io.github.fishstiz.packed_packs.gui.components.events.PackListEventListener;
import io.github.fishstiz.packed_packs.gui.components.events.QueryEvent;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import net.minecraft.class_2561;
import net.minecraft.class_7919;
import io.github.fishstiz.packed_packs.pack.PackAssets;
import org.jetbrains.annotations.NotNull;

public final class AvailablePacksLayout extends PackLayout<AvailablePackList> {
    private static final class_2561 SORT_TEXT = ResourceUtil.getText("sort");
    private static final class_2561 COMPAT_TEXT = ResourceUtil.getText("hide_incompatible");
    private static final class_2561 COMPAT_INFO = ResourceUtil.getText("hide_incompatible.info");
    private final PackListEventListener eventListener;
    private CyclicButton<Query.SortOption, Void> sortButton;
    private ToggleButton<Void> compatButton;

    public AvailablePacksLayout(PackAssets packAssets, PackListEventListener listener) {
        super(new AvailablePackList(packAssets, listener));

        this.eventListener = listener;
    }

    public CyclicButton<Query.SortOption, Void> getSortButton() {
        return this.sortButton;
    }

    public ToggleButton<Void> getCompatButton() {
        return this.compatButton;
    }

    private void sendQueryEvent() {
        this.eventListener.onEvent(new QueryEvent(this.list));
    }

    @Override
    protected void initHeader(@NotNull FlexLayout header) {
        this.sortButton = CyclicButton.<Query.SortOption, Void>builder(Query.SortOption.values())
                .setPrefix(SORT_TEXT)
                .makeSquare()
                .addListener(value -> this.sendQueryEvent())
                .addListener(this.list::sort)
                .addListener(PackedPacks.CONFIG::setSort)
                .setValue(PackedPacks.CONFIG.getSort())
                .build();
        this.compatButton = ToggleButton.<Void>builder()
                .setMessage(COMPAT_TEXT)
                .setTooltip(class_7919.method_47407(COMPAT_INFO))
                .setSprite(ToggleButton.Sprites.of(
                        new Sprite(ResourceUtil.getIcon("incompatible_hidden"), Size.of16()),
                        new Sprite(ResourceUtil.getIcon("incompatible"), Size.of16())
                ))
                .makeSquare()
                .addListener(value -> this.sendQueryEvent())
                .addListener(this.list::hideIncompatible)
                .addListener(PackedPacks.CONFIG::setHideIncompatible)
                .setValue(PackedPacks.CONFIG.isHideIncompatible())
                .build();

        this.list.sort(this.sortButton.getValue());
        this.list.hideIncompatible(this.compatButton.getValue());
        this.getTransferButton().method_25355(class_2561.method_43470(">>"));

        header.addFlexChild(this.getSearchField());
        header.addChild(sortButton);
        header.addChild(compatButton);
        header.addChild(this.getTransferButton());
    }
}
