package io.github.fishstiz.fidgetz.gui.components;

import io.github.fishstiz.fidgetz.util.lang.CollectionsUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_364;

import static io.github.fishstiz.fidgetz.util.GuiUtil.isDescendant;

public interface ToggleableDialogContainer {
    List<ToggleableDialog<?>> getDialogs();

    default List<ToggleableDialog<?>> getOpenDialogs() {
        return CollectionsUtil.filter(this.getDialogs(), ToggleableDialog::isOpen, ObjectArrayList::new);
    }

    default boolean isChildCovered(class_364 child) {
        boolean isDialogChild = false;
        boolean isEnclosed = false;

        for (ToggleableDialog<?> dialog : this.getOpenDialogsFromTop()) {
            if (dialog != child && (dialog.isCaptureClick() || dialog.isCaptureFocus()) && !isDescendant(dialog, child)) {
                return true;
            }
            if (!isEnclosed && isDescendant(dialog, child)) {
                isDialogChild = true;
                break;
            }
            if (!isEnclosed && dialog != child && dialog.encloses(child)) {
                isEnclosed = true;
            }
        }

        return !isDialogChild && isEnclosed;
    }

    private List<ToggleableDialog<?>> getOpenDialogsFromTop() {
        List<ToggleableDialog<?>> dialogs = this.getOpenDialogs();
        dialogs.sort(Comparator.<ToggleableDialog<?>, Float>comparing(ToggleableDialog::getZ).reversed());
        return dialogs;
    }
}
