package io.github.fishstiz.fidgetz.util;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.NineSliceSprite;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.fidgetz.gui.shapes.Line;
import io.github.fishstiz.fidgetz.gui.shapes.Size;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;

public class DrawUtil {
    public static final Sprite DEMO_BACKGROUND = new NineSliceSprite(new Sprite(
            class_2960.method_60656("textures/gui/demo_background.png"),
            Size.square(256),
            Line.zero(247),
            Line.zero(165)
    ));
    public static final class_2960 SHADOW_SPRITE = class_2960.method_60655("fidgetz", "drop_shadow");
    private static final int SHADOW_BORDER = 32;

    private DrawUtil() {
    }

    public static int renderScrollingStringLeftAlign(
            class_332 guiGraphics,
            class_327 font,
            class_2561 text,
            int startX,
            int startY,
            int endX,
            int endY,
            int color,
            boolean shadow
    ) {
        int textWidth = font.method_27525(text);
        int textY = (startY + endY - 9) / 2 + 1;
        int availableWidth = endX - startX;

        if (textWidth > availableWidth) {
            int overflowWidth = textWidth - availableWidth;
            double timeSeconds = class_156.method_658() / 1000.0;
            double scrollDuration = Math.max(overflowWidth * 0.5, 3.0);
            double scrollFactor = Math.sin((Math.PI / 2) * Math.cos((Math.PI * 2) * timeSeconds / scrollDuration)) / 2.0 + 0.5;
            double scrollOffset = class_3532.method_16436(scrollFactor, 0.0, overflowWidth);

            guiGraphics.method_44379(startX, startY, endX, endY);
            int width = guiGraphics.method_51439(font, text, startX - (int) scrollOffset, textY, color, shadow);
            guiGraphics.method_44380();

            return width;
        } else {
            return guiGraphics.method_51439(font, text, startX, textY, color, shadow);
        }
    }

    public static int renderScrollingStringLeftAlign(
            class_332 guiGraphics,
            class_327 font,
            class_2561 text,
            int startX,
            int startY,
            int endX,
            int endY,
            int color
    ) {
        return renderScrollingStringLeftAlign(guiGraphics, font, text, startX, startY, endX, endY, color, true);
    }

    public static void renderDropShadow(class_332 guiGraphics, int x, int y, int width, int height, int shadowSize) {
        float scale = (float) shadowSize / SHADOW_BORDER;
        int offset = Math.round(SHADOW_BORDER * scale);
        RenderSystem.enableBlend();
        guiGraphics.method_52706(
                SHADOW_SPRITE,
                x - offset,
                y - offset,
                width + offset * 2,
                height + offset * 2
        );
        RenderSystem.defaultBlendFunc();
    }
}
