package io.github.fishstiz.packed_packs.gui.components.pack;

import io.github.fishstiz.fidgetz.gui.renderables.ColoredRect;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.fidgetz.util.GuiUtil;
import io.github.fishstiz.packed_packs.gui.components.SelectionContext;
import io.github.fishstiz.packed_packs.gui.components.events.DragEvent;
import io.github.fishstiz.packed_packs.gui.components.events.PackListEventListener;
import io.github.fishstiz.packed_packs.pack.PackAssetManager;
import io.github.fishstiz.packed_packs.pack.PackFileOperations;
import io.github.fishstiz.packed_packs.pack.PackOptionsContext;
import io.github.fishstiz.packed_packs.util.constants.GuiConstants;
import io.github.fishstiz.packed_packs.util.constants.Theme;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_3288;
import net.minecraft.class_332;

import static io.github.fishstiz.fidgetz.util.GuiUtil.playClickSound;
import static io.github.fishstiz.packed_packs.util.InputUtil.isLeftClick;
import static io.github.fishstiz.packed_packs.util.ResourceUtil.getVanillaSprite;
import static io.github.fishstiz.fidgetz.util.lang.ObjectsUtil.ifPresent;
import static io.github.fishstiz.fidgetz.util.lang.ObjectsUtil.pick;

public class AvailablePackList extends PackList {
    private static final Sprite SELECT_HIGHLIGHTED_SPRITE = Sprite.of32(getVanillaSprite("transferable_list/select_highlighted"));
    private static final Sprite SELECT_SPRITE = Sprite.of32(getVanillaSprite("transferable_list/select"));
    private static final Theme DROP_ZONE_THEME = Theme.RED_700;
    private static final ColoredRect DROP_ZONE = new ColoredRect(DROP_ZONE_THEME.withAlpha(0.25f));

    public AvailablePackList(PackOptionsContext options, PackAssetManager assets, PackFileOperations fileOps, PackListEventListener listener) {
        super(options, assets, fileOps, listener);
    }

    @Override
    protected @NotNull io.github.fishstiz.packed_packs.gui.components.pack.AvailablePackList.Entry createEntry(SelectionContext<class_3288> context, int index) {
        return new io.github.fishstiz.packed_packs.gui.components.pack.AvailablePackList.Entry(context, index);
    }

    @Override
    public boolean canInteract(PackList source) {
        return source != this;
    }

    private boolean isInvalidDrop(PackList source, List<class_3288> payload, class_3288 trigger) {
        return !source.canInteract(this) || payload.isEmpty() || !source.isTransferable(trigger);
    }

    @Override
    public boolean canDrop(DragEvent dragEvent, double mouseX, double mouseY) {
        return this.method_25405(mouseX, mouseY) && !this.isInvalidDrop(dragEvent.target(), dragEvent.payload(), dragEvent.trigger());
    }

    @Override
    protected List<class_3288> handleDrop(DragEvent dragEvent, double mouseX, double mouseY) {
        PackList source = dragEvent.target();
        List<class_3288> payload = dragEvent.payload();
        class_3288 trigger = dragEvent.trigger();

        if (this.isInvalidDrop(source, payload, trigger)){
            return Collections.emptyList();
        }

        List<class_3288> dropped = new ArrayList<>();
        for (class_3288 pack : payload) {
            if (source.isTransferable(pack)) {
                dropped.add(pack);
            }
        }

        this.clearSelection();
        source.removeAll(dropped);
        this.addAll(dropped);
        this.selectAll(dropped);
        this.select(trigger);
        ifPresent(this.getEntry(trigger), this::method_25328);

        return dropped;
    }

    @Override
    public void renderDroppableZone(class_332 guiGraphics, DragEvent dragEvent, int mouseX, int mouseY, float partialTick) {
        PackList source = dragEvent.target();
        List<class_3288> payload = dragEvent.payload();
        class_3288 trigger = dragEvent.trigger();

        if (this.isInvalidDrop(source, payload, trigger)) return;

        int width = this.method_57717() ? this.method_25368() - this.scrollbarOffset : this.method_25368();

        if (this.method_25405(mouseX, mouseY)) {
            DROP_ZONE.render(guiGraphics, this.method_46426(), this.method_46427(), width, this.method_25364(), partialTick);
        }

        guiGraphics.method_49601(this.method_46426(), this.method_46427(), width, this.method_25364(), DROP_ZONE_THEME.getARGB());
    }

    public class Entry extends PackList.Entry {
        private Entry(SelectionContext<class_3288> context, int index) {
            super(context, index);
        }

        public boolean isMouseOverSelect(double mouseX, double mouseY) {
            return AvailablePackList.this.method_49606() && GuiUtil.containsPoint(this.method_46426() + SPACING, this.method_46427(), SELECT_SPRITE.width, SELECT_SPRITE.height, mouseX, mouseY);
        }

        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (isLeftClick(button) && this.isMouseOverSelect(mouseX, mouseY)) {
                playClickSound();
                this.transfer();
                return false;
            }

            return super.method_25402(mouseX, mouseY, button);
        }

        @Override
        protected void renderForeground(class_332 guiGraphics, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            if (!hovering && !this.isSelectedLast()) return;

            int x = left + SPACING;
            GuiConstants.WHITE_OVERLAY.render(guiGraphics, x, top, SELECT_SPRITE.width, SELECT_SPRITE.height);
            if (this.isTransferable()) {
                pick(!this.isMouseOverSelect(mouseX, mouseY), SELECT_SPRITE, SELECT_HIGHLIGHTED_SPRITE).render(guiGraphics, x, top);
            }
        }

        @Override
        protected void handleDevMenuEvent(PackListDevMenu.Event<?> event) {
            super.handleDevMenuEvent(event);
            if (event instanceof PackListDevMenu.Event.Require(Pack trigger, Boolean value, List<Pack> required) &&
                Boolean.TRUE.equals(value)) {
                this.sendPacks(trigger, required);
            }
        }
    }
}
