/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.components.pack;

import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuItemBuilder;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.fidgetz.util.lang.ObjectsUtil;
import io.github.fishstiz.packed_packs.config.PackOverride;
import io.github.fishstiz.packed_packs.config.Profile;
import io.github.fishstiz.packed_packs.gui.components.SelectionContext;
import io.github.fishstiz.packed_packs.gui.components.ToggleableHelper;
import io.github.fishstiz.packed_packs.pack.PackOptionsContext;
import io.github.fishstiz.packed_packs.pack.ProfileScope;
import io.github.fishstiz.packed_packs.transform.interfaces.ConfiguredPack;
import io.github.fishstiz.packed_packs.transform.interfaces.FilePack;
import io.github.fishstiz.packed_packs.util.PackUtil;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import io.github.fishstiz.packed_packs.util.constants.GuiConstants;
import io.github.fishstiz.packed_packs.util.constants.Theme;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.Pack;
import org.jetbrains.annotations.Nullable;

public record PackListDevMenu(Minecraft minecraft, PackOptionsContext options, SelectionContext<Pack> context, Consumer<Event<?>> listener) {
    private static final int DEV_SPRITE_SIZE = 16;
    private static final int DEV_SPRITE_MARGIN_RIGHT = 8;
    private static final Sprite EYE_SLASH_SPRITE = Sprite.of16((ResourceLocation)ResourceUtil.getIcon("eye_slash"));
    private static final Sprite X_SQUARE = Sprite.of16((ResourceLocation)ResourceUtil.getIcon("x_square"));
    private static final Sprite ARROW_UP_SPRITE = Sprite.of16((ResourceLocation)ResourceUtil.getIcon("arrow_up"));
    private static final Sprite ARROW_DOWN_SPRITE = Sprite.of16((ResourceLocation)ResourceUtil.getIcon("arrow_down"));
    private static final Sprite ARROWS_SPRITE = Sprite.of16((ResourceLocation)ResourceUtil.getIcon("arrows_vertical"));
    private static final Sprite RADIO_GLOBAL = Sprite.of16((ResourceLocation)ResourceUtil.getIcon("radio_globe"));
    private static final Sprite ALIAS_SPRITE = Sprite.of16((ResourceLocation)ResourceUtil.getIcon("alias"));
    private static final Component HIDDEN = PackListDevMenu.overrideText("hidden");
    private static final Component REQUIRED = PackListDevMenu.overrideText("required");
    private static final Component FIXED_POSITION = PackListDevMenu.overrideText("fixed");
    private static final Component FIXED_TOP = PackListDevMenu.overrideText("fixed.top");
    private static final Component FIXED_BOTTOM = PackListDevMenu.overrideText("fixed.bottom");
    private static final Component REMOVE_OVERRIDES = PackListDevMenu.overrideText("remove");
    private static final Tooltip REQUIRED_NO_DISABLED_INFO = Tooltip.create((Component)PackListDevMenu.overrideText("required.no.disabled.info"));

    private <T> void notifyListener(T value, List<Pack> packs, EventFactory<T> eventFactory) {
        if (this.listener != null) {
            this.listener.accept(eventFactory.create(this.pack(), value, packs));
        }
    }

    private static Component overrideText(String keySuffix) {
        return ResourceUtil.getText("profile.override." + keySuffix, new Object[0]);
    }

    private Pack pack() {
        return this.context.item();
    }

    private ProfileScope hasOverride(BiPredicate<Profile, Pack> option) {
        return this.options.hasOverride(this.context.item(), option);
    }

    private List<Pack> getPackOrSelection() {
        return this.context.getItemOrSelection();
    }

    public void renderDevSprites(GuiGraphics guiGraphics, int top, int left, int width) {
        ProfileScope included;
        ProfileScope hiddenOverride;
        ProfileScope requiredOverride;
        int size = 16;
        int iconX = left + width - size - 8;
        ProfileScope positionOverride = this.hasOverride(Profile::overridesPosition);
        if (positionOverride.exists()) {
            boolean unfixed = !this.options.isFixed(this.pack());
            boolean fixedTop = this.options.getPosition(this.pack()) == Pack.Position.TOP;
            guiGraphics.fill(iconX, top, iconX + size, top + size, PackListDevMenu.getBackgroundColor(positionOverride));
            ((Sprite)ObjectsUtil.pick((boolean)unfixed, (Object)ARROWS_SPRITE, (Object)((Sprite)ObjectsUtil.pick((boolean)fixedTop, (Object)ARROW_UP_SPRITE, (Object)ARROW_DOWN_SPRITE)))).render(guiGraphics, iconX, top, size, size);
            iconX -= size;
        }
        if ((requiredOverride = this.hasOverride(Profile::overridesRequired)).exists()) {
            boolean required = this.options.isRequired(this.pack());
            guiGraphics.fill(iconX, top, iconX + size, top + size, PackListDevMenu.getBackgroundColor(requiredOverride));
            ((Sprite)ObjectsUtil.pick((boolean)required, (Object)GuiConstants.LOCK_SPRITE_SMALL, (Object)GuiConstants.UNLOCK_SPRITE_SMALL)).render(guiGraphics, iconX, top, size, size);
            iconX -= size;
        }
        if ((hiddenOverride = this.hasOverride(Profile::isHidden)).exists()) {
            guiGraphics.fill(iconX, top, iconX + size, top + size, PackListDevMenu.getBackgroundColor(hiddenOverride));
            EYE_SLASH_SPRITE.render(guiGraphics, iconX, top, size, size);
            iconX -= size;
        }
        if ((included = this.hasOverride(Profile::includes)).global() && !((ConfiguredPack)this.pack()).packed_packs$getMetadata().compatibility().isCompatible()) {
            guiGraphics.fill(iconX, top, iconX + size, top + size, Theme.RED_700.withAlpha(0.75f));
            X_SQUARE.render(guiGraphics, iconX, top, size, size);
            iconX -= size;
        }
        if (this.options.getConfig().hasAlias(this.pack().getId())) {
            guiGraphics.fill(iconX, top, iconX + size, top + size, Theme.GREEN_500.withAlpha(0.75f));
            ALIAS_SPRITE.render(guiGraphics, iconX, top, size, size);
        }
    }

    private void updateHidden(boolean hidden) {
        this.options.getProfile().ifPresent(profile -> {
            List<Pack> selected = this.getPackOrSelection();
            profile.setHidden(hidden, selected);
            this.notifyListener(hidden, selected, Event.Hide::new);
        });
    }

    private void updateRequired(@Nullable Boolean required) {
        this.options.getProfile().ifPresent(profile -> {
            List<Pack> selected = this.getPackOrSelection();
            profile.setRequired(required, selected);
            this.notifyListener(required, selected, Event.Require::new);
        });
    }

    private void updatePosition(@Nullable PackOverride.Position position) {
        this.options.getProfile().ifPresent(profile -> {
            List<Pack> selected = this.getPackOrSelection();
            profile.setPosition(position, selected);
            this.notifyListener(position, selected, Event.Reposition::new);
        });
    }

    private void resetOverrides() {
        this.updateHidden(false);
        this.updateRequired(null);
        this.updatePosition(null);
    }

    private Sprite getIcon(boolean active, BiPredicate<Profile, Pack> defaultOption) {
        return this.hasOverride(defaultOption) == ProfileScope.GLOBAL ? RADIO_GLOBAL : ToggleableHelper.getDefaultIcon(active);
    }

    private boolean canDisableRequired() {
        return this.options.isDefaultProfile() && !PackUtil.isEssential(this.pack());
    }

    private void buildNonOverrideOptions(ContextMenuItemBuilder builder) {
        builder.add(GuiConstants.devItem((Component)Component.translatable((String)"chat.copy")).action(() -> this.minecraft.keyboardHandler.setClipboard(this.pack().getId())).build()).separator();
        builder.add(GuiConstants.devItem((Component)ResourceUtil.getText("aliases.edit", new Object[0])).action(() -> this.listener.accept(new Event.EditAliases(this.pack(), this.options.getConfig().hasAlias(this.pack().getId())))).build()).separator();
    }

    public void onBuildHeader(ContextMenuItemBuilder builder) {
        Profile profile = this.options.getProfile().orElse(null);
        if (profile == null) {
            this.buildNonOverrideOptions(builder);
            return;
        }
        builder.add(GuiConstants.devItem(HIDDEN).icon(() -> this.getIcon(profile.isHidden(this.pack()), Profile::isHidden)).activeWhen(() -> this.hasOverride(Profile::isHidden) != ProfileScope.GLOBAL).action(() -> this.updateHidden(!profile.isHidden(this.pack()))).closeOnInteract(false).build());
        builder.add(GuiConstants.devItem(REQUIRED).icon(() -> this.options.isLocked() ? GuiConstants.LOCK_SPRITE_SMALL : this.getIcon(profile.overridesRequired(this.pack()), Profile::overridesRequired)).activeWhen(() -> !this.options.isLocked() && this.hasOverride(Profile::overridesRequired) != ProfileScope.GLOBAL && !((FilePack)this.pack()).packed_packs$nestedPack()).closeOnInteract(false).addChild(GuiConstants.devItem(CommonComponents.OPTION_OFF).icon(() -> ToggleableHelper.getDefaultIcon(!profile.overridesRequired(this.pack()))).action(() -> this.updateRequired(null)).closeOnInteract(false).build()).addChild(GuiConstants.devItem(CommonComponents.GUI_NO).icon(() -> ToggleableHelper.getDefaultIcon(profile.overridesRequired(this.pack()) && !profile.isRequired(this.pack()))).activeWhen(this::canDisableRequired).tooltip(() -> !this.canDisableRequired() && !PackUtil.isEssential(this.pack()) ? REQUIRED_NO_DISABLED_INFO : null).action(() -> this.updateRequired(false)).closeOnInteract(false).build()).addChild(GuiConstants.devItem(CommonComponents.GUI_YES).icon(() -> ToggleableHelper.getDefaultIcon(profile.isRequired(this.pack()))).action(() -> this.updateRequired(true)).closeOnInteract(false).build()).build());
        builder.add(GuiConstants.devItem(FIXED_POSITION).icon(() -> this.getIcon(profile.overridesPosition(this.pack()), Profile::overridesPosition)).activeWhen(() -> this.hasOverride(Profile::overridesPosition) != ProfileScope.GLOBAL).closeOnInteract(false).addChild(GuiConstants.devItem(CommonComponents.OPTION_OFF).icon(() -> ToggleableHelper.getDefaultIcon(!profile.overridesPosition(this.pack()))).action(() -> this.updatePosition(null)).closeOnInteract(false).build()).addChild(GuiConstants.devItem(CommonComponents.GUI_NO).icon(() -> ToggleableHelper.getDefaultIcon(profile.overridesPosition(this.pack()) && !profile.isFixed(this.pack()))).action(() -> this.updatePosition(PackOverride.Position.UNFIXED)).closeOnInteract(false).build()).addChild(GuiConstants.devItem(FIXED_TOP).icon(() -> ToggleableHelper.getDefaultIcon(profile.getPositionOverride(this.pack()) == PackOverride.Position.TOP)).action(() -> this.updatePosition(PackOverride.Position.TOP)).closeOnInteract(false).build()).addChild(GuiConstants.devItem(FIXED_BOTTOM).icon(() -> ToggleableHelper.getDefaultIcon(profile.getPositionOverride(this.pack()) == PackOverride.Position.BOTTOM)).action(() -> this.updatePosition(PackOverride.Position.BOTTOM)).closeOnInteract(false).build()).build());
        builder.add(GuiConstants.devItem(REMOVE_OVERRIDES).action(this::resetOverrides).build()).separator();
        this.buildNonOverrideOptions(builder);
    }

    private static int getBackgroundColor(ProfileScope overrideScope) {
        return switch (overrideScope) {
            default -> throw new MatchException(null, null);
            case ProfileScope.NONE -> Theme.WHITE.withAlpha(0.0f);
            case ProfileScope.LOCAL -> Theme.BLACK.withAlpha(0.75f);
            case ProfileScope.GLOBAL -> Theme.BLUE_500.withAlpha(0.75f);
            case ProfileScope.COMPOSITE -> Theme.PURPLE_500.withAlpha(0.75f);
        };
    }

    @FunctionalInterface
    private static interface EventFactory<T> {
        public Event<T> create(Pack var1, T var2, List<Pack> var3);
    }

    public static sealed interface Event<T> {
        public Pack trigger();

        public List<Pack> packs();

        public T value();

        public static final class Reposition
        extends Record
        implements Event<PackOverride.Position> {
            private final Pack trigger;
            @Nullable
            private final PackOverride.Position value;
            private final List<Pack> packs;

            public Reposition(Pack trigger, @Nullable PackOverride.Position value, List<Pack> packs) {
                this.trigger = trigger;
                this.value = value;
                this.packs = packs;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{Reposition.class, "trigger;value;packs", "trigger", "value", "packs"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Reposition.class, "trigger;value;packs", "trigger", "value", "packs"}, this);
            }

            @Override
            public final boolean equals(Object o) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Reposition.class, "trigger;value;packs", "trigger", "value", "packs"}, this, o);
            }

            @Override
            public Pack trigger() {
                return this.trigger;
            }

            @Override
            @Nullable
            public PackOverride.Position value() {
                return this.value;
            }

            @Override
            public List<Pack> packs() {
                return this.packs;
            }
        }

        public static final class Require
        extends Record
        implements Event<Boolean> {
            private final Pack trigger;
            @Nullable
            private final Boolean value;
            private final List<Pack> packs;

            public Require(Pack trigger, @Nullable Boolean value, List<Pack> packs) {
                this.trigger = trigger;
                this.value = value;
                this.packs = packs;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{Require.class, "trigger;value;packs", "trigger", "value", "packs"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Require.class, "trigger;value;packs", "trigger", "value", "packs"}, this);
            }

            @Override
            public final boolean equals(Object o) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Require.class, "trigger;value;packs", "trigger", "value", "packs"}, this, o);
            }

            @Override
            public Pack trigger() {
                return this.trigger;
            }

            @Override
            @Nullable
            public Boolean value() {
                return this.value;
            }

            @Override
            public List<Pack> packs() {
                return this.packs;
            }
        }

        public static final class Hide
        extends Record
        implements Event<Boolean> {
            private final Pack trigger;
            private final Boolean value;
            private final List<Pack> packs;

            public Hide(Pack trigger, Boolean value, List<Pack> packs) {
                this.trigger = trigger;
                this.value = value;
                this.packs = packs;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{Hide.class, "trigger;value;packs", "trigger", "value", "packs"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Hide.class, "trigger;value;packs", "trigger", "value", "packs"}, this);
            }

            @Override
            public final boolean equals(Object o) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Hide.class, "trigger;value;packs", "trigger", "value", "packs"}, this, o);
            }

            @Override
            public Pack trigger() {
                return this.trigger;
            }

            @Override
            public Boolean value() {
                return this.value;
            }

            @Override
            public List<Pack> packs() {
                return this.packs;
            }
        }

        public static final class EditAliases
        extends Record
        implements Event<Boolean> {
            private final Pack trigger;
            private final Boolean value;

            public EditAliases(Pack trigger, Boolean value) {
                this.trigger = trigger;
                this.value = value;
            }

            @Override
            public List<Pack> packs() {
                return List.of(this.trigger);
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{EditAliases.class, "trigger;value", "trigger", "value"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{EditAliases.class, "trigger;value", "trigger", "value"}, this);
            }

            @Override
            public final boolean equals(Object o) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{EditAliases.class, "trigger;value", "trigger", "value"}, this, o);
            }

            @Override
            public Pack trigger() {
                return this.trigger;
            }

            @Override
            public Boolean value() {
                return this.value;
            }
        }
    }
}

