/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.components.pack;

import io.github.fishstiz.fidgetz.util.lang.CollectionsUtil;
import io.github.fishstiz.packed_packs.config.Config;
import io.github.fishstiz.packed_packs.gui.components.SelectableList;
import io.github.fishstiz.packed_packs.gui.components.pack.Query;
import io.github.fishstiz.packed_packs.gui.history.Restorable;
import io.github.fishstiz.packed_packs.pack.PackOptionsContext;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.ToIntFunction;
import net.minecraft.server.packs.repository.Pack;
import org.jetbrains.annotations.NotNull;

public class PackListModel
extends SelectableList<Pack>
implements Restorable<Snapshot> {
    private final PackOptionsContext options;
    private Query query = new Query();

    public PackListModel(PackOptionsContext options) {
        this.options = options;
    }

    private boolean updateQuery(Query query) {
        Query previousQuery = this.query;
        this.query = Objects.requireNonNull(query, "query");
        return !Objects.equals(this.query, previousQuery);
    }

    public boolean sort(Query.SortOption sort) {
        return this.updateQuery(this.query.withSort(sort));
    }

    public boolean search(String search) {
        return this.updateQuery(this.query.withSearch(search));
    }

    public boolean hideIncompatible(boolean hide) {
        return this.updateQuery(this.query.withHideIncompatible(hide));
    }

    public boolean isQueried() {
        return this.query.hasQuery();
    }

    @Override
    protected boolean filter(Pack pack) {
        if (!Config.get().isDevMode() && this.options.isHidden(pack)) {
            return false;
        }
        if (!this.query.test(pack)) {
            return false;
        }
        return super.filter(pack);
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.query.sort() != null) {
            this.visibleItems.sort(this.query);
        }
    }

    @Override
    public void add(Pack pack) {
        if (pack != null && !this.items.contains(pack)) {
            Pack p;
            int index = 0;
            Iterator iterator = this.items.iterator();
            while (iterator.hasNext() && this.options.isFixed(p = (Pack)iterator.next()) && this.options.getPosition(p) != Pack.Position.BOTTOM) {
                ++index;
            }
            this.items.add(index, pack);
        }
    }

    @Override
    public boolean move(int index, Pack pack) {
        return !this.options.isFixed(pack) && super.move(index, pack);
    }

    public boolean moveUp(Pack pack) {
        return this.movePack(this::getMoveUpIndex, pack);
    }

    public boolean moveDown(Pack pack) {
        return this.movePack(this::getMoveDownIndex, pack);
    }

    public List<Pack> moveSelectionUp(List<Pack> selection) {
        return this.moveSelection(this::getMoveUpIndex, this.orderByVisible(selection));
    }

    public List<Pack> moveSelectionDown(List<Pack> selection) {
        return this.moveSelection(this::getMoveDownIndex, (List<Pack>)this.orderByVisible(selection).reversed());
    }

    private boolean movePack(ToIntFunction<Pack> moveIndexFn, Pack pack) {
        if (this.items.contains(pack)) {
            int targetIndex = moveIndexFn.applyAsInt(pack);
            return targetIndex > -1 && this.move(targetIndex, pack);
        }
        return false;
    }

    private List<Pack> moveSelection(ToIntFunction<Pack> moveIndexFn, List<Pack> selection) {
        ObjectArrayList moved = new ObjectArrayList();
        ObjectOpenHashSet packSet = new ObjectOpenHashSet((Collection)this.items);
        for (int i = 0; i < selection.size(); ++i) {
            Pack pack = selection.get(i);
            if (!packSet.contains(pack)) continue;
            int index = moveIndexFn.applyAsInt(pack);
            if (index > -1 && this.move(index, pack)) {
                moved.add(pack);
                continue;
            }
            if (i != 0) continue;
            return Collections.emptyList();
        }
        return moved;
    }

    public boolean canMoveUp(Pack pack) {
        List selection;
        if (!this.canMove(pack)) {
            return false;
        }
        if (this.isSelected(pack) && (selection = this.getOrderedSelection()).size() > 1) {
            int index = this.items.indexOf(selection.getFirst());
            int moveIndex = index > -1 ? this.getMoveUpIndex(pack) : -1;
            return index > 0 && moveIndex > -1 && !this.options.isFixed((Pack)this.items.get(moveIndex));
        }
        int index = this.items.indexOf(pack);
        int moveIndex = this.getMoveUpIndex(pack);
        return index > 0 && moveIndex > -1 && !this.options.isFixed((Pack)this.items.get(moveIndex));
    }

    public boolean canMoveDown(Pack pack) {
        List selection;
        if (!this.canMove(pack)) {
            return false;
        }
        int size = this.items.size();
        if (this.isSelected(pack) && (selection = this.getOrderedSelection()).size() > 1) {
            int index = this.items.indexOf(selection.getLast());
            int moveIndex = index > -1 ? this.getMoveDownIndex(pack) : -1;
            return index > -1 && index < size - 1 && moveIndex > -1 && !this.options.isFixed((Pack)this.items.get(moveIndex));
        }
        int index = this.items.indexOf(pack);
        int moveIndex = this.getMoveDownIndex(pack);
        return index > -1 && index < size - 1 && moveIndex > -1 && !this.options.isFixed((Pack)this.items.get(moveIndex));
    }

    private boolean canMove(Pack pack) {
        return !this.options.isLocked() && !this.options.isFixed(pack) && !this.isQueried();
    }

    private int getMoveUpIndex(Pack pack) {
        for (int i = this.items.indexOf(pack) - 1; i >= 0; --i) {
            Pack nextPack = (Pack)this.items.get(i);
            if (this.options.isFixed(nextPack)) {
                return -1;
            }
            if (this.options.isHidden(nextPack)) continue;
            return i;
        }
        return -1;
    }

    private int getMoveDownIndex(Pack pack) {
        for (int i = this.items.indexOf(pack) + 1; i < this.items.size(); ++i) {
            Pack nextPack = (Pack)this.items.get(i);
            if (this.options.isFixed(nextPack)) {
                return -1;
            }
            if (this.options.isHidden(nextPack)) continue;
            return i;
        }
        return -1;
    }

    public int clampPosition(int index) {
        if (index == -1) {
            int minIndex = 0;
            for (int i = 0; i < this.items.size(); ++i) {
                Pack pack = (Pack)this.items.get(i);
                if (!this.options.isFixed(pack) || this.options.getPosition(pack) != Pack.Position.TOP) continue;
                minIndex = i + 1;
            }
            return minIndex;
        }
        return index;
    }

    public boolean isValidDropPosition(int index) {
        if (index < 0 || index > this.items.size()) {
            return false;
        }
        int minDropIndex = 0;
        int maxDropIndex = this.items.size();
        block4: for (int i = 0; i < this.items.size(); ++i) {
            Pack pack = (Pack)this.items.get(i);
            if (!this.options.isFixed(pack)) continue;
            switch (this.options.getPosition(pack)) {
                case TOP: {
                    minDropIndex = i + 1;
                    continue block4;
                }
                case BOTTOM: {
                    maxDropIndex = Math.min(i, maxDropIndex);
                }
            }
        }
        return index >= minDropIndex && index <= maxDropIndex;
    }

    @Override
    public void replaceState(@NotNull Snapshot snapshot) {
        this.replaceAll(snapshot.packs);
        this.clearSelection();
        this.selectedItems.addAll(snapshot.selection);
        this.query = new Query(snapshot.query);
        this.refresh();
    }

    @Override
    @NotNull
    public Snapshot captureState(String eventName) {
        return new Snapshot(this, List.copyOf(this.items), List.copyOf(this.selectedItems), new Query(this.query));
    }

    public static final class Snapshot
    extends Record
    implements Restorable.Snapshot<Snapshot> {
        private final PackListModel target;
        private final List<Pack> packs;
        private final List<Pack> selection;
        private final Query query;

        public Snapshot(PackListModel target, List<Pack> packs, List<Pack> selection, Query query) {
            this.target = target;
            this.packs = packs;
            this.selection = selection;
            this.query = query;
        }

        public Snapshot retainAll(Set<Pack> validPacks) {
            ObjectArrayList packs = new ObjectArrayList(this.packs.size());
            CollectionsUtil.addIf((Collection)packs, this.packs, validPacks::contains);
            return new Snapshot(this.target, List.copyOf(packs), this.selection, this.query);
        }

        public Snapshot replaceAll(List<Pack> packs) {
            return new Snapshot(this.target, List.copyOf(packs), this.selection, this.query);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Snapshot.class, "target;packs;selection;query", "target", "packs", "selection", "query"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Snapshot.class, "target;packs;selection;query", "target", "packs", "selection", "query"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Snapshot.class, "target;packs;selection;query", "target", "packs", "selection", "query"}, this, o);
        }

        public PackListModel target() {
            return this.target;
        }

        public List<Pack> packs() {
            return this.packs;
        }

        public List<Pack> selection() {
            return this.selection;
        }

        public Query query() {
            return this.query;
        }
    }
}

