/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.components.profile;

import io.github.fishstiz.fidgetz.gui.components.FidgetzButton;
import io.github.fishstiz.fidgetz.gui.components.FidgetzText;
import io.github.fishstiz.fidgetz.gui.components.LayoutWrapper;
import io.github.fishstiz.fidgetz.gui.components.ToggleableDialog;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuContainer;
import io.github.fishstiz.fidgetz.gui.layouts.FlexLayout;
import io.github.fishstiz.fidgetz.gui.renderables.RenderableRect;
import io.github.fishstiz.fidgetz.util.DrawUtil;
import io.github.fishstiz.packed_packs.util.constants.GuiConstants;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.layouts.Layout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class Sidebar
extends ToggleableDialog<LayoutWrapper<FlexLayout>>
implements ContextMenuContainer {
    private static final int MIN_WIDTH = 100;

    public <S extends Screen> Sidebar(S screen) {
        super(Sidebar.createBuilder(screen));
        ((LayoutWrapper)this.root()).setPadding(8);
        ((LayoutWrapper)this.root()).setMinWidth(100);
    }

    private static <S extends Screen> ToggleableDialog.Builder<LayoutWrapper<FlexLayout>, ?> createBuilder(S screen) {
        FlexLayout layout = FlexLayout.vertical(() -> Sidebar.getMaxHeight(screen)).spacing(8);
        return Sidebar.builder(screen, (LayoutElement)new LayoutWrapper((Layout)layout)).setBackground((RenderableRect)DrawUtil.DEMO_BACKGROUND);
    }

    public void init(Component title, Runnable onClose, int maxWidth) {
        FidgetzButton closeButton = ((FidgetzButton.Builder)FidgetzButton.builder().makeSquare()).setMessage(CommonComponents.GUI_DONE).setSprite(GuiConstants.CROSS_SPRITE).setOnPress(() -> this.setOpen(false)).addListener(onClose).build();
        FidgetzText titleWidget = FidgetzText.builder().setMessage(title).setOffsetY(1).alignLeft().build();
        FlexLayout header = FlexLayout.horizontal(() -> maxWidth).spacing(8);
        header.addChild((LayoutElement)closeButton);
        header.addFlexChild((AbstractWidget)titleWidget);
        ((FlexLayout)((LayoutWrapper)this.root()).layout()).addChild((LayoutElement)header);
    }

    public void repositionElements() {
        ((LayoutWrapper)this.root()).setMinHeight(Sidebar.getMaxHeight(this.screen));
        ((LayoutWrapper)this.root()).arrangeElements();
        ((LayoutWrapper)this.root()).setPosition(0, 0);
    }

    private static int getMaxHeight(Screen screen) {
        return screen.height - 16;
    }
}

