/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.layouts.pack;

import io.github.fishstiz.fidgetz.gui.components.FidgetzButton;
import io.github.fishstiz.fidgetz.gui.components.ToggleableEditBox;
import io.github.fishstiz.fidgetz.gui.layouts.FlexLayout;
import io.github.fishstiz.packed_packs.gui.components.pack.PackList;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public abstract class PackLayout {
    protected final PackList list;
    private final ToggleableEditBox<Void> searchField;
    private final FidgetzButton<Void> transferButton;
    private FlexLayout headerLayout;
    private FlexLayout layout;

    protected PackLayout(PackList list) {
        this.list = list;
        this.searchField = ToggleableEditBox.builder().setHint((Component)ResourceUtil.getText("search", new Object[0]).append(CommonComponents.ELLIPSIS)).setEditable(true).addListener(this.list::search).build();
        this.transferButton = ((FidgetzButton.Builder)FidgetzButton.builder().makeSquare()).setOnPress(this.list::transferAll).setTooltip(Tooltip.create((Component)ResourceUtil.getText("transfer_all.info", new Object[0]))).build();
    }

    protected abstract void initHeader(@NotNull FlexLayout var1);

    public final void init(@NotNull FlexLayout layout) {
        this.headerLayout = FlexLayout.horizontal(() -> ((PackList)this.list).getWidth()).spacing(8);
        this.initHeader(this.headerLayout);
        this.layout = layout;
        this.layout.addChild((LayoutElement)this.headerLayout);
        this.layout.addFlexChild((AbstractWidget)this.list, true);
    }

    public PackList list() {
        return this.list;
    }

    public ToggleableEditBox<Void> getSearchField() {
        return this.searchField;
    }

    public FidgetzButton<Void> getTransferButton() {
        return this.transferButton;
    }

    public void setHeaderVisibility(boolean visible) {
        if (this.layout == null) {
            return;
        }
        this.headerLayout.visitWidgets(widget -> {
            widget.visible = visible;
        });
        ScreenRectangle headerRect = this.headerLayout.getRectangle();
        int y = visible ? headerRect.bottom() + 8 : headerRect.top();
        int height = visible ? this.layout.getHeight() - headerRect.height() - 8 : this.layout.getHeight();
        this.list.setY(y);
        this.list.setHeight(height);
        this.list.clampScrollAmount();
    }
}

