/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.pack;

import com.google.common.hash.Hashing;
import com.mojang.blaze3d.platform.NativeImage;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.packed_packs.PackedPacks;
import io.github.fishstiz.packed_packs.pack.folder.FolderPack;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.Nullable;

public class PackAssetManager {
    public static final Sprite DEFAULT_FOLDER_ICON = Sprite.of16((ResourceLocation)ResourceUtil.getResource("textures/misc/unknown_folder.png"));
    public static final Sprite DEFAULT_ICON = Sprite.of16((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"textures/misc/unknown_pack.png"));
    private final Map<String, Sprite> cachedIcons = new Object2ObjectOpenHashMap();
    private final Minecraft minecraft;
    private Map<String, Sprite> staleIcons;

    public PackAssetManager(Minecraft minecraft) {
        this.minecraft = minecraft;
    }

    public Sprite getIcon(Pack pack) {
        return this.cachedIcons.getOrDefault(pack.getId(), this.staleIcons != null ? this.staleIcons.getOrDefault(pack.getId(), PackAssetManager.getDefaultIcon(pack)) : PackAssetManager.getDefaultIcon(pack));
    }

    public void getOrLoadIcon(Pack pack, Consumer<Sprite> iconCallback) {
        Sprite cachedIcon;
        Sprite staleIcon;
        if (this.staleIcons != null && (staleIcon = this.staleIcons.get(pack.getId())) != null) {
            iconCallback.accept(staleIcon);
        }
        if ((cachedIcon = this.cachedIcons.get(pack.getId())) != null) {
            iconCallback.accept(cachedIcon);
        } else {
            this.loadPackIcon(pack).thenAcceptAsync(location -> {
                Sprite sprite = location != null ? Sprite.of16((ResourceLocation)location) : PackAssetManager.getDefaultIcon(pack);
                this.cachedIcons.put(pack.getId(), sprite);
                iconCallback.accept(sprite);
            }, (Executor)this.minecraft);
        }
    }

    public void clearIconCache() {
        this.staleIcons = new Object2ObjectOpenHashMap(this.cachedIcons);
        this.cachedIcons.clear();
    }

    public static Sprite getDefaultIcon(Pack pack) {
        return pack instanceof FolderPack ? DEFAULT_FOLDER_ICON : DEFAULT_ICON;
    }

    public static ResourceLocation getDefaultLocation(Pack pack) {
        return PackAssetManager.getDefaultIcon((Pack)pack).location;
    }

    private CompletableFuture<@Nullable ResourceLocation> loadPackIcon(Pack pack) {
        return CompletableFuture.supplyAsync(() -> {
            try (PackResources packResources = pack.open();){
                ResourceLocation resourceLocation;
                block17: {
                    IoSupplier iconIoSupplier = packResources.getRootResource(new String[]{"pack.png"});
                    if (iconIoSupplier == null) {
                        ResourceLocation resourceLocation2 = null;
                        return resourceLocation2;
                    }
                    ResourceLocation icon = ResourceLocation.withDefaultNamespace((String)PackAssetManager.hashIconName(pack.getId()));
                    InputStream iconStream = (InputStream)iconIoSupplier.get();
                    try {
                        NativeImage nativeImage = NativeImage.read((InputStream)iconStream);
                        TextureManager manager = this.minecraft.getTextureManager();
                        this.minecraft.execute(() -> manager.register(icon, (AbstractTexture)new DynamicTexture(() -> ((ResourceLocation)icon).toString(), nativeImage)));
                        resourceLocation = icon;
                        if (iconStream == null) break block17;
                    }
                    catch (Throwable throwable) {
                        if (iconStream != null) {
                            try {
                                iconStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    iconStream.close();
                }
                return resourceLocation;
            }
            catch (Exception e) {
                if (!(e instanceof NoSuchFileException)) {
                    PackedPacks.LOGGER.warn("Failed to load icon from pack '{}'", (Object)pack.getId(), (Object)e);
                }
                return null;
            }
        }, (Executor)Util.backgroundExecutor());
    }

    private static String hashIconName(String id) {
        return "pack/" + Util.sanitizeName((String)id, ResourceLocation::validPathChar) + "/" + String.valueOf(Hashing.sha1().hashUnencodedChars((CharSequence)id)) + "/icon";
    }
}

