/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.util;

import io.github.fishstiz.fidgetz.util.lang.CollectionsUtil;
import io.github.fishstiz.packed_packs.PackedPacks;
import io.github.fishstiz.packed_packs.pack.folder.FolderPack;
import io.github.fishstiz.packed_packs.platform.Services;
import io.github.fishstiz.packed_packs.transform.interfaces.FilePack;
import io.github.fishstiz.packed_packs.transform.mixin.UtilAccess;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackDetector;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.level.validation.ForbiddenSymlinkInfo;
import org.apache.commons.io.FileUtils;

public class PackUtil {
    public static final String HIGH_CONTRAST_ID = "high_contrast";
    public static final String VANILLA_ID = "vanilla";
    public static final String FABRIC_ID = "fabric";
    public static final String ZIP_PACK_EXTENSION = ".zip";
    public static final String ICON_FILENAME = "pack.png";
    public static final PackSource PACK_SOURCE = PackSource.create(name -> Component.translatable((String)"pack.nameAndSource", (Object[])new Object[]{name, ResourceUtil.getModName().withStyle(ChatFormatting.YELLOW)}).withStyle(ChatFormatting.GRAY), (boolean)false);
    private static final String FILE_PREFIX = "file/";
    private static final String DELIMITER = "/";

    private PackUtil() {
    }

    public static String fileName(Path path) {
        return path.getFileName().toString();
    }

    public static String generatePackName(Path path) {
        return PackUtil.fileName(path);
    }

    public static String generatePackId(String name) {
        return FILE_PREFIX + name;
    }

    public static String generatePackId(Path path) {
        return PackUtil.generatePackId(PackUtil.generatePackName(path));
    }

    public static String generateNestedPackId(Path path) {
        return FILE_PREFIX + PackUtil.generatePackName(path.getParent()) + DELIMITER + PackUtil.generatePackName(path);
    }

    public static PackLocationInfo replicateLocationInfo(PackLocationInfo info, String id) {
        return new PackLocationInfo(id, info.title(), info.source(), info.knownPackInfo());
    }

    public static long getLastUpdatedEpochMs(Pack pack) {
        Path path = ((FilePack)pack).packed_packs$getPath();
        if (path == null) {
            return -1L;
        }
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]).toInstant().toEpochMilli();
        }
        catch (IOException e) {
            PackedPacks.LOGGER.error("Failed to get age of pack '{}'", (Object)pack.getId());
            return -1L;
        }
    }

    public static List<String> extractPackIds(Collection<Pack> packs) {
        return CollectionsUtil.extractNonNull(packs, Pack::getId);
    }

    public static String joinPackNames(Collection<Path> paths) {
        return String.join((CharSequence)", ", CollectionsUtil.extractNonNull(paths, PackUtil::generatePackName));
    }

    public static boolean hasMcmeta(Path path) {
        return Files.isRegularFile(path.resolve("pack.mcmeta"), LinkOption.NOFOLLOW_LINKS);
    }

    public static boolean hasFolderConfig(Path path) {
        return Files.isRegularFile(path.resolve("packed_packs.folderpack.json"), LinkOption.NOFOLLOW_LINKS);
    }

    public static boolean isBuiltIn(Pack pack) {
        PackSource packSource = pack.getPackSource();
        return packSource == PackSource.BUILT_IN || Services.PLATFORM.isBuiltInPack(pack);
    }

    public static boolean isEssential(Pack pack) {
        return pack.getId().equals(VANILLA_ID) || pack.getId().equals(FABRIC_ID);
    }

    public static boolean isFeature(Pack pack) {
        return pack.getPackSource() == PackSource.FEATURE;
    }

    public static boolean isNonPackDirectory(Path path) {
        return Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS) && !PackUtil.hasMcmeta(path);
    }

    public static boolean isZipPack(Pack pack) {
        Path path = PackUtil.validatePackPath(pack);
        return path != null && Files.isRegularFile(path, new LinkOption[0]) && PackUtil.fileName(path).endsWith(ZIP_PACK_EXTENSION);
    }

    public static List<Pack> flattenPacks(Collection<Pack> packs) {
        ObjectArrayList flattened = new ObjectArrayList();
        for (Pack pack : packs) {
            if (pack instanceof FolderPack) {
                FolderPack folderPack = (FolderPack)pack;
                flattened.addAll(folderPack.flatten());
                continue;
            }
            flattened.add(pack);
        }
        return flattened;
    }

    public static Path validatePackPath(Pack pack) {
        if (pack == null) {
            return null;
        }
        Path path = ((FilePack)pack).packed_packs$getPath();
        if (path == null) {
            return null;
        }
        try {
            return Files.exists(path, new LinkOption[0]) ? path : null;
        }
        catch (Exception e) {
            PackedPacks.LOGGER.error("[packed_packs] Could not read file: '{}'", (Object)path);
            return null;
        }
    }

    public static List<Path> mapValidDirectories(Collection<String> paths) {
        if (paths == null || paths.isEmpty()) {
            return Collections.emptyList();
        }
        ObjectArrayList validPaths = new ObjectArrayList(paths.size());
        for (String path : paths) {
            if (path == null || path.isBlank()) continue;
            try {
                Path resolved = Paths.get(path, new String[0]);
                if (Files.isDirectory(resolved, LinkOption.NOFOLLOW_LINKS)) {
                    validPaths.add(resolved.toAbsolutePath().normalize());
                    continue;
                }
                PackedPacks.LOGGER.error("[packed_packs] Path is not a valid directory: '{}', ignoring.", (Object)path);
            }
            catch (Exception e) {
                PackedPacks.LOGGER.error("[packed_packs] Failed to resolve path: '{}', ignoring.", (Object)path, (Object)e);
            }
        }
        return validPaths;
    }

    public static void openPack(Pack pack) {
        Path path = ((FilePack)pack).packed_packs$getPath();
        if (path != null) {
            Util.getPlatform().openPath(path);
        }
    }

    public static void openParent(Pack pack) {
        Path path = ((FilePack)pack).packed_packs$getPath();
        if (path != null) {
            PackUtil.openParent(path);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void openParent(Path path) {
        File file = path.toFile();
        if (!file.exists()) {
            return;
        }
        try {
            switch (Util.getPlatform()) {
                case WINDOWS: {
                    new ProcessBuilder("explorer.exe", "/select,", file.getAbsolutePath()).start();
                    return;
                }
                case OSX: {
                    new ProcessBuilder("open", "-R", file.getAbsolutePath()).start();
                    return;
                }
                case LINUX: {
                    File parentFile = file.getParentFile();
                    if (parentFile == null) return;
                    new ProcessBuilder("xdg-open", parentFile.getAbsolutePath()).start();
                    return;
                }
                default: {
                    Path parent = path.getParent();
                    if (parent == null) return;
                    Util.getPlatform().openPath(parent);
                }
            }
            return;
        }
        catch (IOException e) {
            Path parent = path.getParent();
            if (parent == null) return;
            Util.getPlatform().openPath(parent);
        }
    }

    public static boolean deletePath(Path path) {
        com.sun.jna.platform.FileUtils fileUtils = com.sun.jna.platform.FileUtils.getInstance();
        if (fileUtils.hasTrash()) {
            try {
                fileUtils.moveToTrash(new File[]{path.toFile()});
                return true;
            }
            catch (IOException e) {
                PackedPacks.LOGGER.warn("[packed_packs] Failed to move to trash: '{}'", (Object)path, (Object)e);
            }
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            try {
                FileUtils.deleteDirectory((File)path.toFile());
                return true;
            }
            catch (IOException e) {
                PackedPacks.LOGGER.error("[packed_packs] Failed to delete path: '{}'", (Object)path, (Object)e);
                return false;
            }
        }
        return UtilAccess.packed_packs$createDeleter(path).getAsBoolean();
    }

    public static boolean renamePath(Path path, Path newName) {
        return UtilAccess.packed_packs$createRenamer(path, newName).getAsBoolean();
    }

    public static PathValidationResults validatePaths(List<Path> packs) {
        PackDetector<Path> packDetector = new PackDetector<Path>(Minecraft.getInstance().directoryValidator()){

            protected Path createZipPack(Path path) {
                return path;
            }

            protected Path createDirectoryPack(Path path) {
                return path;
            }
        };
        PathValidationResults results = new PathValidationResults(packs);
        block7: for (Path path : packs) {
            try {
                if (!PackUtil.isNonPackDirectory(path)) {
                    if (!PackUtil.validatePath(path, packDetector, results.symlinkWarnings)) continue;
                    results.addValid(path);
                    continue;
                }
                DirectoryStream<Path> paths = Files.newDirectoryStream(path);
                try {
                    for (Path child : paths) {
                        if (!PackUtil.validatePath(child, packDetector, results.symlinkWarnings)) continue;
                        results.addValid(path);
                        continue block7;
                    }
                }
                finally {
                    if (paths == null) continue;
                    paths.close();
                }
            }
            catch (IOException e) {
                PackedPacks.LOGGER.warn("Failed to check {} for packs", (Object)path, (Object)e);
            }
        }
        return results;
    }

    private static boolean validatePath(Path path, PackDetector<Path> packDetector, List<ForbiddenSymlinkInfo> symlinkWarnings) throws IOException {
        Path detectedPack = (Path)packDetector.detectPackResources(path, symlinkWarnings);
        if (detectedPack == null) {
            PackedPacks.LOGGER.warn("Path {} does not seem like pack", (Object)path);
            return false;
        }
        return true;
    }

    public record PathValidationResults(List<Path> valid, Set<Path> rejected, List<ForbiddenSymlinkInfo> symlinkWarnings) {
        private PathValidationResults(Collection<Path> packs) {
            this(new ArrayList<Path>(packs.size()), (Set<Path>)new ObjectOpenHashSet(packs), new ArrayList<ForbiddenSymlinkInfo>());
        }

        private void addValid(Path path) {
            this.valid.add(path);
            this.rejected.remove(path);
        }
    }
}

