package io.github.fishstiz.packed_packs.compat.respackopts;

import io.github.fishstiz.fidgetz.gui.components.Fidgetz;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuItemBuilder;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuProvider;
import io.github.fishstiz.packed_packs.compat.Mod;
import io.github.fishstiz.packed_packs.compat.PackWrapperDelegatorAbstractionEpicModelEntry;
import io.github.fishstiz.packed_packs.config.Config;
import io.github.fishstiz.packed_packs.config.ModPreferences;
import io.github.fishstiz.packed_packs.gui.components.ToggleableHelper;
import io.gitlab.jfronny.libjf.entrywidgets.api.v0.ResourcePackEntryWidget;
import net.minecraft.class_2561;
import net.minecraft.class_3288;
import net.minecraft.class_332;
import net.minecraft.class_4264;
import net.minecraft.class_4587;
import net.minecraft.class_5369;
import net.minecraft.class_6382;
import net.minecraft.class_8021;
import org.jetbrains.annotations.Nullable;

public class RespackoptsWidget extends class_4264 implements ContextMenuProvider, Fidgetz {
    private final ResourcePackEntryWidget wrapped;
    private final class_5369.class_5371 model;
    private final class_8021 container;
    private final @Nullable ToggleableHelper toggleable;

    private RespackoptsWidget(class_8021 container, ResourcePackEntryWidget wrapped, class_5369.class_5371 model) {
        super(0, 0, 0, 0, class_2561.method_43470(Mod.RESPACKOPTS.getId()));

        this.toggleable = Config.get().isDevMode() ? new ToggleableHelper(ModPreferences.RESPACKOPTS_BUTTON.get()) : null;
        this.container = container;
        this.wrapped = wrapped;
        this.model = model;
    }

    public static @Nullable RespackoptsWidget create(class_8021 container, class_3288 pack) {
        for (ResourcePackEntryWidget widget : ResourcePackEntryWidget.WIDGETS) {
            class_5369.class_5371 model = new PackWrapperDelegatorAbstractionEpicModelEntry(pack);
            if (widget.isVisible(model, isSelectable(pack))) {
                return new RespackoptsWidget(container, widget, model);
            }
        }
        return null;
    }

    @Override
    public void method_25306() {
        this.wrapped.onClick(this.model);
    }

    @Override
    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        int width = this.wrapped.getWidth(this.model);
        int height = this.wrapped.getHeight(this.model, this.container.method_25364());
        int marginRight = this.wrapped.getXMargin(this.model);

        this.method_25358(width);
        this.method_53533(height);
        this.method_46421((this.container.method_46426() + this.container.method_25368()) - width - marginRight);
        this.method_46419(this.container.method_46427() + (this.container.method_25364() - height) / 2);

        this.field_22762 = this.field_22762 && Fidgetz.super.method_25405(mouseX, mouseY);

        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416(0, 0, 1f);
        this.wrapped.render(this.model, guiGraphics, this.method_46426(), this.method_46427(), this.field_22762, partialTick);

        if (this.toggleable != null) {
            this.toggleable.render(guiGraphics, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), partialTick);
        }
        poseStack.method_22909();
    }

    @Override
    protected void method_47399(class_6382 narrationElementOutput) {
        // unsupported
    }

    @Override
    public boolean method_25405(double mouseX, double mouseY) {
        return super.method_25405(mouseX, mouseY) && Fidgetz.super.method_25405(mouseX, mouseY);
    }

    /**
     * Copied from {@code TransferableSelectionList.Entry#showHoverOverlay()}
     */
    private static boolean isSelectable(class_3288 pack) {
        return !pack.method_14465() || !pack.method_14464();
    }

    @Override
    public void buildItems(ContextMenuItemBuilder builder, int mouseX, int mouseY) {
        if (this.toggleable != null) {
            this.toggleable.buildContext(builder.separatorIfNonEmpty());
        }
    }
}
