package io.github.fishstiz.fidgetz.gui.layouts;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_5244;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_7528;
import net.minecraft.class_8021;
import net.minecraft.class_8028;
import net.minecraft.class_8030;
import net.minecraft.class_8133;
import net.minecraft.class_9017;

/**
 * A copy of ScrollableLayout from 1.21.6, but without the padding.
 */
public class ScrollableLayout implements class_8133 {
    private final class_8133 content;
    private final Container container;
    private int minWidth;
    private int maxHeight;

    public ScrollableLayout(class_310 minecraft, class_8133 content, int height) {
        this.content = content;
        this.container = new Container(minecraft, 0, height);
    }

    public void setMinWidth(int minWidth) {
        this.minWidth = minWidth;
        this.container.method_25358(Math.max(this.content.method_25368(), minWidth));
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
        this.container.method_53533(Math.min(this.content.method_25364(), maxHeight));
        this.container.method_65506();
    }

    @Override
    public void method_48222() {
        this.content.method_48222();

        boolean scrollbarVisible = this.content.method_25364() > this.maxHeight;
        // removed padding (content width + 20)
        this.container.method_25358(Math.max(this.content.method_25368() + (scrollbarVisible ? class_7528.field_55258 : 0), this.minWidth));
        this.container.method_53533(Math.min(this.content.method_25364(), this.maxHeight));
        this.container.method_65506();
    }

    @Override
    public void method_48227(Consumer<class_8021> visitor) {
        visitor.accept(this.container);
    }

    @Override
    public void method_46421(int x) {
        this.container.method_46421(x);
    }

    @Override
    public void method_46419(int y) {
        this.container.method_46419(y);
    }

    @Override
    public int method_46426() {
        return this.container.method_46426();
    }

    @Override
    public int method_46427() {
        return this.container.method_46427();
    }

    @Override
    public int method_25368() {
        return this.container.method_25368();
    }

    @Override
    public int method_25364() {
        return this.container.method_25364();
    }

    class Container extends class_9017 {
        private static final double SCROLL_PADDING = 14.0;
        private static final int SCROLL_RATE = 10;
        private final class_310 minecraft;
        private final List<class_339> children = new ArrayList<>();

        public Container(final class_310 minecraft, final int width, final int height) {
            super(0, 0, width, height, class_5244.field_39003);
            this.minecraft = minecraft;
            ScrollableLayout.this.content.method_48206(this.children::add);
        }

        @Override
        protected int method_44395() {
            return ScrollableLayout.this.content.method_25364();
        }

        @Override
        protected double method_44393() {
            return SCROLL_RATE;
        }

        @Override
        protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            guiGraphics.method_44379(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759);

            for (class_339 abstractWidget : this.children) {
                abstractWidget.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            }

            guiGraphics.method_44380();
            this.method_44396(guiGraphics);
        }

        @Override
        protected void method_47399(class_6382 narrationElementOutput) {
        }

        @Override
        public @NotNull class_8030 method_65515(class_8028 direction) {
            return new class_8030(this.method_46426(), this.method_46427(), this.field_22758, this.method_44395());
        }

        @Override
        public void method_25395(@Nullable class_364 focused) {
            super.method_25395(focused);
            if (focused != null && this.minecraft.method_48186().method_48183()) {
                class_8030 containerRectangle = this.method_48202();
                class_8030 focusedRectangle = focused.method_48202();
                int relativeTop = focusedRectangle.method_49618() - containerRectangle.method_49618();
                int relativeBottom = focusedRectangle.method_49619() - containerRectangle.method_49619();
                if (relativeTop < 0) {
                    this.method_44382(this.method_44387() + relativeTop - SCROLL_PADDING);
                } else if (relativeBottom > 0) {
                    this.method_44382(this.method_44387() + relativeBottom + SCROLL_PADDING);
                }
            }
        }

        @Override
        public void method_46421(int x) {
            super.method_46421(x);
            ScrollableLayout.this.content.method_46421(x); // removed padding (x + 10)
        }

        @Override
        public void method_46419(int y) {
            super.method_46419(y);
            ScrollableLayout.this.content.method_46419(y - (int) this.method_44387());
        }

        @Override
        public void method_44382(double scrollAmount) {
            super.method_44382(scrollAmount);
            ScrollableLayout.this.content.method_46419(this.method_48202().method_49618() - (int) this.method_44387());
        }

        @Override
        public @NotNull List<? extends class_364> method_25396() {
            return this.children;
        }

        @Override
        public @NotNull Collection<? extends class_6379> method_65516() {
            return this.children;
        }
    }
}