/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.history;

import io.github.fishstiz.packed_packs.gui.history.Restorable;
import java.util.ArrayDeque;
import java.util.Deque;

public class HistoryManager<T extends Restorable.Snapshot<T>> {
    private static final int MAX = 50;
    private final Deque<Restorable.Snapshot<T>> history = new ArrayDeque<Restorable.Snapshot<T>>();
    private final Deque<Restorable.Snapshot<T>> undone = new ArrayDeque<Restorable.Snapshot<T>>();

    public void push(Restorable.Snapshot<T> snapshot) {
        if (snapshot == null) {
            return;
        }
        if (this.history.size() >= 50) {
            this.history.removeFirst();
        }
        this.undone.clear();
        this.history.addLast(snapshot);
    }

    public boolean undo() {
        if (this.history.size() > 1) {
            this.undone.addLast(this.history.removeLast());
            this.history.getLast().restore();
            return true;
        }
        return false;
    }

    public boolean redo() {
        if (!this.undone.isEmpty()) {
            Restorable.Snapshot<T> snapshot = this.undone.removeLast();
            snapshot.restore();
            this.history.addLast(snapshot);
            return true;
        }
        return false;
    }

    public void reset(Restorable.Snapshot<T> initialState) {
        this.history.clear();
        this.undone.clear();
        this.push(initialState);
    }
}

