package io.github.fishstiz.packed_packs.transform.mixin.folders.additional;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import io.github.fishstiz.packed_packs.config.Config;
import io.github.fishstiz.packed_packs.util.PackUtil;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3279;
import net.minecraft.class_3283;
import net.minecraft.class_3285;
import net.minecraft.class_5352;
import net.minecraft.class_8580;
import org.apache.commons.lang3.ArrayUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_310.class)
public abstract class MinecraftMixin {
    @Shadow
    @Final
    private class_8580 directoryValidator;

    @WrapOperation(method = "<init>", at = @At(
            value = "NEW",
            target = "([Lnet/minecraft/server/packs/repository/RepositorySource;)Lnet/minecraft/server/packs/repository/PackRepository;")
    )
    private class_3283 addAdditionalFolders(class_3285[] sources, Operation<class_3283> original) {
        class_3285[] folders = PackUtil.mapValidDirectories(Config.get().getResourcepacks().getAdditionalFolders())
                .stream()
                .map(path -> path.toAbsolutePath().normalize())
                .distinct()
                .map(path -> new class_3279(path, class_3264.field_14188, class_5352.field_25347, this.directoryValidator))
                .toArray(class_3285[]::new);

        return original.call((Object) ArrayUtils.addAll(sources, folders));
    }
}
