package io.github.fishstiz.fidgetz.transform.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import io.github.fishstiz.fidgetz.gui.components.ToggleableDialogContainer;
import net.minecraft.class_11908;
import net.minecraft.class_437;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_437.class)
public abstract class ScreenMixin {
    @WrapOperation(method = "keyPressed", at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/client/gui/screens/Screen;shouldCloseOnEsc()Z"
    ))
    public boolean shouldCloseDialogs(class_437 instance, Operation<Boolean> original, class_11908 keyEvent) {
        if (this instanceof ToggleableDialogContainer dialogContainer && keyEvent.method_74231()) {
            for (var dialog : dialogContainer.getOpenDialogs()) {
                if (dialog.shouldCloseOnEscape()) {
                    dialog.setOpen(false);
                    return false;
                }
            }
        }
        return original.call(instance);
    }
}
