package io.github.fishstiz.packed_packs.gui.components.profile;

import io.github.fishstiz.fidgetz.gui.components.AbstractFixedListWidget;
import io.github.fishstiz.fidgetz.gui.components.FidgetzButton;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuContainer;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuItemBuilder;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuProvider;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.ButtonSprites;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.fidgetz.util.ARGBColor;
import io.github.fishstiz.fidgetz.util.DrawUtil;
import io.github.fishstiz.fidgetz.util.GuiUtil;
import io.github.fishstiz.fidgetz.util.debounce.PollingDebouncer;
import io.github.fishstiz.fidgetz.util.debounce.SimplePollingDebouncer;
import io.github.fishstiz.packed_packs.PackedPacks;
import io.github.fishstiz.packed_packs.config.Config;
import io.github.fishstiz.packed_packs.config.Profile;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import io.github.fishstiz.packed_packs.util.constants.GuiConstants;
import io.github.fishstiz.packed_packs.util.constants.Theme;
import io.github.fishstiz.packed_packs.util.lang.ObjectsUtil;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_6379;
import net.minecraft.class_7919;

import static io.github.fishstiz.packed_packs.util.constants.GuiConstants.*;

public class ProfileList extends AbstractFixedListWidget<ProfileList.Entry> implements ContextMenuContainer {
    private static final int ITEM_HEIGHT = 20;
    private static final class_2561 EMPTY_TEXT = ResourceUtil.getText("profile.empty");
    private static final class_2561 DELETE_TEXT = ResourceUtil.getText("profile.delete");
    private static final class_7919 DELETE_INFO = class_7919.method_47407(ResourceUtil.getText("profile.delete.info"));
    private static final Sprite TRASH_SPRITE = Sprite.of16(ResourceUtil.getIcon("trash"));
    private static final Sprite STAR_OUTLINE_SPRITE = Sprite.of16(ResourceUtil.getIcon("star_outline"));
    private final PollingDebouncer<Void> debouncedRefresh = new SimplePollingDebouncer<>(this::refresh, 200);
    private final Config.Packs config;
    private final Supplier<Profile> current;
    private final Consumer<Profile> onDelete;
    private final Consumer<Profile> onSelect;
    private List<Profile> profiles;

    public ProfileList(Config.Packs config, Supplier<Profile> current, Consumer<Profile> onDelete, Consumer<Profile> onSelect) {
        super(ITEM_HEIGHT);

        this.config = config;
        this.current = current;
        this.onDelete = onDelete;
        this.onSelect = onSelect;

        this.refresh();
    }

    public void scheduleRefresh() {
        this.debouncedRefresh.run();
    }

    public void refresh() {
        this.method_25339();

        this.profiles = this.config.getProfiles();
        for (int i = 0; i < this.profiles.size(); i++) {
            this.method_25321(new io.github.fishstiz.packed_packs.gui.components.profile.ProfileList.Entry(this.profiles.get(i), i));
        }
    }

    @Override
    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.debouncedRefresh.poll();

        super.method_48579(guiGraphics, mouseX, mouseY, partialTick);

        if (this.profiles == null || this.profiles.isEmpty()) {
            int padding = 8;

            method_52718(
                    guiGraphics,
                    this.field_22740.field_1772,
                    EMPTY_TEXT,
                    this.method_46426() + padding,
                    this.method_46427() + padding,
                    this.method_55442() - padding,
                    this.method_55443() - padding,
                    Theme.WHITE.getARGB()
            );
        }
    }

    public class Entry extends AbstractFixedListWidget<io.github.fishstiz.packed_packs.gui.components.profile.ProfileList.Entry>.Entry implements ContextMenuProvider {
        private final Profile profile;
        private final List<FidgetzButton<Void>> children = new ArrayList<>();
        private final FidgetzButton<Void> selectButton;
        private final FidgetzButton<Void> deleteButton;

        protected Entry(Profile profile, int index) {
            super(index);

            this.profile = profile;
            this.deleteButton = FidgetzButton.<Void>builder()
                    .makeSquare(this.method_25364())
                    .setMessage(DELETE_TEXT)
                    .setSprite(this.isDefault()
                            ? ButtonSprites.of(STAR_SPRITE) : profile.isLocked()
                            ? ButtonSprites.unclamp(LOCK_SPRITE) : ButtonSprites.of(TRASH_SPRITE))
                    .setOnPress(() -> ProfileList.this.onDelete.accept(this.profile))
                    .build();
            this.deleteButton.field_22763 = !profile.isLocked() && !this.isDefault();
            if (this.deleteButton.field_22763) this.deleteButton.method_47400(DELETE_INFO);

            this.selectButton = FidgetzButton.<Void>builder()
                    .setMessage(class_2561.method_43470(this.profile.getName()))
                    .setOnPress(() -> ProfileList.this.onSelect.accept(this.profile))
                    .build();

            this.children.add(this.deleteButton);
            this.children.add(this.selectButton);
        }

        @Override
        public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovering, float partialTick) {
            this.selectButton.field_22763 = ProfileList.this.current.get() != this.profile;

            int left = this.method_46426();
            int top = this.method_46427();

            this.deleteButton.method_48229(left, top);
            this.selectButton.method_48229(left + this.deleteButton.method_25368(), top);
            this.selectButton.method_25358(field_22758 - this.deleteButton.method_25368());

            this.deleteButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            this.selectButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);

            if (PackedPacks.CONFIG.isDevMode()) {
                boolean hasProperty = true;
                int width = this.method_25368();
                int height = this.method_25364();
                int borderColor;

                if (this.isDefault() && this.profile.isLocked()) {
                    borderColor = Theme.PURPLE_500.getARGB();
                } else if (this.isDefault()) {
                    borderColor = Theme.BLUE_500.getARGB();
                } else if (this.profile.isLocked()) {
                    borderColor = Theme.RED_700.getARGB();
                } else {
                    borderColor = Theme.WHITE.getARGB();
                    hasProperty = false;
                }

                boolean hovered = guiGraphics.method_58135(mouseX, mouseY) && GuiUtil.isHovered(this, mouseX, mouseY);
                if (hasProperty || hovered) {
                    DrawUtil.renderOutline(guiGraphics, left, top, width, height, borderColor);
                }
                if (hovered) {
                    int foregroundColor = ARGBColor.withAlpha(borderColor, 0.25f);
                    guiGraphics.method_25294(left, top, left + width, top + height, foregroundColor);
                }
            }
        }

        private boolean isDefault() {
            return ProfileList.this.config.getDefaultProfile() == this.profile ||
                   ObjectsUtil.testNullable(ProfileList.this.config.getDefaultProfile(), p -> p.getId() == this.profile.getId());
        }

        private boolean isSelected() {
            return ProfileList.this.current.get() == this.profile ||
                   ObjectsUtil.testNullable(ProfileList.this.current.get(), p -> p.getId() == this.profile.getId());
        }

        @Override
        public @NotNull List<? extends class_364> method_25396() {
            return this.children;
        }

        @Override
        public @NotNull List<? extends class_6379> method_37025() {
            return this.children;
        }

        @Override
        public void method_48206(Consumer<class_339> consumer) {
            this.children.forEach(consumer);
        }

        private void reselect() {
            if (this.isSelected()) {
                ProfileList.this.onSelect.accept(this.profile);
            }
        }

        @Override
        public void buildItems(ContextMenuItemBuilder builder, int mouseX, int mouseY) {
            if (!PackedPacks.CONFIG.isDevMode()) return;

            builder.separatorIfNonEmpty();
            builder.add(GuiConstants.devItem(ResourceUtil.getText("profile.default." + (this.isDefault() ? "unset" : "set")))
                    .icon(() -> this.isDefault() ? STAR_SPRITE : STAR_OUTLINE_SPRITE)
                    .action(() -> {
                        ProfileList.this.config.setDefaultProfile(this.isDefault() ? null : this.profile);
                        ProfileList.this.refresh();
                        this.reselect();
                    })
                    .build());
            builder.add(GuiConstants.devItem(ResourceUtil.getText("profile." + (this.profile.isLocked() ? "unlock" : "lock")))
                    .icon(this.profile.isLocked() ? LOCK_SPRITE_SMALL : UNLOCK_SPRITE_SMALL)
                    .action(() -> {
                        this.profile.setLocked(!this.profile.isLocked());
                        ProfileList.this.refresh();
                        this.reselect();
                    })
                    .build());
        }
    }
}
