package io.github.fishstiz.fidgetz.gui.shapes;

import io.github.fishstiz.fidgetz.util.GuiUtil;
import net.minecraft.class_8021;
import net.minecraft.class_8030;

public interface GuiRectangle {
    static GuiRectangle viewOf(class_8021 element) {
        return new GuiRectangle() {
            @Override
            public int getX() {
                return element.method_46426();
            }

            @Override
            public int getY() {
                return element.method_46427();
            }

            @Override
            public int getWidth() {
                return element.method_25368();
            }

            @Override
            public int getHeight() {
                return element.method_25364();
            }
        };
    }

    int getX();

    int getY();

    int getWidth();

    int getHeight();

    default int getRight() {
        return this.getX() + this.getWidth();
    }

    default int getBottom() {
        return this.getY() + this.getHeight();
    }

    default int getFractionX(float fraction) {
        return this.getX() + Math.round(this.getWidth() * Math.clamp(fraction, 0f, 1f));
    }

    default int getFractionY(float fraction) {
        return this.getY() + Math.round(this.getHeight() * Math.clamp(fraction, 0f, 1f));
    }

    default int getMidX() {
        return this.getX() + this.getWidth() / 2;
    }

    default int getMidY() {
        return this.getY() + this.getHeight() / 2;
    }

    default boolean containsPoint(int px, int py) {
        return px >= this.getX() && px < this.getRight() &&
               py >= this.getY() && py < this.getBottom();
    }

    default boolean containsPoint(double px, double py) {
        return this.containsPoint((int) px, (int) py);
    }

    default boolean contains(int x, int y, int right, int bottom) {
        return x >= this.getX() &&
               y >= this.getY() &&
               right <= this.getRight() &&
               bottom <= this.getBottom();
    }

    default boolean contains(GuiRectangle rectangle) {
        return this.contains(rectangle.getX(), rectangle.getY(), rectangle.getRight(), rectangle.getBottom());
    }

    default boolean contains(class_8030 rectangle) {
        return this.contains(rectangle.method_49620(), rectangle.method_49618(), rectangle.method_49621(), rectangle.method_49619());
    }

    default boolean contains(class_8021 element) {
        return this.contains(element.method_46426(), element.method_46427(), GuiUtil.getRight(element), GuiUtil.getBottom(element));
    }

    default boolean intersects(int left, int top, int right, int bottom) {
        return this.getX() < right &&
               this.getRight() > left &&
               this.getY() < bottom &&
               this.getBottom() > top;
    }

    default boolean intersects(GuiRectangle rectangle) {
        return this.intersects(rectangle.getX(), rectangle.getY(), rectangle.getRight(), rectangle.getBottom());
    }

    default boolean intersects(class_8030 rectangle) {
        return this.intersects(rectangle.method_49620(), rectangle.method_49618(), rectangle.method_49621(), rectangle.method_49619());
    }

    default boolean intersects(class_8021 element) {
        return this.intersects(element.method_46426(), element.method_46427(), GuiUtil.getRight(element), GuiUtil.getBottom(element));
    }

    default class_8030 getScreenRectangle() {
        return new class_8030(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }
}
