/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.fidgetz.gui.components;

import io.github.fishstiz.fidgetz.gui.components.AbstractFixedListWidget;
import io.github.fishstiz.fidgetz.gui.components.AbstractWidgetBuilder;
import io.github.fishstiz.fidgetz.gui.components.FidgetzButton;
import io.github.fishstiz.fidgetz.gui.components.ToggleableEditBox;
import io.github.fishstiz.fidgetz.util.ARGBColor;
import io.github.fishstiz.fidgetz.util.debounce.PollingDebouncer;
import io.github.fishstiz.fidgetz.util.debounce.SimplePollingDebouncer;
import io.github.fishstiz.fidgetz.util.lang.CollectionsUtil;
import io.github.fishstiz.fidgetz.util.text.TextStylizer;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_5244;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditableList<T>
extends AbstractFixedListWidget<AbstractEntry> {
    private static final int DEFAULT_MAX_TEXT_LENGTH = 32;
    private static final int UPDATE_DELAY_MS = 100;
    private final PollingDebouncer<Void> updateListener;
    private final Function<T, String> textMapper;
    private final Function<String, T> valueMapper;
    @Nullable
    private final Predicate<String> textFilter;
    @Nullable
    private final Predicate<String> saveValidator;
    private final List<TextStylizer> textStylizers;
    private final int maxLength;

    protected EditableList(Builder<T> builder) {
        super(builder.itemHeight);
        this.textMapper = builder.textMapper;
        this.valueMapper = builder.valueMapper;
        Consumer listener = builder.updateListener;
        this.updateListener = new SimplePollingDebouncer<Void>(() -> {
            if (listener != null) {
                listener.accept(this.extractItems());
            }
        }, 100L);
        this.textFilter = builder.textFilter;
        this.saveValidator = builder.saveValidator;
        this.maxLength = builder.maxTextLength;
        this.textStylizers = builder.textStylizers.isEmpty() ? Collections.emptyList() : builder.textStylizers;
        this.method_48229(builder.x, builder.y);
        this.method_55445(builder.width, builder.height);
        this.setItems(builder.items);
    }

    /*
     * Unable to fully structure code
     */
    public void setItems(List<T> items) {
        entries = this.method_25396();
        lastEntry = entries.isEmpty() == false ? (AbstractEntry)entries.getLast() : null;
        this.method_25339();
        for (T item : items) {
            this.method_25321((class_350.class_351)new Entry(item));
        }
        if (!(lastEntry instanceof DirtyEntry)) ** GOTO lbl-1000
        dirtyEntry = (DirtyEntry)lastEntry;
        if (!dirtyEntry.removed) {
            this.method_25321((class_350.class_351)new DirtyEntry(dirtyEntry.editBox.method_1882()));
        } else lbl-1000:
        // 2 sources

        {
            this.method_25321((class_350.class_351)new DirtyEntry());
        }
        this.clampScrollAmount();
    }

    public List<T> extractItems() {
        return (List)CollectionsUtil.mapIf(this.method_25396(), AbstractEntry::canSave, AbstractEntry::dirtyItem, ObjectArrayList::new);
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_48579(guiGraphics, mouseX, mouseY, partialTick);
        this.updateListener.poll();
    }

    public static <T> Builder<T> builder(List<T> items, Function<T, String> textMapper, Function<String, T> valueMapper) {
        return new Builder<T>(items, textMapper, valueMapper);
    }

    public static Builder<String> builder(List<String> items) {
        return EditableList.builder(items, Function.identity(), Function.identity());
    }

    public static Builder<String> builder() {
        return EditableList.builder(Collections.emptyList(), Function.identity(), Function.identity());
    }

    public static class Builder<T>
    extends AbstractWidgetBuilder<Builder<T>> {
        private final List<T> items;
        private final Function<T, String> textMapper;
        private final Function<String, T> valueMapper;
        private Consumer<List<T>> updateListener;
        private Predicate<String> textFilter;
        private Predicate<String> saveValidator;
        private int itemHeight = 20;
        private int maxTextLength = 32;
        private final List<TextStylizer> textStylizers = new ObjectArrayList();

        private Builder(List<T> items, Function<T, String> textMapper, Function<String, T> valueMapper) {
            this.items = items;
            this.textMapper = textMapper;
            this.valueMapper = valueMapper;
        }

        public Builder<T> setItemHeight(int itemHeight) {
            this.itemHeight = itemHeight;
            return this;
        }

        public Builder<T> setListener(Consumer<List<T>> listener) {
            this.updateListener = listener;
            return this;
        }

        public Builder<T> setTextFilter(Predicate<String> textFilter) {
            this.textFilter = textFilter;
            return this;
        }

        public Builder<T> addTextStylizer(TextStylizer textStylizer) {
            this.textStylizers.add(textStylizer);
            return this;
        }

        public Builder<T> addTextStylizer(Collection<TextStylizer> textStylizers) {
            this.textStylizers.addAll(textStylizers);
            return this;
        }

        public Builder<T> setSaveValidator(Predicate<String> saveValidator) {
            this.saveValidator = saveValidator;
            return this;
        }

        public Builder<T> setMaxTextLength(int maxTextLength) {
            this.maxTextLength = maxTextLength;
            return this;
        }

        public EditableList<T> build() {
            return new EditableList(this);
        }
    }

    protected abstract class AbstractEntry
    extends AbstractFixedListWidget.Entry {
        protected final List<class_339> widgets;
        protected final ToggleableEditBox<Void> editBox;
        protected final FidgetzButton<Void> actionButton;
        protected final T item;

        protected AbstractEntry(T item, int textColor, class_2561 actionIcon) {
            this.item = item;
            this.actionButton = ((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)FidgetzButton.builder().makeSquare()).setMessage(actionIcon)).setOnPress(this::runAction)).build();
            this.editBox = ToggleableEditBox.builder().setValue(item != null ? EditableList.this.textMapper.apply(item) : "").setEditable(true).setHint(class_5244.field_39678).setFilter(EditableList.this.textFilter).setMaxLength(EditableList.this.maxLength).addTextStylizer(EditableList.this.textStylizers).setTextColor(textColor).addListener(value -> {
                this.actionButton.field_22763 = this.canRun((String)value);
                EditableList.this.updateListener.run();
            }).build();
            this.editBox.allowPastingSectionSign(true);
            this.actionButton.field_22763 = !this.editBox.method_1882().isEmpty();
            this.widgets = List.of(this.editBox, this.actionButton);
        }

        protected abstract boolean canSave();

        protected abstract boolean canRun(String var1);

        protected abstract void runAction();

        public T dirtyItem() {
            return EditableList.this.valueMapper.apply(this.editBox.method_1882());
        }

        public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            this.editBox.method_25358(this.method_25368() - this.actionButton.method_25368());
            this.editBox.method_48229(this.method_46426(), this.method_46427());
            this.actionButton.method_48229(this.editBox.method_55442(), this.method_46427());
            this.editBox.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            this.actionButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }

        @NotNull
        public List<class_339> method_25396() {
            return this.widgets;
        }

        @NotNull
        public List<class_339> method_37025() {
            return this.widgets;
        }

        @Override
        public void method_48206(Consumer<class_339> consumer) {
            this.widgets.forEach(consumer);
        }
    }

    protected class Entry
    extends AbstractEntry {
        private static final class_2561 ACTION_ICON = class_2561.method_43470((String)"-");
        private boolean removed;

        Entry(T value) {
            super(value, -1, ACTION_ICON);
            this.removed = false;
        }

        @Override
        protected boolean canRun(String value) {
            return true;
        }

        @Override
        protected boolean canSave() {
            return !this.removed && !this.editBox.method_1882().isBlank();
        }

        @Override
        protected void runAction() {
            this.removed = true;
            EditableList.this.setItems(EditableList.this.extractItems());
            EditableList.this.updateListener.run();
        }
    }

    protected class DirtyEntry
    extends AbstractEntry {
        private static final int TEXT_COLOR = ARGBColor.withAlpha(-1, 0.65f);
        private static final class_2561 ACTION_ICON = class_2561.method_43470((String)"+");
        private boolean removed;

        protected DirtyEntry() {
            super(null, TEXT_COLOR, ACTION_ICON);
            this.removed = false;
        }

        protected DirtyEntry(String value) {
            this();
            this.editBox.setValueSilently(value);
            this.actionButton.field_22763 = !this.editBox.method_1882().isEmpty();
        }

        @Override
        protected boolean canSave() {
            return false;
        }

        @Override
        protected boolean canRun(String value) {
            return value != null && !value.isBlank() && (EditableList.this.saveValidator == null || EditableList.this.saveValidator.test(value));
        }

        @Override
        protected void runAction() {
            this.removed = true;
            List items = EditableList.this.extractItems();
            items.add(this.dirtyItem());
            EditableList.this.setItems(items);
            EditableList.this.updateListener.run();
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (keyCode == 257 && this.canRun(this.editBox.method_1882())) {
                this.runAction();
                return true;
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }
    }
}

