/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.config;

import com.google.common.hash.Hashing;
import io.github.fishstiz.fidgetz.util.lang.ObjectsUtil;
import io.github.fishstiz.packed_packs.PackedPacks;
import io.github.fishstiz.packed_packs.config.PackOptions;
import io.github.fishstiz.packed_packs.config.PackOverride;
import io.github.fishstiz.packed_packs.util.PackUtil;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.minecraft.class_3288;
import net.minecraft.class_9225;
import org.jetbrains.annotations.Nullable;

public class Profile
implements PackOptions,
Serializable {
    public static final int NAME_MAX_LENGTH = 32;
    private static final String TEMP_PREFIX = "__temp__";
    private static final String DELIMITER = "__";
    private boolean locked = false;
    private String name;
    private Map<String, PackOverride> overrides = new Object2ObjectOpenHashMap();
    private Set<String> packIds = new ObjectLinkedOpenHashSet();
    @Deprecated
    private String id;
    private transient String hash;

    Profile() {
        this.id = TEMP_PREFIX + Instant.now().toEpochMilli();
    }

    public Profile(String name) {
        this.name = Profile.trimName(name);
        this.hash = Hashing.murmur3_32_fixed().hashString((CharSequence)(this.name + Instant.now().toEpochMilli()), StandardCharsets.UTF_8).toString();
        this.id = this.name + DELIMITER + this.hash;
    }

    private Profile(String name, Set<String> packIds, Map<String, PackOverride> overrides) {
        this(name);
        this.packIds = new ObjectLinkedOpenHashSet(packIds);
        this.overrides = new Object2ObjectOpenHashMap(overrides);
        this.overrides.replaceAll((id, override) -> new PackOverride(override.hidden(), override.required(), override.position()));
    }

    public String getId() {
        return this.id;
    }

    boolean remapPackId(String packId, String newId) {
        PackOverride packOverride;
        ObjectArrayList packIdsList;
        int index;
        boolean remapped = false;
        if (this.packIds.contains(packId) && !this.packIds.contains(newId) && (index = (packIdsList = new ObjectArrayList(this.packIds)).indexOf(packId)) != -1) {
            PackedPacks.LOGGER.info("[packed_packs] Updating pack id '{}' to '{}' in profile '{}'", new Object[]{packId, newId, this.name});
            packIdsList.add(index, newId);
            this.packIds = new ObjectLinkedOpenHashSet((Collection)packIdsList);
            remapped = true;
        }
        if ((packOverride = this.overrides.get(packId)) != null) {
            PackedPacks.LOGGER.info("[packed_packs] Copying overrides from pack id '{}' to '{}' in profile '{}'", new Object[]{packId, newId, this.name});
            this.overrides.put(newId, packOverride);
            remapped = true;
        }
        return remapped;
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        if (!this.isLocked()) {
            this.name = Profile.trimName(name);
            if (this.hash != null) {
                this.id = this.id.replaceAll("^.*(?=" + Pattern.quote(this.hash) + "$)", this.name + DELIMITER);
            }
        }
    }

    public Profile copy() {
        Object profileName = this.name;
        if (profileName != null && !((String)profileName).isBlank()) {
            profileName = (String)profileName + " - " + ResourceUtil.getText("profile.copy", new Object[0]).getString();
        }
        return new Profile((String)profileName, this.packIds, this.overrides);
    }

    public boolean includes(class_3288 pack) {
        return this.packIds.contains(pack.method_14463());
    }

    public List<String> getPackIds() {
        return List.copyOf(this.packIds);
    }

    public void setPacks(Collection<class_3288> selected) {
        if (!this.locked) {
            selected = PackUtil.flattenPacks(selected);
            this.packIds = new ObjectLinkedOpenHashSet(PackUtil.extractPackIds(selected));
        }
    }

    public void syncPacks(Collection<class_3288> available, Collection<class_3288> selected) {
        if (!this.locked) {
            available = PackUtil.flattenPacks(available);
            selected = PackUtil.flattenPacks(selected);
            this.packIds = new ObjectLinkedOpenHashSet(PackUtil.extractPackIds(selected));
            ObjectOpenHashSet availableIds = new ObjectOpenHashSet(PackUtil.extractPackIds(available));
            this.overrides.entrySet().removeIf(arg_0 -> this.lambda$syncPacks$1((Set)availableIds, arg_0));
        }
    }

    public void setHidden(boolean hidden, Collection<class_3288> packs) {
        for (class_3288 pack : PackUtil.flattenPacks(packs)) {
            this.setHidden(hidden, pack);
        }
    }

    public void setHidden(boolean hidden, class_3288 pack) {
        this.applyOrRemoveOverride(pack.method_14463(), hidden ? Boolean.valueOf(true) : null, PackOverride::setHidden);
    }

    public void setRequired(@Nullable Boolean required, Collection<class_3288> packs) {
        for (class_3288 pack : PackUtil.flattenPacks(packs)) {
            this.setRequired(required, pack);
        }
    }

    public void setRequired(@Nullable Boolean required, class_3288 pack) {
        if (!Boolean.FALSE.equals(required) || !PackUtil.isEssential(pack)) {
            this.applyOrRemoveOverride(pack.method_14463(), required, PackOverride::setRequired);
        }
    }

    public void setPosition(@Nullable PackOverride.Position position, Collection<class_3288> packs) {
        for (class_3288 pack : PackUtil.flattenPacks(packs)) {
            this.setPosition(position, pack);
        }
    }

    public void setPosition(@Nullable PackOverride.Position position, class_3288 pack) {
        this.applyOrRemoveOverride(pack.method_14463(), position, PackOverride::setPosition);
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public boolean isHidden(class_3288 pack) {
        return Boolean.TRUE.equals(ObjectsUtil.mapOrDefault(this.overrides.get(pack.method_14463()), false, PackOverride::hidden));
    }

    @Override
    public boolean isRequired(class_3288 pack) {
        return Boolean.TRUE.equals(ObjectsUtil.mapOrDefault(this.overrides.get(pack.method_14463()), false, PackOverride::required));
    }

    @Override
    public boolean isFixed(class_3288 pack) {
        if (this.overridesPosition(pack)) {
            return Objects.requireNonNull(this.overrides.get(pack.method_14463()).position()).fixed();
        }
        return false;
    }

    @Override
    @Nullable
    public class_3288.class_3289 getPosition(class_3288 pack) {
        if (this.overridesPosition(pack)) {
            return Objects.requireNonNull(this.overrides.get(pack.method_14463()).position()).get(pack);
        }
        return null;
    }

    @Nullable
    public PackOverride.Position getPositionOverride(class_3288 pack) {
        if (this.overridesPosition(pack)) {
            return this.overrides.get(pack.method_14463()).position();
        }
        return null;
    }

    @Override
    @Nullable
    public class_9225 getSelectionConfig(class_3288 pack) {
        PackOverride packEntry = this.overrides.get(pack.method_14463());
        if (packEntry != null && (packEntry.required() != null || packEntry.position() != null)) {
            return new class_9225(this.isRequired(pack), this.getPosition(pack), this.isFixed(pack));
        }
        return null;
    }

    public boolean overridesRequired(class_3288 pack) {
        return this.overridesProperty(pack, PackOverride::required);
    }

    public boolean overridesPosition(class_3288 pack) {
        return this.overridesProperty(pack, PackOverride::position);
    }

    private boolean overridesProperty(class_3288 pack, Function<PackOverride, @Nullable Object> property) {
        PackOverride entry = this.overrides.get(pack.method_14463());
        return entry != null && property.apply(entry) != null;
    }

    public boolean hasOverride(class_3288 pack) {
        PackOverride entry = this.overrides.get(pack.method_14463());
        return entry != null && entry.hasOverride();
    }

    private <T> void applyOrRemoveOverride(String packId, T property, BiConsumer<PackOverride, T> setter) {
        PackOverride override = this.overrides.computeIfAbsent(packId, id -> new PackOverride());
        setter.accept(override, (PackOverride)property);
        if (!override.hasOverride()) {
            this.overrides.remove(packId);
        }
    }

    private static String trimName(String name) {
        if (name == null) {
            return null;
        }
        return name.length() <= 32 ? name : name.substring(0, 32);
    }

    void lockId() {
        this.hash = null;
    }

    void lockId(String id) {
        this.id = id;
        this.lockId();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Profile)) {
            return false;
        }
        Profile other = (Profile)obj;
        return Objects.equals(other.getId(), this.getId());
    }

    private /* synthetic */ boolean lambda$syncPacks$1(Set availableIds, Map.Entry entry) {
        PackOverride override = (PackOverride)entry.getValue();
        String packId = (String)entry.getKey();
        return !override.hasOverride() || !this.packIds.contains(packId) && !availableIds.contains(packId);
    }
}

