package io.github.fishstiz.fidgetz.gui.components;

import io.github.fishstiz.fidgetz.gui.shapes.Padding;
import org.jetbrains.annotations.NotNull;

import java.util.function.Consumer;
import net.minecraft.class_1144;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_5244;
import net.minecraft.class_6382;
import net.minecraft.class_8021;
import net.minecraft.class_8133;

public class LayoutWrapper<T extends class_8133> extends class_339 implements class_8133 {
    private T layout;
    private int minWidth;
    private int minHeight;
    private int paddingTop;
    private int paddingRight;
    private int paddingBottom;
    private int paddingLeft;

    public LayoutWrapper(T layout, int minWidth, int minHeight) {
        super(layout.method_46426(), layout.method_46427(), layout.method_25368(), layout.method_25364(), class_5244.field_39003);

        this.layout = layout;
        this.minWidth = minWidth;
        this.minHeight = minHeight;

        this.field_22763 = false;

        this.method_48222();
    }

    public LayoutWrapper(T layout) {
        this(layout, 0, 0);
    }

    public void setLayout(@NotNull T layout) {
        this.layout = layout;
        this.method_48222();
    }

    public T layout() {
        return this.layout;
    }

    public void setPadding(int top, int right, int bottom, int left) {
        this.paddingTop = top;
        this.paddingRight = right;
        this.paddingBottom = bottom;
        this.paddingLeft = left;
    }

    public void setPadding(Padding padding) {
        this.setPadding(padding.top(), padding.right(), padding.bottom(), padding.left());
    }

    public void setPadding(int padding) {
        this.setPadding(padding, padding, padding, padding);
    }

    @Override
    public void method_25358(int width) {
        this.field_22758 = Math.max(this.minWidth, width);
    }

    @Override
    public void method_53533(int height) {
        this.field_22759 = Math.max(this.minHeight, height);
    }

    public void setMinWidth(int minWidth) {
        this.minWidth = minWidth;
        this.method_25358(this.field_22758);
    }

    public void setMinHeight(int minHeight) {
        this.minHeight = minHeight;
        this.method_53533(this.field_22759);
    }

    @Override
    public boolean method_37303() {
        return false;
    }

    @Override
    public void method_46421(int x) {
        this.layout.method_46421(x + this.paddingLeft);
    }

    @Override
    public void method_46419(int y) {
        this.layout.method_46419(y + this.paddingTop);
    }

    @Override
    public int method_46426() {
        return this.layout.method_46426() - this.paddingLeft;
    }

    @Override
    public int method_46427() {
        return this.layout.method_46427() - this.paddingTop;
    }

    @Override
    public int method_25368() {
        return this.field_22758 + this.paddingLeft + this.paddingRight;
    }

    @Override
    public int method_25364() {
        return this.field_22759 + this.paddingTop + this.paddingBottom;
    }

    public Padding getPadding() {
        return new Padding(this.paddingTop, this.paddingRight, this.paddingBottom, this.paddingLeft);
    }

    @Override
    public void method_48227(Consumer<class_8021> visitor) {
        this.layout.method_48227(visitor);
    }

    @Override
    public void method_48206(Consumer<class_339> consumer) {
        this.layout.method_48206(consumer);
    }

    @Override
    public void method_48222() {
        this.layout.method_48222();
        this.method_48229(this.layout.method_46426(), this.layout.method_46427());
        this.method_25358(this.layout.method_25368());
        this.method_53533(this.layout.method_25364());
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        return false;
    }

    @Override
    protected final void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    @Override
    protected final void method_47399(class_6382 narrationElementOutput) {
        this.layout.method_48206(widget -> widget.method_37020(narrationElementOutput));
    }

    @Override
    public final void method_25354(class_1144 handler) {
    }
}

