package io.github.fishstiz.packed_packs.compat.vtdownloader;

import io.github.fishstiz.fidgetz.gui.components.Fidgetz;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuItemBuilder;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuProvider;
import io.github.fishstiz.packed_packs.PackedPacks;
import io.github.fishstiz.packed_packs.compat.ModScreenFactory;
import io.github.fishstiz.packed_packs.compat.PackWrapperDelegatorAbstractionEpicModelEntry;
import io.github.fishstiz.packed_packs.config.Preferences;
import io.github.fishstiz.packed_packs.gui.components.pack.PackList;
import io.github.fishstiz.packed_packs.gui.metadata.Toggleable;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5369;
import net.minecraft.class_6382;
import net.minecraft.class_8021;
import org.jetbrains.annotations.Nullable;

import static io.github.fishstiz.packed_packs.compat.vtdownloader.VTDButtonFactory.VTD_SCREEN_NAME;
import static io.github.fishstiz.packed_packs.compat.vtdownloader.VTDButtonFactory.VTD_SUBTITLE;

/**
 * Copied from VTDownloader
 * <p>
 * Original work Copyright (c) 2020-2023 IotaBread
 * <p>
 * Licensed under the MIT License.
 *
 * @see <a href="https://github.com/IotaBread/VTDownloader/blob/1.21/src/main/java/me/bymartrixx/vtd/mixin/PackEntryListWidgetMixin.java">Github</a>
 */
public class VTDEditButtonWidget extends class_4264 implements ContextMenuProvider, Fidgetz {
    private static final String VT_DESCRIPTION_MARKER = "vanillatweaks.net";
    private static final class_2960 PENCIL_TEXTURE = class_2960.method_60655("vt_downloader", "textures/pencil.png");
    private static final int PENCIL_TEXTURE_SIZE = 32;
    private static final int PENCIL_SIZE = 16;
    private static final int PENCIL_MARGIN_RIGHT = 1;
    private final class_8021 container;
    private final class_437 previous;
    private final class_5369.class_5371 pack;
    private final boolean editable;
    private final @Nullable Toggleable toggleable;

    private VTDEditButtonWidget(class_8021 container, class_437 previous, class_5369.class_5371 pack, boolean editable) {
        super(0, 0, PENCIL_SIZE, PENCIL_SIZE, class_5244.field_39003);

        this.toggleable = PackedPacks.CONFIG.isDevMode() ? new Toggleable(Preferences.INSTANCE.vtdEditButton) : null;
        this.container = container;
        this.previous = previous;
        this.pack = pack;
        this.editable = editable;
        this.field_22763 = this.editable;
    }

    public static @Nullable VTDEditButtonWidget create(class_437 previous, PackList.Entry entry) {
        return entry.pack().method_14459().getString().contains(VT_DESCRIPTION_MARKER)
                ? new VTDEditButtonWidget(entry, previous, new PackWrapperDelegatorAbstractionEpicModelEntry(entry.pack()), entry.canOperateFile())
                : null;
    }

    @Override
    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.field_22762 = this.field_22762 && Fidgetz.super.isHovered(mouseX, mouseY);

        int pencilX = this.container.method_46426() + this.container.method_25368() - PENCIL_SIZE - PENCIL_MARGIN_RIGHT;
        int pencilY = this.container.method_46427() + this.container.method_25364() - PENCIL_SIZE;
        this.method_48229(pencilX, pencilY);

        float u = 0.0F;
        float v = 0.0F;
        if (!this.editable) {
            v = PENCIL_SIZE;
        } else if (this.method_49606()) {
            u = PENCIL_SIZE;
        }

        guiGraphics.method_25290(
                class_1921::method_62277,
                PENCIL_TEXTURE,
                pencilX, pencilY,
                u, v,
                PENCIL_SIZE, PENCIL_SIZE,
                PENCIL_TEXTURE_SIZE, PENCIL_TEXTURE_SIZE
        );

        if (this.toggleable != null) {
            this.toggleable.render(guiGraphics, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), partialTick);
        }
    }

    @Override
    public boolean method_25405(double mouseX, double mouseY) {
        return this.field_22764 && Fidgetz.super.method_25405(mouseX, mouseY);
    }

    @Override
    public void method_25306() {
        if (this.editable) {
            ModScreenFactory.createScreenSetter(
                    VTD_SCREEN_NAME,
                    new ModScreenFactory.Arg<>(class_437.class, this.previous),
                    new ModScreenFactory.Arg<>(class_2561.class, VTD_SUBTITLE),
                    new ModScreenFactory.Arg<>(class_5369.class_5371.class, this.pack)
            ).run();
        }
    }

    @Override
    protected void method_47399(class_6382 narrationElementOutput) {
        this.method_37021(narrationElementOutput);
    }

    @Override
    public void buildItems(ContextMenuItemBuilder builder, int mouseX, int mouseY) {
        if (this.toggleable != null) {
            this.toggleable.buildContext(builder.separatorIfNonEmpty());
        }
    }
}
