package io.github.fishstiz.packed_packs.gui.layouts.pack;

import io.github.fishstiz.fidgetz.gui.components.FidgetzButton;
import io.github.fishstiz.fidgetz.gui.components.ToggleableEditBox;
import io.github.fishstiz.fidgetz.gui.layouts.FlexLayout;
import io.github.fishstiz.packed_packs.gui.components.pack.PackList;
import io.github.fishstiz.packed_packs.gui.metadata.GridWrapper;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import io.github.fishstiz.packed_packs.util.constants.GuiConstants;
import net.minecraft.class_2561;
import net.minecraft.class_7919;
import net.minecraft.class_8030;
import org.jetbrains.annotations.NotNull;

public abstract class PackLayout {
    private static final class_2561 SEARCH_HINT = ResourceUtil.getText("search");
    private static final class_2561 TRANSFER_INFO = ResourceUtil.getText("transfer_all.info");
    protected final PackList list;
    private final GridWrapper<FlexLayout> header;
    private final ToggleableEditBox<Void> searchField;
    private final FidgetzButton<Void> transferButton;
    private FlexLayout layout;

    protected PackLayout(PackList list) {
        this.list = list;
        this.header = new GridWrapper<>(FlexLayout.horizontal(this.list::method_25368).spacing(GuiConstants.SPACING), GuiConstants.SPACING);
        this.searchField = ToggleableEditBox.<Void>builder()
                .setHint(SEARCH_HINT)
                .setEditable(true)
                .addListener(this.list::search)
                .build();
        this.transferButton = FidgetzButton.<Void>builder()
                .makeSquare()
                .setOnPress(this.list::transferAll)
                .setTooltip(class_7919.method_47407(TRANSFER_INFO))
                .build();
    }

    protected void initHeader(@NotNull FlexLayout header) {
    }

    public final void init(@NotNull FlexLayout layout) {
        this.layout = layout;

        this.initHeader(this.header.layout());
        this.layout.addChild(this.header.layout());
        this.layout.addFlexChild(this.list, true);
        this.layout.method_48222();
    }

    public PackList list() {
        return this.list;
    }

    public ToggleableEditBox<Void> getSearchField() {
        return this.searchField;
    }

    public FidgetzButton<Void> getTransferButton() {
        return this.transferButton;
    }

    public void setHeaderVisibility(boolean visible) {
        if (layout == null) return;

        this.header.layout().method_48206(widget -> widget.field_22764 = visible);

        class_8030 headerRect = this.header.layout().method_48202();
        int y = visible ? headerRect.method_49619() + this.header.spacing() : headerRect.method_49618();
        int height = visible ? layout.method_25364() - headerRect.comp_1197() - this.header.spacing() : layout.method_25364();

        this.list.method_46419(y);
        this.list.method_53533(height);
        this.list.clampScrollAmount();
    }
}
