package io.github.fishstiz.packed_packs.pack.folder;

import io.github.fishstiz.packed_packs.config.ConfigLoader;
import io.github.fishstiz.packed_packs.config.Folder;
import io.github.fishstiz.packed_packs.transform.interfaces.FilePack;
import io.github.fishstiz.packed_packs.util.PackUtil;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import io.github.fishstiz.packed_packs.util.lang.ObjectsUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_3262;
import net.minecraft.class_3281;
import net.minecraft.class_3288;
import net.minecraft.class_7699;
import net.minecraft.class_9224;
import net.minecraft.class_9225;
import net.minecraft.server.packs.*;
import org.jetbrains.annotations.Nullable;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class FolderPack extends class_3288 implements FilePack {
    public static final class_2561 FOLDER_OPEN_TEXT = ResourceUtil.getText("folder.open");
    public static final class_2561 FOLDER_DESCRIPTION = ResourceUtil.getText("folder");
    public static final class_9225 FOLDER_SELECTION_CONFIG = new class_9225(false, class_3289.field_14280, false);
    public static final class_7679 FOLDER_METADATA = new class_7679(FOLDER_DESCRIPTION, class_3281.field_14224, class_7699.method_45397(), Collections.emptyList());
    private final Function<String, List<class_3288>> nestedPacksProvider;
    private final Path path;

    public FolderPack(String id, String name, Function<String, List<class_3288>> nestedPacksProvider, Path path) {
        super(
                new class_9224(id, class_2561.method_43470(name), PackUtil.PACK_SOURCE, Optional.empty()),
                new FolderResourcesSupplier(path),
                FOLDER_METADATA,
                FOLDER_SELECTION_CONFIG
        );
        this.nestedPacksProvider = nestedPacksProvider;
        this.path = path;
    }

    public List<class_3288> flatten() {
        List<class_3288> result = new ObjectArrayList<>();
        result.add(this);
        result.addAll(ObjectsUtil.getOrDefault(this.nestedPacksProvider.apply(this.method_14463()), Collections.emptyList()));
        return result;
    }

    public CompletableFuture<Folder> loadConfig() {
        return CompletableFuture.supplyAsync(() -> {
            try (class_3262 resources = this.method_14458()) {
                var configIoSupplier = resources.method_14410(FolderResources.FOLDER_CONFIG_FILENAME);
                if (configIoSupplier == null) {
                    throw new IOException();
                }
                try (InputStream inputStream = configIoSupplier.get()) {
                    return ConfigLoader.load(inputStream, Folder.class);
                }
            } catch (NoSuchFileException e) {
                return ObjectsUtil.peek(new Folder(), this::saveConfig);
            } catch (IOException e) {
                return new Folder();
            }
        }, class_156.method_18349());
    }

    public void saveConfig(Folder folder) {
        if (folder != null) {
            folder.save(this.path.resolve(FolderResources.FOLDER_CONFIG_FILENAME));
        }
    }

    @Override
    public @Nullable Path packed_packs$getPath() {
        return this.path;
    }
}
