/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.fishstiz.packed_packs.PackedPacks;
import io.github.fishstiz.packed_packs.config.PackOverride;
import io.github.fishstiz.packed_packs.config.Profile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.function.Supplier;

public class ConfigLoader {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(PackOverride.class, (Object)new PackOverride.Adapter()).registerTypeAdapter(Profile.class, (Object)new Profile.Deserializer()).create();

    private ConfigLoader() {
    }

    public static <T extends Serializable> T load(InputStream inputStream, Class<T> spec) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(inputStream);){
            Serializable serializable = (Serializable)GSON.fromJson((Reader)reader, spec);
            return (T)serializable;
        }
    }

    public static <T extends Serializable> T loadOrSave(File file, Class<T> clazz, Supplier<T> defaultFactory) {
        Serializable serializable;
        try (FileReader reader = new FileReader(file);){
            serializable = (Serializable)GSON.fromJson((Reader)reader, clazz);
        }
        catch (FileNotFoundException e) {
            serializable = (Serializable)defaultFactory.get();
            PackedPacks.LOGGER.info("[packed_packs] Creating config at '{}'...", (Object)file.getPath());
            ConfigLoader.save(serializable, file);
        }
        catch (IOException e) {
            serializable = (Serializable)defaultFactory.get();
            PackedPacks.LOGGER.error("[packed_packs] Failed to load config at '{}'.", (Object)file.getPath());
        }
        return (T)serializable;
    }

    public static <T extends Serializable> void save(T serializable, File file) {
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson(serializable, (Appendable)writer);
        }
        catch (IOException e) {
            PackedPacks.LOGGER.info("[packed_packs] Failed to save config at '{}'.", (Object)file.getPath());
        }
    }
}

