/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.layouts;

import io.github.fishstiz.fidgetz.gui.components.FidgetzButton;
import io.github.fishstiz.fidgetz.gui.components.LayoutWrapper;
import io.github.fishstiz.fidgetz.gui.components.ToggleableEditBox;
import io.github.fishstiz.fidgetz.gui.layouts.FlexLayout;
import io.github.fishstiz.fidgetz.gui.renderables.RenderableRect;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.ButtonSprites;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.fidgetz.gui.shapes.Size;
import io.github.fishstiz.packed_packs.config.Config;
import io.github.fishstiz.packed_packs.config.Profile;
import io.github.fishstiz.packed_packs.gui.components.profile.ProfileList;
import io.github.fishstiz.packed_packs.gui.components.profile.Sidebar;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import io.github.fishstiz.packed_packs.util.constants.GuiConstants;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_7847;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProfilesLayout {
    public static final class_2561 TITLE_TEXT = ResourceUtil.getText("profile", new Object[0]);
    private static final class_2561 EDIT_NAME_TEXT = ResourceUtil.getText("profile.edit", new Object[0]);
    private static final class_2561 NO_PROFILE_TEXT = ResourceUtil.getText("profile.none", new Object[0]);
    private static final class_2561 UNNAMED_TEXT = ResourceUtil.getText("profile.unnamed", new Object[0]);
    private static final class_2561 NEW_TEXT = ResourceUtil.getText("profile.new", new Object[0]);
    private static final class_2561 NEW_INFO = ResourceUtil.getText("profile.new.info", new Object[0]);
    private static final class_2561 COPY_TEXT = ResourceUtil.getText("profile.copy", new Object[0]);
    private static final int MAX_WIDTH = 160;
    private final Config.Packs config;
    private final Sidebar sidebar;
    private final CopyListener copyListener;
    private final ToggleableEditBox<Void> nameField;
    private final FidgetzButton<Void> toggleNameButton;
    private final FidgetzButton<Void> noProfileButton;
    private final ProfileList profileList;

    public <S extends class_437> ProfilesLayout(S screen, Config.Packs config, ProfileList.SelectListener selectListener, CopyListener copyListener) {
        this.config = config;
        this.copyListener = copyListener;
        this.sidebar = Sidebar.builder(screen).setHeaderSettings(class_7847.method_46481().method_46469(8).method_46471(7)).setMaxWidth(160).setTitle(TITLE_TEXT, true).build();
        this.nameField = ToggleableEditBox.builder().setHint(UNNAMED_TEXT).setMaxLength(32).setFilter(value -> value != null && (value.isEmpty() || !value.isBlank())).addListener(this::onNameChange).build();
        this.toggleNameButton = ((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)FidgetzButton.builder().makeSquare()).setTooltip(class_7919.method_47407((class_2561)EDIT_NAME_TEXT))).setSprite(new ButtonSprites(new Sprite(ResourceUtil.getIcon("edit"), Size.of16()), new Sprite(ResourceUtil.getIcon("edit_inactive"), Size.of16()), this::getToggleSpriteRenderer))).setOnPress(this.nameField::toggle)).build();
        this.noProfileButton = ((FidgetzButton.Builder)((FidgetzButton.Builder)FidgetzButton.builder().setMessage(NO_PROFILE_TEXT)).setOnPress(() -> this.setProfile(null))).build();
        this.profileList = new ProfileList(this.config, selectListener, this::updateGuiState);
    }

    public void initContents() {
        class_7847 layoutSettings = class_7847.method_46481().method_46477(8);
        FlexLayout actions = FlexLayout.horizontal(this::getMaxWidth).spacing(8);
        FlexLayout list = FlexLayout.horizontal(this::getMaxWidth);
        actions.addFlexChild(this.noProfileButton);
        actions.addFlexChild(((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)FidgetzButton.builder().setMessage(NEW_TEXT)).setTooltip(class_7919.method_47407((class_2561)NEW_INFO))).setOnPress(this::copyProfile)).build());
        list.addFlexChild(this.profileList, true);
        ((FlexLayout)((LayoutWrapper)((Object)this.sidebar.root())).layout()).addChild(actions, layoutSettings);
        ((FlexLayout)((LayoutWrapper)((Object)this.sidebar.root())).layout()).addFlexChild(list, true, layoutSettings.method_46478().method_46475(9));
        ((FlexLayout)((LayoutWrapper)((Object)this.sidebar.root())).layout()).method_48222();
        ((FlexLayout)((LayoutWrapper)((Object)this.sidebar.root())).layout()).method_48206(this.sidebar::addRenderableWidget);
        this.updateGuiState(this.profileList.getSelectedProfile());
    }

    private RenderableRect getToggleSpriteRenderer(Sprite sprite) {
        Profile profile = this.profileList.getSelectedProfile();
        if (profile != null && profile.isLocked()) {
            Profile defaultProfile = this.config.getDefaultProfile();
            return profile == defaultProfile ? GuiConstants.STAR_SPRITE::renderClamped : GuiConstants.LOCK_SPRITE;
        }
        return sprite::renderClamped;
    }

    public int getMaxWidth() {
        return 160;
    }

    public Sidebar getSidebar() {
        return this.sidebar;
    }

    public ToggleableEditBox<Void> getNameField() {
        return this.nameField;
    }

    public FidgetzButton<Void> getToggleNameButton() {
        return this.toggleNameButton;
    }

    private void onNameChange(String value) {
        Profile profile = this.profileList.getSelectedProfile();
        if (profile != null) {
            String name = value;
            if (value.isEmpty()) {
                name = UNNAMED_TEXT.getString();
            }
            profile.setName(name);
        }
        this.profileList.scheduleRefresh();
    }

    private void updateGuiState(@Nullable Profile profile) {
        this.nameField.method_1888(false);
        boolean hasProfile = profile != null;
        this.nameField.method_47404(hasProfile ? UNNAMED_TEXT : NO_PROFILE_TEXT);
        this.nameField.setValueSilently(hasProfile ? profile.getName() : "");
        this.nameField.field_22764 = hasProfile;
        this.nameField.field_22763 = hasProfile;
        this.noProfileButton.field_22763 = hasProfile;
        this.toggleNameButton.field_22764 = hasProfile;
        this.toggleNameButton.field_22763 = hasProfile && !profile.isLocked();
    }

    public void setProfile(@Nullable Profile profile) {
        this.profileList.selectProfile(profile);
    }

    @Nullable
    public Profile getProfile() {
        return this.profileList.getSelectedProfile();
    }

    private void copyProfile() {
        Profile selectedProfile = this.profileList.getSelectedProfile();
        Profile copiedProfile = selectedProfile != null ? selectedProfile.copy() : new Profile(NO_PROFILE_TEXT.getString() + " - " + COPY_TEXT.getString());
        this.copyListener.onCopy(selectedProfile, copiedProfile);
        this.config.addProfile(copiedProfile);
        this.setProfile(copiedProfile);
        this.sidebar.setOpen(false);
        this.profileList.refresh();
    }

    public static interface CopyListener {
        public void onCopy(@Nullable Profile var1, @NotNull Profile var2);
    }
}

