/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.config;

import io.github.fishstiz.fidgetz.util.lang.CollectionsUtil;
import io.github.fishstiz.fidgetz.util.lang.ObjectsUtil;
import io.github.fishstiz.packed_packs.PackedPacks;
import io.github.fishstiz.packed_packs.config.JsonLoader;
import io.github.fishstiz.packed_packs.config.Profile;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import net.minecraft.class_3264;
import org.jetbrains.annotations.Nullable;

public class Profiles {
    private static final String PROFILE_DIR = "profiles";
    private static final String PROFILE_EXTENSION = ".profile.json";
    private static final String RESOURCE_PACK_DIR = "resourcepacks";
    private static final String DATA_PACK_DIR = "datapacks";

    private Profiles() {
    }

    @Nullable
    public static Profile get(class_3264 packType, String id) {
        Profile profile = JsonLoader.loadJsonOrDefault(Profiles.getFile(packType, id), Profile.class, ObjectsUtil::alwaysNull);
        if (profile != null) {
            profile.lockId(id);
        }
        return profile;
    }

    public static List<Profile> getAll(class_3264 packType, Executor executor) {
        Path profileDir = Profiles.getProfileDir(packType);
        if (!Files.isDirectory(profileDir, new LinkOption[0])) {
            return new ObjectArrayList();
        }
        ObjectArrayList futures = new ObjectArrayList();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(profileDir);){
            for (Path file : stream) {
                if (!file.getFileName().toString().endsWith(PROFILE_EXTENSION)) continue;
                futures.add(CompletableFuture.supplyAsync(() -> {
                    Profile profile = JsonLoader.loadJsonOrDefault(file, Profile.class, Profile::new);
                    profile.lockId(Profiles.toId(file));
                    return profile;
                }, executor));
            }
        }
        catch (IOException e) {
            PackedPacks.LOGGER.error("[packed_packs] Failed to fetch profiles at {}. ", (Object)profileDir, (Object)e);
        }
        CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new)).join();
        return (List)CollectionsUtil.map(futures, CompletableFuture::join, ObjectArrayList::new);
    }

    public static void save(class_3264 packType, Profile profile) {
        profile.lockId();
        JsonLoader.saveJson(profile, Profiles.getFile(packType, profile.getId()));
    }

    public static void saveAll(class_3264 packType, Collection<Profile> profiles, Executor executor) {
        ObjectLinkedOpenHashSet seen = new ObjectLinkedOpenHashSet(profiles.size());
        ObjectArrayList futures = new ObjectArrayList(profiles.size());
        for (Profile profile : profiles) {
            Path file = Profiles.getFile(packType, profile.getId()).toAbsolutePath().normalize();
            if (!seen.add(file)) continue;
            futures.add(CompletableFuture.runAsync(() -> {
                profile.lockId();
                JsonLoader.saveJson(profile, file);
            }, executor));
        }
        CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new)).join();
    }

    public static void delete(class_3264 packType, Profile profile) {
        Path file = Profiles.getFile(packType, profile.getId());
        try {
            Files.deleteIfExists(file);
        }
        catch (IOException e) {
            PackedPacks.LOGGER.error("[packed_packs] Failed to delete profile at {}", (Object)file);
        }
    }

    private static String toId(Path path) {
        return path.getFileName().toString().replaceFirst(Pattern.quote(PROFILE_EXTENSION) + "$", "");
    }

    private static Path getFile(class_3264 packType, String id) {
        return Profiles.getProfileDir(packType).resolve(id + PROFILE_EXTENSION);
    }

    private static Path getProfileDir(class_3264 packType) {
        Path path = PackedPacks.getConfigDir().resolve(PROFILE_DIR);
        return path.resolve(switch (packType) {
            default -> throw new MatchException(null, null);
            case class_3264.field_14188 -> RESOURCE_PACK_DIR;
            case class_3264.field_14190 -> DATA_PACK_DIR;
        });
    }
}

