/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.fidgetz.gui.components;

import io.github.fishstiz.fidgetz.gui.Metadata;
import io.github.fishstiz.fidgetz.gui.components.AbstractWidgetBuilder;
import io.github.fishstiz.fidgetz.gui.components.Fidgetz;
import io.github.fishstiz.fidgetz.transform.mixin.EditBoxAccess;
import io.github.fishstiz.fidgetz.util.LogUtil;
import io.github.fishstiz.fidgetz.util.text.AsyncStylizerFormatter;
import io.github.fishstiz.fidgetz.util.text.TextStylizer;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_5244;

public class ToggleableEditBox<E>
extends class_342
implements Fidgetz,
Metadata<E> {
    private static final int DEFAULT_MAX_LENGTH = 32;
    private final List<Consumer<String>> listeners;
    private final int hintColor;
    private E metadata;
    private int focusedTextColor;
    private String previousValue;

    private ToggleableEditBox(Builder<E> builder) {
        super(builder.font, builder.x, builder.y, builder.width, builder.height, (class_2561)class_2561.method_43470((String)builder.value));
        this.hintColor = builder.hintColor != null ? builder.hintColor.intValue() : ((EditBoxAccess)((Object)this)).getTextColorUneditable();
        this.focusedTextColor = builder.textColor != null ? builder.textColor.intValue() : ((EditBoxAccess)((Object)this)).getTextColor();
        this.previousValue = builder.value;
        this.metadata = builder.metadata;
        if (builder.filter != null) {
            this.method_1890(builder.filter);
        }
        this.method_1880(builder.maxLength);
        this.method_1852(builder.value);
        this.method_1888(builder.editable);
        this.method_47404(builder.hint);
        this.method_71503(builder.textShadow);
        this.updateTextColor();
        if (!builder.textStylizers.isEmpty()) {
            this.method_1854(new AsyncStylizerFormatter(builder.textStylizers, () -> ((ToggleableEditBox)this).method_1882())::format);
        }
        this.listeners = builder.listeners;
        super.method_1863(this::onRespond);
    }

    public void toggle() {
        this.method_1888(!this.isEditing());
    }

    public boolean isEditing() {
        return ((EditBoxAccess)((Object)this)).invokeIsEditable();
    }

    public void method_1888(boolean enabled) {
        super.method_1888(enabled);
        this.method_1870(false);
        this.field_22763 = enabled;
    }

    public void method_1868(int color) {
        super.method_1868(color);
        this.method_1860(color);
        this.focusedTextColor = color;
    }

    private void updateTextColor() {
        int color = !this.method_1882().isEmpty() || this.method_25370() ? this.focusedTextColor : this.hintColor;
        super.method_1868(color);
        this.method_1860(color);
    }

    public void setValueSilently(String value) {
        super.method_1863(null);
        this.method_1852(value != null ? value : "");
        this.updateTextColor();
        this.previousValue = this.method_1882();
        super.method_1863(this::onRespond);
    }

    private void onRespond(String value) {
        this.updateTextColor();
        if (!Objects.equals(this.previousValue, value)) {
            this.previousValue = value;
            for (Consumer<String> listener : this.listeners) {
                listener.accept(value);
            }
        }
    }

    public final void method_1863(Consumer<String> responder) {
        LogUtil.logUnsupported("Use addListener instead of setResponder.");
    }

    public void addListener(Consumer<String> listener) {
        this.listeners.add(listener);
    }

    public boolean method_1851() {
        return this.isEditing();
    }

    public boolean method_25370() {
        return this.isEditing() && super.method_25370();
    }

    public void method_25365(boolean focused) {
        super.method_25365(focused);
        this.updateTextColor();
    }

    @Override
    public boolean method_25405(double mouseX, double mouseY) {
        return this.method_1885() && Fidgetz.super.method_25405(mouseX, mouseY);
    }

    public boolean method_49606() {
        return this.isEditing() && super.method_49606();
    }

    public boolean method_37303() {
        return this.isEditing() && this.field_22763 && this.field_22764;
    }

    public void method_25348(double mouseX, double mouseY) {
        if (this.isEditing()) {
            super.method_25348(mouseX, mouseY);
        }
    }

    public void allowPastingSectionSign(boolean allow) {
        ((EditBoxAccess)((Object)this)).fidgetz$allowPastingSectionSign(allow);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.method_1882().isEmpty() && (keyCode == 263 || keyCode == 262)) {
            return false;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.field_22762 = this.field_22762 && Fidgetz.super.isHovered(mouseX, mouseY);
        super.method_48579(guiGraphics, mouseX, mouseY, partialTick);
    }

    @Override
    public E getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(E metadata) {
        this.metadata = metadata;
    }

    public static <E> Builder<E> builder(class_327 font) {
        return new Builder(font);
    }

    public static <E> Builder<E> builder() {
        return ToggleableEditBox.builder(class_310.method_1551().field_1772);
    }

    public static class Builder<E>
    extends AbstractWidgetBuilder<Builder<E>> {
        private final class_327 font;
        private final List<Consumer<String>> listeners = new ObjectArrayList();
        private final List<TextStylizer> textStylizers = new ObjectArrayList();
        private String value = "";
        private class_2561 hint = class_5244.field_39003;
        private boolean textShadow = true;
        private Integer textColor;
        private Integer hintColor;
        private boolean editable = false;
        private int maxLength = 32;
        private Predicate<String> filter;
        private E metadata;

        private Builder(class_327 font) {
            this.font = font;
        }

        public Builder<E> setValue(String value) {
            this.value = value;
            return this;
        }

        public Builder<E> setHint(class_2561 hint) {
            this.hint = hint;
            return this;
        }

        public Builder<E> setEditable(boolean editable) {
            this.editable = editable;
            return this;
        }

        public Builder<E> setTextShadow(boolean textShadow) {
            this.textShadow = textShadow;
            return this;
        }

        public Builder<E> setTextColor(Integer textColor) {
            this.textColor = textColor;
            return this;
        }

        public Builder<E> setHintColor(Integer hintColor) {
            this.hintColor = hintColor;
            return this;
        }

        public Builder<E> setMaxLength(int maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public Builder<E> setFilter(Predicate<String> filter) {
            this.filter = filter;
            return this;
        }

        public Builder<E> addListener(Consumer<String> listener) {
            this.listeners.add(listener);
            return this;
        }

        public Builder<E> addTextStylizer(TextStylizer textStylizer) {
            this.textStylizers.add(textStylizer);
            return this;
        }

        public Builder<E> addTextStylizer(Collection<TextStylizer> textStylizer) {
            this.textStylizers.addAll(textStylizer);
            return this;
        }

        public Builder<E> setMetadata(E metadata) {
            this.metadata = metadata;
            return this;
        }

        public ToggleableEditBox<E> build() {
            return new ToggleableEditBox(this);
        }
    }
}

