/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.components.pack;

import io.github.fishstiz.fidgetz.util.lang.CollectionsUtil;
import io.github.fishstiz.packed_packs.config.Config;
import io.github.fishstiz.packed_packs.gui.components.SelectableList;
import io.github.fishstiz.packed_packs.gui.components.pack.Query;
import io.github.fishstiz.packed_packs.gui.history.Restorable;
import io.github.fishstiz.packed_packs.pack.PackOptionsContext;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.ToIntFunction;
import net.minecraft.class_3288;
import org.jetbrains.annotations.NotNull;

public class PackListModel
extends SelectableList<class_3288>
implements Restorable<Snapshot> {
    private final PackOptionsContext options;
    private Query query = new Query();

    public PackListModel(PackOptionsContext options) {
        this.options = options;
    }

    private boolean updateQuery(Query query) {
        Query previousQuery = this.query;
        this.query = Objects.requireNonNull(query, "query");
        return !Objects.equals(this.query, previousQuery);
    }

    public boolean sort(Query.SortOption sort) {
        return this.updateQuery(this.query.withSort(sort));
    }

    public boolean search(String search) {
        return this.updateQuery(this.query.withSearch(search));
    }

    public boolean hideIncompatible(boolean hide) {
        return this.updateQuery(this.query.withHideIncompatible(hide));
    }

    public boolean isQueried() {
        return this.query.hasQuery();
    }

    @Override
    protected boolean filter(class_3288 pack) {
        if (!Config.get().isDevMode() && this.options.isHidden(pack)) {
            return false;
        }
        if (!this.query.test(pack)) {
            return false;
        }
        return super.filter(pack);
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.query.sort() != null) {
            this.visibleItems.sort(this.query);
        }
    }

    @Override
    public void add(class_3288 pack) {
        if (pack != null && !this.items.contains(pack)) {
            class_3288 p;
            int index = 0;
            Iterator iterator = this.items.iterator();
            while (iterator.hasNext() && this.options.isFixed(p = (class_3288)iterator.next()) && this.options.getPosition(p) != class_3288.class_3289.field_14281) {
                ++index;
            }
            this.items.add(index, pack);
        }
    }

    @Override
    public boolean move(int index, class_3288 pack) {
        return !this.options.isFixed(pack) && super.move(index, pack);
    }

    public boolean moveUp(class_3288 pack) {
        return this.movePack(this::getMoveUpIndex, pack);
    }

    public boolean moveDown(class_3288 pack) {
        return this.movePack(this::getMoveDownIndex, pack);
    }

    public List<class_3288> moveSelectionUp(List<class_3288> selection) {
        return this.moveSelection(this::getMoveUpIndex, this.orderByVisible(selection));
    }

    public List<class_3288> moveSelectionDown(List<class_3288> selection) {
        return this.moveSelection(this::getMoveDownIndex, (List<class_3288>)this.orderByVisible(selection).reversed());
    }

    private boolean movePack(ToIntFunction<class_3288> moveIndexFn, class_3288 pack) {
        if (this.items.contains(pack)) {
            int targetIndex = moveIndexFn.applyAsInt(pack);
            return targetIndex > -1 && this.move(targetIndex, pack);
        }
        return false;
    }

    private List<class_3288> moveSelection(ToIntFunction<class_3288> moveIndexFn, List<class_3288> selection) {
        ObjectArrayList moved = new ObjectArrayList();
        ObjectOpenHashSet packSet = new ObjectOpenHashSet((Collection)this.items);
        for (int i = 0; i < selection.size(); ++i) {
            class_3288 pack = selection.get(i);
            if (!packSet.contains(pack)) continue;
            int index = moveIndexFn.applyAsInt(pack);
            if (index > -1 && this.move(index, pack)) {
                moved.add(pack);
                continue;
            }
            if (i != 0) continue;
            return Collections.emptyList();
        }
        return moved;
    }

    public boolean canMoveUp(class_3288 pack) {
        List selection;
        if (!this.canMove(pack)) {
            return false;
        }
        if (this.isSelected(pack) && (selection = this.getOrderedSelection()).size() > 1) {
            int index = this.items.indexOf(selection.getFirst());
            int moveIndex = index > -1 ? this.getMoveUpIndex(pack) : -1;
            return index > 0 && moveIndex > -1 && !this.options.isFixed((class_3288)this.items.get(moveIndex));
        }
        int index = this.items.indexOf(pack);
        int moveIndex = this.getMoveUpIndex(pack);
        return index > 0 && moveIndex > -1 && !this.options.isFixed((class_3288)this.items.get(moveIndex));
    }

    public boolean canMoveDown(class_3288 pack) {
        List selection;
        if (!this.canMove(pack)) {
            return false;
        }
        int size = this.items.size();
        if (this.isSelected(pack) && (selection = this.getOrderedSelection()).size() > 1) {
            int index = this.items.indexOf(selection.getLast());
            int moveIndex = index > -1 ? this.getMoveDownIndex(pack) : -1;
            return index > -1 && index < size - 1 && moveIndex > -1 && !this.options.isFixed((class_3288)this.items.get(moveIndex));
        }
        int index = this.items.indexOf(pack);
        int moveIndex = this.getMoveDownIndex(pack);
        return index > -1 && index < size - 1 && moveIndex > -1 && !this.options.isFixed((class_3288)this.items.get(moveIndex));
    }

    private boolean canMove(class_3288 pack) {
        return !this.options.isLocked() && !this.options.isFixed(pack) && !this.isQueried();
    }

    private int getMoveUpIndex(class_3288 pack) {
        for (int i = this.items.indexOf(pack) - 1; i >= 0; --i) {
            class_3288 nextPack = (class_3288)this.items.get(i);
            if (this.options.isFixed(nextPack)) {
                return -1;
            }
            if (this.options.isHidden(nextPack)) continue;
            return i;
        }
        return -1;
    }

    private int getMoveDownIndex(class_3288 pack) {
        for (int i = this.items.indexOf(pack) + 1; i < this.items.size(); ++i) {
            class_3288 nextPack = (class_3288)this.items.get(i);
            if (this.options.isFixed(nextPack)) {
                return -1;
            }
            if (this.options.isHidden(nextPack)) continue;
            return i;
        }
        return -1;
    }

    public int clampPosition(int index) {
        if (index == -1) {
            int minIndex = 0;
            for (int i = 0; i < this.items.size(); ++i) {
                class_3288 pack = (class_3288)this.items.get(i);
                if (!this.options.isFixed(pack) || this.options.getPosition(pack) != class_3288.class_3289.field_14280) continue;
                minIndex = i + 1;
            }
            return minIndex;
        }
        return index;
    }

    public boolean isValidDropPosition(int index) {
        if (index < 0 || index > this.items.size()) {
            return false;
        }
        int minDropIndex = 0;
        int maxDropIndex = this.items.size();
        block4: for (int i = 0; i < this.items.size(); ++i) {
            class_3288 pack = (class_3288)this.items.get(i);
            if (!this.options.isFixed(pack)) continue;
            switch (this.options.getPosition(pack)) {
                case field_14280: {
                    minDropIndex = i + 1;
                    continue block4;
                }
                case field_14281: {
                    maxDropIndex = Math.min(i, maxDropIndex);
                }
            }
        }
        return index >= minDropIndex && index <= maxDropIndex;
    }

    @Override
    public void replaceState(@NotNull Snapshot snapshot) {
        this.replaceAll(snapshot.packs);
        this.clearSelection();
        this.selectedItems.addAll(snapshot.selection);
        this.query = new Query(snapshot.query);
        this.refresh();
    }

    @Override
    @NotNull
    public Snapshot captureState(String eventName) {
        return new Snapshot(this, List.copyOf(this.items), List.copyOf(this.selectedItems), new Query(this.query));
    }

    public static final class Snapshot
    extends Record
    implements Restorable.Snapshot<Snapshot> {
        private final PackListModel target;
        private final List<class_3288> packs;
        private final List<class_3288> selection;
        private final Query query;

        public Snapshot(PackListModel target, List<class_3288> packs, List<class_3288> selection, Query query) {
            this.target = target;
            this.packs = packs;
            this.selection = selection;
            this.query = query;
        }

        public Snapshot retainAll(Set<class_3288> validPacks) {
            ObjectArrayList packs = new ObjectArrayList(this.packs.size());
            CollectionsUtil.addIf(packs, this.packs, validPacks::contains);
            return new Snapshot(this.target, List.copyOf(packs), this.selection, this.query);
        }

        public Snapshot replaceAll(List<class_3288> packs) {
            return new Snapshot(this.target, List.copyOf(packs), this.selection, this.query);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Snapshot.class, "target;packs;selection;query", "target", "packs", "selection", "query"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Snapshot.class, "target;packs;selection;query", "target", "packs", "selection", "query"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Snapshot.class, "target;packs;selection;query", "target", "packs", "selection", "query"}, this, o);
        }

        public PackListModel target() {
            return this.target;
        }

        public List<class_3288> packs() {
            return this.packs;
        }

        public List<class_3288> selection() {
            return this.selection;
        }

        public Query query() {
            return this.query;
        }
    }
}

