package io.github.fishstiz.fidgetz.transform.mixin;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import io.github.fishstiz.fidgetz.gui.components.ToggleableEditBox;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_5481;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

import static io.github.fishstiz.fidgetz.util.DrawUtil.renderScrollingStringLeftAlign;

@Mixin(class_342.class)
public abstract class EditBoxMixin extends class_339 implements EditBoxAccess {
    protected EditBoxMixin(int x, int y, int width, int height, class_2561 message) {
        super(x, y, width, height, message);
    }

    @Shadow
    protected abstract boolean isEditable();

    @Shadow
    public abstract String getValue();

    @WrapOperation(method = "renderWidget", at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Lnet/minecraft/util/FormattedCharSequence;IIIZ)V",
            ordinal = 0
    ))
    public void drawScrollingString(class_332 guiGraphics, class_327 font, class_5481 text, int x, int y, int color, boolean shadow, Operation<Integer> original) {
        if ((class_342) (Object) this instanceof ToggleableEditBox && !this.isEditable()) {
            renderScrollingStringLeftAlign(
                    guiGraphics,
                    font,
                    class_2561.method_43470(this.getValue()),
                    this.method_46426(),
                    this.method_46427(),
                    this.method_55442(),
                    this.method_55443(),
                    color,
                    shadow
            );
            return;
        }

        original.call(guiGraphics, font, text, x, y, color, shadow);
    }

    @WrapWithCondition(method = "renderWidget", at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Lnet/minecraft/util/FormattedCharSequence;IIIZ)V",
            ordinal = 1
    ))
    public boolean isToggled(class_332 instance, class_327 font, class_5481 text, int x, int y, int color, boolean shadow) {
        return !((class_342) (Object) this instanceof ToggleableEditBox) || this.isEditable();
    }
}
