package io.github.fishstiz.fidgetz.gui.components.contextmenu;

import io.github.fishstiz.fidgetz.gui.renderables.RenderableRect;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import net.minecraft.class_2561;
import net.minecraft.class_5244;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

public interface MenuItem {
    MenuItem SEPARATOR = MenuItem.builder(class_5244.field_39003)
            .closeOnInteract(false)
            .autoSeparate(false)
            .build();

    class_2561 text();

    Runnable action();

    default @Nullable RenderableRect background() {
        return null;
    }

    default @Nullable Sprite icon() {
        return null;
    }

    default boolean shouldAutoSeparate() {
        return true;
    }

    default boolean shouldCloseOnInteract() {
        return true;
    }

    default boolean active() {
        return true;
    }

    default int textColor() {
        return this.active() ? class_9848.method_61317(1) : ContextMenu.DEFAULT_TEXT_INACTIVE_COLOR;
    }

    static MenuItemBuilder<?> builder(class_2561 text) {
        return new MenuItemBuilder<>(text);
    }
}
