package io.github.fishstiz.packed_packs.gui.components.events;

import com.google.common.collect.ImmutableList;
import io.github.fishstiz.packed_packs.gui.components.pack.PackList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Objects;
import net.minecraft.class_3288;

public final class RequestTransferEvent extends PackListEvent {
    private final ImmutableList<class_3288> payload;
    private final @Nullable class_3288 trigger;

    public RequestTransferEvent(PackList target, List<class_3288> payload, @Nullable class_3288 trigger) {
        super(target);

        if (Objects.requireNonNull(payload).isEmpty()) {
            throw new IllegalStateException("Payload cannot be empty");
        }

        this.payload = ImmutableList.copyOf(payload);
        this.trigger = trigger;
    }

    public RequestTransferEvent(PackList target, @NotNull class_3288 trigger) {
        super(target);

        this.payload = ImmutableList.of(trigger);
        this.trigger = Objects.requireNonNull(trigger);
    }

    @Override
    public boolean pushToHistory() {
        return true;
    }

    public ImmutableList<class_3288> payload() {
        return this.payload;
    }

    public @Nullable class_3288 trigger() {
        return this.trigger;
    }
}