package io.github.fishstiz.packed_packs.gui.layouts;

import io.github.fishstiz.fidgetz.gui.components.FidgetzText;
import io.github.fishstiz.fidgetz.gui.components.ToggleButton;
import io.github.fishstiz.packed_packs.PackedPacks;
import io.github.fishstiz.packed_packs.config.Config;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import io.github.fishstiz.packed_packs.util.constants.GuiConstants;
import io.github.fishstiz.packed_packs.util.constants.Theme;
import net.minecraft.class_2561;
import net.minecraft.class_7847;
import net.minecraft.class_7919;
import net.minecraft.class_8667;

public class OptionsLayout {
    private static final int CONTENT_WIDTH = 175;
    private static final int DEFAULT_LABEL_COLOR = Theme.GRAY_800.getARGB();
    private static final class_2561 REPLACE_SCREEN_TEXT = ResourceUtil.getText("options.replace_screen");
    private static final Config.ResourcePacks RESOURCEPACKS = PackedPacks.CONFIG.getResourcepacks();
    private static final Config.Packs DATAPACKS = PackedPacks.CONFIG.getDatapacks();
    private final class_8667 layout;

    public OptionsLayout(int labelColor) {
        final int spacing = GuiConstants.SPACING;
        this.layout = class_8667.method_52741();
        class_7847 layoutSettings = class_7847.method_46481().method_46477(spacing).method_46471(spacing);

        this.layout.method_52737(
                FidgetzText.<Void>builder()
                        .setMessage(ResourceUtil.getText("resource_packs").method_54663(labelColor))
                        .alignLeft()
                        .build(),
                layoutSettings.method_46478().method_46471((spacing * 2) - spacing / 2)
        );
        this.layout.method_52737(
                ToggleButton.<Void>builder()
                        .setMessage(REPLACE_SCREEN_TEXT)
                        .setValue(RESOURCEPACKS.isReplaceOriginal())
                        .setOnPress(() -> RESOURCEPACKS.setReplaceOriginal(!RESOURCEPACKS.isReplaceOriginal()))
                        .build(),
                layoutSettings
        );
        this.layout.method_52737(
                ToggleButton.<Void>builder()
                        .setMessage(ResourceUtil.getText("options.hide_incompatible_warnings"))
                        .setTooltip(class_7919.method_47407(ResourceUtil.getText("options.hide_incompatible_warnings.info")))
                        .setValue(RESOURCEPACKS.isIncompatibleWarningsHidden())
                        .setOnPress(() -> RESOURCEPACKS.setHideIncompatibleWarnings(!RESOURCEPACKS.isIncompatibleWarningsHidden()))
                        .build(),
                layoutSettings
        );
        this.layout.method_52737(
                ToggleButton.<Void>builder()
                        .setMessage(ResourceUtil.getText("options.apply_on_close"))
                        .setValue(RESOURCEPACKS.isApplyOnClose())
                        .setOnPress(() -> RESOURCEPACKS.setApplyOnClose(!RESOURCEPACKS.isApplyOnClose()))
                        .build(),
                layoutSettings
        );

        this.layout.method_52737(
                FidgetzText.<Void>builder()
                        .setMessage(class_2561.method_43471("selectWorld.dataPacks").method_54663(labelColor))
                        .alignLeft()
                        .build(),
                layoutSettings.method_46478().method_46471(spacing * 2)
        );
        this.layout.method_52737(
                ToggleButton.<Void>builder()
                        .setValue(DATAPACKS.isReplaceOriginal())
                        .setOnPress(() -> DATAPACKS.setReplaceOriginal(!DATAPACKS.isReplaceOriginal()))
                        .setMessage(REPLACE_SCREEN_TEXT)
                        .build(),
                layoutSettings
        );
        this.layout.method_52737(
                ToggleButton.<Void>builder()
                        .setMessage(ResourceUtil.getText("options.hide_incompatible_warnings"))
                        .setTooltip(class_7919.method_47407(ResourceUtil.getText("options.hide_incompatible_warnings.info")))
                        .setValue(DATAPACKS.isIncompatibleWarningsHidden())
                        .setOnPress(() -> DATAPACKS.setHideIncompatibleWarnings(!DATAPACKS.isIncompatibleWarningsHidden()))
                        .build(),
                layoutSettings.method_46478().method_46475((spacing * 2) - spacing / 2)
        );

        this.layout.method_48206(widget -> widget.method_25358(CONTENT_WIDTH));
        this.layout.method_48222();
    }

    public OptionsLayout() {
        this(DEFAULT_LABEL_COLOR);
    }

    public class_8667 layout() {
        return this.layout;
    }
}
