package io.github.fishstiz.packed_packs.transform.mixin;

import io.github.fishstiz.packed_packs.transform.interfaces.IPackSelectionModel;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Accessor;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_3283;
import net.minecraft.class_3288;
import net.minecraft.class_5369;

/**
 * fabric workaround
 *
 * @see
 * <a href="https://github.com/FabricMC/fabric/blob/1.21.1/fabric-resource-loader-v0/src/client/java/net/fabricmc/fabric/mixin/resource/loader/client/ResourcePackOrganizerMixin.java#L37">
 * ResourcePackOrganizerMixin
 * </a>
 */
@Mixin(class_5369.class)
public interface PackSelectionModelAccessor extends IPackSelectionModel {
    @Accessor("selected")
    List<class_3288> getSelectedPacks();

    @Accessor("unselected")
    List<class_3288> getUnselectedPacks();

    @Accessor("repository")
    class_3283 packed_packs$getRepository();

    @Accessor("output")
    Consumer<class_3283> packed_packs$getOutput();
}
