/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.fidgetz.gui.components.contextmenu;

import com.google.common.util.concurrent.Runnables;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenu;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.MenuItem;
import io.github.fishstiz.fidgetz.gui.renderables.ColoredRect;
import io.github.fishstiz.fidgetz.gui.renderables.RenderableRect;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

public class MenuItemBuilder<B extends MenuItemBuilder<B>> {
    protected final class_2561 text;
    protected Runnable action = Runnables.doNothing();
    protected RenderableRect background;
    protected Supplier<@Nullable Sprite> iconSupplier;
    protected boolean shouldCloseOnInteract = true;
    protected boolean shouldAutoSeparate = true;
    protected BooleanSupplier activeSupplier;
    protected IntSupplier textColorSupplier;

    protected MenuItemBuilder(class_2561 text) {
        this.text = text;
    }

    protected B self() {
        return (B)this;
    }

    public B action(Runnable action) {
        this.action = action;
        return this.self();
    }

    public B background(@Nullable RenderableRect background) {
        this.background = background;
        return this.self();
    }

    public B background(int backgroundColor) {
        this.background = new ColoredRect(backgroundColor);
        return this.self();
    }

    public B icon(@Nullable Sprite icon) {
        this.iconSupplier = () -> icon;
        return this.self();
    }

    public B icon(Supplier<@Nullable Sprite> icon) {
        this.iconSupplier = icon;
        return this.self();
    }

    public B closeOnInteract(boolean value) {
        this.shouldCloseOnInteract = value;
        return this.self();
    }

    public B autoSeparate(boolean value) {
        this.shouldAutoSeparate = value;
        return this.self();
    }

    public B activeWhen(BooleanSupplier activeSupplier) {
        this.activeSupplier = activeSupplier;
        return this.self();
    }

    public B textColor(IntSupplier textColorSupplier) {
        this.textColorSupplier = textColorSupplier;
        return this.self();
    }

    public B textColor(int textColor) {
        this.textColorSupplier = () -> textColor;
        return this.self();
    }

    protected void setDefaults() {
        if (this.activeSupplier == null) {
            this.activeSupplier = () -> true;
        }
        if (this.textColorSupplier == null) {
            this.textColorSupplier = () -> this.activeSupplier.getAsBoolean() ? class_9848.method_61317((float)1.0f) : ContextMenu.DEFAULT_TEXT_INACTIVE_COLOR;
        }
        if (this.iconSupplier == null) {
            this.iconSupplier = () -> null;
        }
    }

    public MenuItem build() {
        this.setDefaults();
        return new MenuItemImpl(this.text, this.action, this.background, this.iconSupplier, this.shouldCloseOnInteract, this.shouldAutoSeparate, this.activeSupplier, this.textColorSupplier);
    }

    private record MenuItemImpl(class_2561 text, Runnable action, RenderableRect background, Supplier<@Nullable Sprite> iconSupplier, boolean shouldCloseOnInteract, boolean shouldAutoSeparate, BooleanSupplier activeSupplier, IntSupplier textColorSupplier) implements MenuItem
    {
        @Override
        public boolean active() {
            return this.activeSupplier.getAsBoolean();
        }

        @Override
        public int textColor() {
            return this.textColorSupplier.getAsInt();
        }

        @Override
        @Nullable
        public Sprite icon() {
            return this.iconSupplier.get();
        }
    }
}

